package com.biz.crm.finance.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.acceptanceform.mapper.KmsAcceptanceFormMapper;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.kms.KmsEnum;
import com.biz.crm.finance.helper.KmsAuditFormHelper;
import com.biz.crm.finance.mapper.*;
import com.biz.crm.finance.model.KmsAuditFormEntity;
import com.biz.crm.finance.model.KmsAuditMatchRelationEntity;
import com.biz.crm.finance.service.IKmsAuditFormService;
import com.biz.crm.finance.service.IKmsAuditMatchRelationService;
import com.biz.crm.finance.service.IKmsAuditTemplateService;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mdm.terminal.MdmTerminalSupplyFeign;
import com.biz.crm.nebular.kms.acceptanceform.req.KmsAcceptanceFormReqVo;
import com.biz.crm.nebular.kms.acceptanceform.resp.KmsAuditAcceptanceFormRespVo;
import com.biz.crm.nebular.kms.finance.req.KmsAuditFormReqVo;
import com.biz.crm.nebular.kms.finance.req.KmsAuditTemplateReqVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAcceptanceMatchRelationRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditFormExportRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditFormRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditTemplateRespVo;
import com.biz.crm.nebular.kms.sap.req.KmsSapOrderFormReqVo;
import com.biz.crm.nebular.kms.sap.resp.KmsSapInvoiceRespVo;
import com.biz.crm.nebular.kms.sap.resp.KmsSapOrderFormRespVo;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectStoreReqVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsTenantryDirectCustomerOrgRespVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsTenantryDirectStoreRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerRespVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgSearchReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.sap.helper.KmsSapHelper;
import com.biz.crm.sap.mapper.KmsSapInvoiceMapper;
import com.biz.crm.sap.model.KmsSapInvoiceEntity;
import com.biz.crm.sap.service.IKmsSapInvoiceService;
import com.biz.crm.supermarket.mapper.KmsTenantryDirectCustomerOrgMapper;
import com.biz.crm.supermarket.mapper.KmsTenantryDirectStoreMapper;
import com.biz.crm.supermarket.model.KmsTenantryDirectCustomerOrgEntity;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 稽核数据接口实现
 *
 * @author Gavin
 * @date 2021-05-27 11:09:31
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "KmsAuditFormServiceExpandImpl")
public class KmsAuditFormServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<KmsAuditFormMapper, KmsAuditFormEntity> implements IKmsAuditFormService {

    @Resource
    private KmsAuditFormMapper kmsAuditFormMapper;

    @Resource
    private KmsAcceptanceFormMapper kmsAcceptanceFormMapper;

    @Resource
    private KmsSapHelper kmsSapHelper;

    @Resource
    private KmsSapInvoiceMapper kmsSapInvoiceMapper;

    @Resource
    private IKmsSapInvoiceService kmsSapInvoiceService;

    @Resource
    private MdmOrgFeign mdmOrgFeign;

    @Resource
    private KmsAuditFormHelper kmsAuditFormHelper;

    @Resource
    private KmsAuditTemplateMapper kmsAuditTemplateMapper;

    @Resource
    private IKmsAuditTemplateService kmsAuditTemplateService;

    @Resource
    private KmsTenantryDirectStoreMapper kmsTenantryDirectStoreMapper;

    @Resource
    private KmsAcceptanceMatchRelationMapper kmsAcceptanceMatchRelationMapper;

    @Resource
    private KmsAuditMatchRelationMapper kmsAuditMatchRelationMapper;

    @Resource
    private IKmsAuditMatchRelationService kmsAuditMatchRelationService;

    @Resource
    private MdmTerminalSupplyFeign mdmTerminalSupplyFeign;

    @Resource
    private KmsTenantryDirectCustomerOrgMapper tenantryDirectCustomerOrgMapper;

    @Resource
    private KmsAuditTemplateDirectMapper kmsAuditTemplateDirectMapper;

    @Resource
    private CrmLogSendUtil crmLogSendUtil;


    /**
     * 抽取发票类型
     * ZRE 新希望乳业销售退货
     * ZF2 新希望乳业标准销售订单
     * 数据字典
     */
    private static final String KMS_FKART_TYPE = "kms_sap_invoice_fkart_type";

    private static final String KMS_SAP_BUKRS = "kms_sap_invoice_bukrs";

    /**
     * 列表
     *
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<KmsAuditFormRespVo> findList(KmsAuditFormReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getAuditTemplateId(), "匹配模版ID[auditTemplateId]不能为空");
        if (StringUtils.isNotEmpty(reqVo.getSapPostingDateStart())) {
            reqVo.setSapPostingDateStart(format(reqVo.getSapPostingDateStart()));
        }
        if (StringUtils.isNotEmpty(reqVo.getSapPostingDateEnd())) {
            reqVo.setSapPostingDateEnd(format(reqVo.getSapPostingDateEnd()));
        }
        Page<KmsAuditFormRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<KmsAuditFormRespVo> list = kmsAuditFormMapper.findList(page, reqVo);
        KmsAuditTemplateReqVo templateReqVo = new KmsAuditTemplateReqVo();
        templateReqVo.setId(reqVo.getAuditTemplateId());
        KmsAuditTemplateRespVo templateRespVo = kmsAuditTemplateService.query(templateReqVo);
        //查询当前创建者所属公司
        List<String> orgCodes = list.stream().map(KmsAuditFormRespVo::getOrgCode)
                .distinct().collect(Collectors.toList());
        List<MdmOrgRespVo> orgByCodeList = OrgUtil.getOrgByCodeList(orgCodes);
        Map<String, String> orgCompanyMap = orgByCodeList.stream()
                .collect(Collectors.toMap(MdmOrgRespVo::getOrgCode, MdmOrgRespVo::getOrgName));
        //根据稽核ID集合批量查询稽核单关联的SAP数据
        List<String> auditIds = list.stream().map(KmsAuditFormRespVo::getId).collect(Collectors.toList());
        List<KmsSapOrderFormRespVo> sapFormVoArray = org.springframework.util.CollectionUtils.isEmpty(auditIds)
                ? Lists.newArrayList() : kmsSapInvoiceMapper.findByAuditFormAuditIds(auditIds);
        Map<String, List<KmsSapOrderFormRespVo>> sapFormMap = sapFormVoArray.stream()
                .collect(Collectors.groupingBy(KmsSapOrderFormRespVo::getAuditId));
        //根据稽核ID集合批量查询已匹配验收单集合
        reqVo.setIds(auditIds);
        List<KmsAuditAcceptanceFormRespVo> acceptanceFormSuccRespVos = org.springframework.util.CollectionUtils.isEmpty(auditIds)
                ? Lists.newArrayList() : kmsAuditFormHelper.matchDataSuccList(reqVo, templateRespVo);
        Map<String, List<KmsAuditAcceptanceFormRespVo>> acceptanceFormSuccMap = acceptanceFormSuccRespVos.stream()
                .collect(Collectors.groupingBy(KmsAuditAcceptanceFormRespVo::getAuditId));
        //数据处理
        list.forEach(o -> {
            o.setOwnedCompany(orgCompanyMap.get(o.getOrgCode()));
            //根据稽核ID查询关联SAP数据
            List<KmsSapOrderFormRespVo> sapFormVos = sapFormMap.get(o.getId());
            if (!org.springframework.util.CollectionUtils.isEmpty(sapFormVos)) {
                o.setSapOrderFormVos(sapFormVos);
                KmsSapOrderFormRespVo sapInfo = sapFormVos.get(0);
                if (StringUtils.isEmpty(o.getSoldToPartyCode())) {
                    o.setSoldToPartyCode(sapInfo.getKunag());
                    o.setSoldToPartyName(sapInfo.getKunagname());
                }
            }
            o.setSapPostingDateExport(DateUtil.format(DateUtil.getDateByFormat(
                    o.getSapPostingDate(), DateUtil.DEFAULT_MONTH_DAY_PATTERN),
                    DateUtil.DEFAULT_DAY_PATTERN));
            //根据稽核ID查询关联验收单数据信息
            //已匹配数据信息
            List<KmsAuditAcceptanceFormRespVo> acceptanceFormVos = org.springframework.util.CollectionUtils.isEmpty(acceptanceFormSuccMap.get(o.getId()))
                    ? Lists.newArrayList() : acceptanceFormSuccMap.get(o.getId());
            o.setAcceptanceFormVos(acceptanceFormVos);
            String auditResult = o.getAuditResult();
            KmsUtils.sapInvoiceData(o);
            //验收单价（验收含税/验收数量）
            BigDecimal acceptanceQuantity = o.getAcceptanceQuantity();
            BigDecimal acceptanceAmount = o.getAcceptanceAmount();
            if (!org.springframework.util.ObjectUtils.isEmpty(acceptanceAmount)
                    && !org.springframework.util.ObjectUtils.isEmpty(acceptanceQuantity) && acceptanceQuantity.compareTo(BigDecimal.ZERO) == 1) {
                o.setAcceptanceDanJia(acceptanceAmount.divide(acceptanceQuantity, 2, BigDecimal.ROUND_HALF_UP));
            }
            o.setAuditResult(auditResult);
            //保留两位小数
            KmsUtils.setScaleTwo(o);
            //
            if (CollectionUtil.listNotEmptyNotSizeZero(acceptanceFormVos)) {
                List<String> accDate = acceptanceFormVos.stream().map(KmsAuditAcceptanceFormRespVo::getAcceptanceDate)
                        .distinct().collect(Collectors.toList());
                if (accDate.size() == 1) {
                    o.setAcceptanceDate(acceptanceFormVos.get(0).getAcceptanceDate());
                }
            }
        });
        return PageResult.<KmsAuditFormRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();

    }

    /**
     * 未匹配验收单查询稽核匹配列表
     *
     * @param kmsAuditFormReqVo
     * @return
     */
    @Override
    public PageResult<KmsAuditFormRespVo> selectMatchList(KmsAuditFormReqVo kmsAuditFormReqVo) {
        return findList(kmsAuditFormReqVo);
    }

    /**
     * 稽核匹配汇总列表
     *
     * @param kmsAuditFormReqVo
     * @return
     */
    @Override
    public PageResult<KmsAuditFormRespVo> matchSummaryReport(KmsAuditFormReqVo params) {
        AssertUtils.isNotEmpty(params.getAuditTemplateId(), "匹配模版ID不能为空");
        AssertUtils.isNotEmpty(params.getSapPostingDateStart(), "SAP开始日期不能为空");
        AssertUtils.isNotEmpty(params.getSapPostingDateEnd(), "SAP结束日期不能为空");
        SimpleDateFormat date_sdf_2 = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat date_sdf = new SimpleDateFormat("yyyyMMdd");
        if (StringUtils.isNotEmpty(params.getSapPostingDateStart())) {
            String sapPostingDateStart = params.getSapPostingDateStart();
            params.setAcceptanceDateStart(sapPostingDateStart);
            Date date = DateUtil.str2Date(sapPostingDateStart, date_sdf_2);
            params.setSapPostingDateStart(DateUtil.date2Str(date, date_sdf));
        }
        if (StringUtils.isNotEmpty(params.getSapPostingDateEnd())) {
            String sapPostingDateEnd = params.getSapPostingDateEnd();
            params.setAcceptanceDateEnd(sapPostingDateEnd);
            Date date = DateUtil.str2Date(sapPostingDateEnd, date_sdf_2);
            params.setSapPostingDateEnd(DateUtil.date2Str(date, date_sdf));
        }
        //稽核模版查询直营体系
        List<KmsTenantryDirectCustomerOrgRespVo> directCustomerOrgRespVos = kmsAuditTemplateDirectMapper
                .findSystemDirectList(params.getAuditTemplateId());
        List<String> bsDirectSystemIds = directCustomerOrgRespVos.stream()
                .map(KmsTenantryDirectCustomerOrgRespVo::getBsDirectSystemId).collect(Collectors.toList());
        params.setBsDirectSystemIds(bsDirectSystemIds);
        Page<KmsAuditFormRespVo> page = PageUtil.buildPage(params.getPageNum(), params.getPageSize());
        List<KmsAuditFormRespVo> list = kmsAuditFormMapper.matchSummaryReport(page, params);
        //查询当前创建者所属公司
        /*List<String> orgCodes = list.stream().map(KmsAuditFormRespVo::getOrgCode)
                .distinct().collect(Collectors.toList());
        List<MdmOrgRespVo> orgByCodeList = OrgUtil.getOrgByCodeList(orgCodes);
        Map<String, String> orgCompanyMap = orgByCodeList.stream()
                .collect(Collectors.toMap(MdmOrgRespVo::getOrgCode, MdmOrgRespVo::getOrgName));*/
        //数据处理
        list.forEach(o -> {
            //o.setOwnedCompany(orgCompanyMap.get(o.getOrgCode()));
            //稽核结果
            String auditRule = o.getAuditRule();
            BigDecimal differencePrice = o.getDifferencePrice();
            //含税价格差值
            BigDecimal sub = o.getAcceptanceAmount().subtract(o.getSapAmount());
            BigDecimal priceDiff = sub.multiply(new BigDecimal(-1));
            o.setCompareAmount(sub);
            //不含税价格差值
            BigDecimal subNot = o.getAcceptanceAmountNot().subtract(o.getSapAmountNot());
            o.setCompareAmountNot(subNot);
            //数量差额
            BigDecimal subQuantity = o.getAcceptanceQuantity().subtract(o.getSapQuantity());
            o.setCompareQuantity(subQuantity);
        });
        return PageResult.<KmsAuditFormRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 稽核匹配汇总
     *
     * @param kmsAuditFormReqVo
     * @return
     */
    @Override
    public KmsAuditFormRespVo matchSummaryTotalCount(KmsAuditFormReqVo params) {
        AssertUtils.isNotEmpty(params.getAuditTemplateId(), "匹配模版ID不能为空");
        AssertUtils.isNotEmpty(params.getSapPostingDateStart(), "SAP开始日期不能为空");
        AssertUtils.isNotEmpty(params.getSapPostingDateEnd(), "SAP结束日期不能为空");
        SimpleDateFormat date_sdf_2 = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat date_sdf = new SimpleDateFormat("yyyyMMdd");
        if (StringUtils.isNotEmpty(params.getSapPostingDateStart())) {
            String sapPostingDateStart = params.getSapPostingDateStart();
            params.setAcceptanceDateStart(sapPostingDateStart);
            Date date = DateUtil.str2Date(sapPostingDateStart, date_sdf_2);
            params.setSapPostingDateStart(DateUtil.date2Str(date, date_sdf));
        }
        if (StringUtils.isNotEmpty(params.getSapPostingDateEnd())) {
            String sapPostingDateEnd = params.getSapPostingDateEnd();
            params.setAcceptanceDateEnd(sapPostingDateEnd);
            Date date = DateUtil.str2Date(sapPostingDateEnd, date_sdf_2);
            params.setSapPostingDateEnd(DateUtil.date2Str(date, date_sdf));
        }
        //稽核模版查询直营体系
        List<KmsTenantryDirectCustomerOrgRespVo> directCustomerOrgRespVos = kmsAuditTemplateDirectMapper
                .findSystemDirectList(params.getAuditTemplateId());
        List<String> bsDirectSystemIds = directCustomerOrgRespVos.stream()
                .map(KmsTenantryDirectCustomerOrgRespVo::getBsDirectSystemId).collect(Collectors.toList());
        params.setBsDirectSystemIds(bsDirectSystemIds);
        KmsAuditFormRespVo respVo = kmsAuditFormMapper.matchSummaryTotalCount(params);
        if (respVo != null) {
            //含税价格差值
            respVo.setCompareAmount(respVo.getSapAmount().subtract(respVo.getAcceptanceAmount()));
            //不含税价格差值
            respVo.setCompareAmountNot(respVo.getSapAmountNot().subtract(respVo.getAcceptanceAmountNot()));
            //数量差额
            respVo.setCompareQuantity(respVo.getSapQuantity().subtract(respVo.getAcceptanceQuantity()));
            //设置保留两位小数
            KmsUtils.setScaleTwo(respVo);
        }

        return respVo;
    }

    /**
     * 稽核匹配导出
     *
     * @param kmsAuditFormReqVo
     * @return
     */
    @Override
    public PageResult<KmsAuditFormExportRespVo> auditExport(KmsAuditFormReqVo params) {
        AssertUtils.isNotEmpty(params.getSapPostingDateStart(), "sap过账开始日期不能为空");
        AssertUtils.isNotEmpty(params.getSapPostingDateStart(), "sap过账结束日期不能为空");
        PageResult<KmsAuditFormRespVo> list = this.findList(params);
        //导出数据封装
        List<KmsAuditFormExportRespVo> exportRespVos = kmsAuditFormHelper.buildAuditExport(list.getData());
        return PageResult.<KmsAuditFormExportRespVo>builder()
                .data(exportRespVos)
                .count(list.getCount())
                .build();
    }

    /**
     * 查询
     *
     * @param reqVo
     * @return kmsAuditFormRespVo
     */
    @Override
    public KmsAuditFormRespVo query(KmsAuditFormReqVo reqVo) {
        String auditFormId = reqVo.getId();
        AssertUtils.isNotEmpty(auditFormId, "请选择数据");
        KmsAuditFormEntity byId = this.getById(auditFormId);
        if (ObjectUtils.isEmpty(byId)) {
            throw new BusinessException("未查询到数据信息");
        }
        KmsAuditFormRespVo respVo = CrmBeanUtil.copy(byId, KmsAuditFormRespVo.class);
        //根据稽核ID查询关联SAP数据
        List<KmsSapOrderFormRespVo> sapFormVos = kmsSapInvoiceMapper.findByAuditFormId(auditFormId);
        sapFormVos.forEach(o -> {
            o.setSapMaterielCode(KmsUtils.removeFrontZero(o.getSapMaterielCode()));
        });
        respVo.setSapOrderFormVos(sapFormVos);
        //根据稽核ID查询关联验收单数据信息
        String auditTemplateId = respVo.getAuditTemplateId();
        KmsAuditTemplateReqVo templateReqVo = new KmsAuditTemplateReqVo();
        templateReqVo.setId(respVo.getAuditTemplateId());
        KmsAuditTemplateRespVo templateRespVo = kmsAuditTemplateService.query(templateReqVo);
        //已匹配数据信息
        kmsAuditFormHelper.matchDataSucc(respVo, templateRespVo);
        //数据处理
        KmsUtils.sapInvoiceData(respVo);
        //respVo.setAcceptanceFormVos(Lists.newArrayList());
        //设置保留两位小数
        KmsUtils.setScaleTwo(respVo);
        return respVo;
    }

    /**
     * 查询已匹配验收单数据列表
     *
     * @param kmsAuditFormReqVo
     * @return
     */
    @Override
    public PageResult<KmsAuditAcceptanceFormRespVo> matchedAcc(KmsAuditFormReqVo kmsAuditFormReqVo) {
        String auditFormId = kmsAuditFormReqVo.getId();
        AssertUtils.isNotEmpty(auditFormId, "请选择数据");
        KmsAuditFormEntity byId = this.getById(auditFormId);
        if (ObjectUtils.isEmpty(byId)) {
            throw new BusinessException("未查询到数据信息");
        }
        KmsAuditFormRespVo respVo = CrmBeanUtil.copy(byId, KmsAuditFormRespVo.class);
        //根据稽核ID查询关联SAP数据
        List<KmsSapOrderFormRespVo> sapFormVos = kmsSapInvoiceMapper.findByAuditFormId(auditFormId);
        sapFormVos.forEach(o -> {
            o.setSapMaterielCode(KmsUtils.removeFrontZero(o.getSapMaterielCode()));
        });
        respVo.setSapOrderFormVos(sapFormVos);
        //根据稽核ID查询关联验收单数据信息
        String auditTemplateId = respVo.getAuditTemplateId();
        KmsAuditTemplateReqVo templateReqVo = new KmsAuditTemplateReqVo();
        templateReqVo.setId(respVo.getAuditTemplateId());
        KmsAuditTemplateRespVo templateRespVo = kmsAuditTemplateService.query(templateReqVo);
        //查询已匹配验收单数据列表
        PageResult<KmsAuditAcceptanceFormRespVo> result = kmsAuditFormHelper.matchedAcc(kmsAuditFormReqVo, respVo, templateRespVo);
        //数据处理
        respVo.setAcceptanceFormVos(result.getData());
        KmsUtils.sapInvoiceData(respVo);
        //设置保留两位小数
        KmsUtils.setScaleTwo(respVo);
        result.setData(respVo.getAcceptanceFormVos());
        if (!org.springframework.util.CollectionUtils.isEmpty(result.getData())) {
            result.getData().forEach(a -> {
                //单价
                BigDecimal acceptanceAmount = org.springframework.util.StringUtils.isEmpty(a.getAcceptanceAmount()) ? null : new BigDecimal(a.getAcceptanceAmount());
                BigDecimal acceptanceQuantity = org.springframework.util.StringUtils.isEmpty(a.getAcceptanceQuantity()) ? null : new BigDecimal(a.getAcceptanceQuantity());
                if (!org.springframework.util.ObjectUtils.isEmpty(acceptanceAmount)
                        && !org.springframework.util.ObjectUtils.isEmpty(acceptanceQuantity) && acceptanceQuantity.compareTo(BigDecimal.ZERO) == 1) {
                    a.setDanjia(acceptanceAmount.divide(acceptanceQuantity, 2, BigDecimal.ROUND_HALF_UP));
                }
            });
        }
        return result;
    }

    /**
     * 新增
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(KmsAuditFormReqVo reqVo) {
        KmsAuditFormEntity entity = CrmBeanUtil.copy(reqVo, KmsAuditFormEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(KmsAuditFormReqVo reqVo) {
        KmsAuditFormEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 确认
     *
     * @param ids
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void confirm(List<String> ids) {
        AssertUtils.isNotEmpty(ids, "请选择数据");
        List<KmsAuditFormEntity> kmsAuditFormEntities = this.listByIds(ids);
        UserRedis user = UserUtils.getUser();
        kmsAuditFormEntities.forEach(o -> {
            o.setAuditStatus(KmsEnum.AuditStatus.CONFIRMED.getValue());
            o.setRinisher(user.getRealname());
            o.setCompletionDate(DateUtil.formatDate());
        });
        this.updateBatchById(kmsAuditFormEntities);
    }

    /**
     * 根据ID查询稽核数据
     *
     * @param ids
     * @return
     */
    @Override
    public List<KmsAuditFormRespVo> findListByIds(List<String> ids) {
        KmsAuditFormReqVo formReqVo = new KmsAuditFormReqVo();
        formReqVo.setIds(ids);
        formReqVo.setDesc("ASC");
        return kmsAuditFormMapper.findList(formReqVo);
    }

    /**
     * 取消确认
     *
     * @param ids
     */
    @Override
    public void cancelConfirm(List<String> ids) {
        AssertUtils.isNotEmpty(ids, "请选择数据");
        List<KmsAuditFormEntity> kmsAuditFormEntities = this.listByIds(ids);
        kmsAuditFormEntities.forEach(o -> {
            o.setAuditStatus(KmsEnum.AuditStatus.WAIT.getValue());
            o.setRinisher(null);
            o.setCompletionDate(null);
        });
        this.updateBatchById(kmsAuditFormEntities);
    }

    /**
     * 未匹配验收单列表
     *
     * @param kmsAuditFormReqVo
     * @return
     */
    @Override
    public PageResult<KmsAuditAcceptanceFormRespVo> notmatchedAcceptanceFormList(KmsAcceptanceFormReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getAuditTemplateId(), "匹配模版ID不能为空");
        Page<KmsAuditAcceptanceFormRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<KmsAuditAcceptanceFormRespVo> list = kmsAuditFormHelper.notmatchedAcceptanceFormList(page, reqVo);
        return PageResult.<KmsAuditAcceptanceFormRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 删除
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(KmsAuditFormReqVo reqVo) {
        KmsAuditFormEntity entity = kmsAuditFormMapper.selectById(reqVo.getId());
        //查询关联的验收单
        List<KmsAcceptanceMatchRelationRespVo> matchList = kmsAcceptanceMatchRelationMapper.findMatchList(reqVo);
        if (!org.springframework.util.CollectionUtils.isEmpty(matchList)) {
            List<String> accIds = matchList.stream().map(KmsAcceptanceMatchRelationRespVo::getRelationId)
                    .collect(Collectors.toList());
            KmsAuditFormRespVo afVo = CrmBeanUtil.copy(entity, KmsAuditFormRespVo.class);
            //稽核模版
            String auditTemplateId = afVo.getAuditTemplateId();
            KmsAuditTemplateReqVo templateReqVo = new KmsAuditTemplateReqVo();
            templateReqVo.setId(auditTemplateId);
            KmsAuditTemplateRespVo templateRespVo = kmsAuditTemplateService.query(templateReqVo);
            kmsAuditFormHelper.findMatchDataByIds(accIds, afVo, templateRespVo);
            //取消数据绑定
            kmsAuditFormHelper.cancelMatchData(accIds, afVo, templateRespVo);
        }
        //批量删除关系表
        kmsAuditMatchRelationService.lambdaUpdate()
                .eq(KmsAuditMatchRelationEntity::getAuditId, reqVo.getId())
                .remove();
        kmsAuditFormMapper.deleteById(reqVo.getId());
    }

    /**
     * 启用
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(KmsAuditFormReqVo reqVo) {
        //设置状态为启用
        List<KmsAuditFormEntity> kmsAuditFormEntities = kmsAuditFormMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty(kmsAuditFormEntities)) {
            kmsAuditFormEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(kmsAuditFormEntities);
    }

    /**
     * 禁用
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(KmsAuditFormReqVo reqVo) {
        //设置状态为禁用
        List<KmsAuditFormEntity> kmsAuditFormEntities = kmsAuditFormMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty(kmsAuditFormEntities)) {
            kmsAuditFormEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(kmsAuditFormEntities);
    }

    /**
     * 添加备注
     *
     * @param kmsAuditFormReqVo
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void addRemark(KmsAuditFormReqVo kmsAuditFormReqVo) {
        AssertUtils.isNotEmpty(kmsAuditFormReqVo.getId(), "请选择数据");
        AssertUtils.isNotEmpty(kmsAuditFormReqVo.getRemarks(), "请填写备注信息");
        KmsAuditFormEntity kmsAuditFormEntity = kmsAuditFormMapper.selectById(kmsAuditFormReqVo.getId());
        if (ObjectUtils.isEmpty(kmsAuditFormEntity)) {
            throw new BusinessException("未查询到数据信息");
        }
        kmsAuditFormEntity.setRemarks(kmsAuditFormReqVo.getRemarks());
        this.updateById(kmsAuditFormEntity);
    }

    /**
     * 拉取SAP数据 (一家公司一家公司的处理)
     * 一家商超一家商超的抓取
     *
     * @param kmsSapOrderFormReqVo
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void pullSap(KmsSapOrderFormReqVo reqVo) {
        //抓取门店
        List<String> storeCodes = Lists.newArrayList();
        //抓取售达方
        List<String> soldToPartyCodes = Lists.newArrayList();
        if (!StringUtils.isEmpty(reqVo.getSelectedCode())) {
            storeCodes.add("'" + KmsUtils.addZero(reqVo.getSelectedCode(), 10) + "'");
        } else if (!StringUtils.isEmpty(reqVo.getBsDirectSystemId())) {
            //查询所有门店
            KmsTenantryDirectStoreReqVo storeReqVo = new KmsTenantryDirectStoreReqVo();
            storeReqVo.setBsDirectSystemId(reqVo.getBsDirectSystemId());
            List<KmsTenantryDirectStoreRespVo> storeMapperList = kmsTenantryDirectStoreMapper.findList(storeReqVo);
            if (org.springframework.util.CollectionUtils.isEmpty(storeMapperList)) {
                throw new BusinessException("未维护商超门店");
            }
            //查询售达方
            List<String> terminalCodes = storeMapperList.stream().map(KmsTenantryDirectStoreRespVo::getTerminalCode)
                    .distinct().collect(Collectors.toList());
            MdmTerminalSupplyVo supplyVo = new MdmTerminalSupplyVo();
            supplyVo.setTerminalCodeList(terminalCodes);
            List<MdmCustomerRespVo> customerRespVos = ApiResultUtil.objResult(mdmTerminalSupplyFeign.findBySupply(supplyVo));
            if (CollectionUtils.isEmpty(customerRespVos)) {
                throw new BusinessException("未查询到售达方信息");
            }
            List<String> customerCodes = customerRespVos.stream().map(MdmCustomerRespVo::getCustomerCode)
                    .distinct().collect(Collectors.toList());
            customerCodes.forEach(o -> {
                soldToPartyCodes.add("'" + KmsUtils.addZero(o, 10) + "'");
            });
        }
        reqVo.setStoreCodeList(storeCodes);
        reqVo.setSoldToPartyCodeList(soldToPartyCodes);
        //获取发票类型
        Map<String, String> fkartTypeMap = DictUtil.dictMap(KMS_FKART_TYPE);
        List<String> fkartList = Lists.newArrayList();
        fkartTypeMap.forEach((k, v) -> {
            fkartList.add("'" + k + "'");
        });
        reqVo.setInvoiceTypeList(fkartList);
        //公司
        List<String> companyCodeQuery = Lists.newArrayList();
        //公司代码集合
        List<String> bukrsList = Lists.newArrayList();
        reqVo.getAuditTemplateVo().forEach(o -> {
            bukrsList.add("'" + o.getSapOrgCode() + "'");
            companyCodeQuery.add(o.getSapOrgCode());
        });
        reqVo.setCompanyCodeList(bukrsList);
        //通过公司代码集合查询公司组织信息
        MdmOrgSearchReqVo searchReqVo = new MdmOrgSearchReqVo();
        searchReqVo.setSapOrgCodeList(companyCodeQuery);
        searchReqVo.setPageSize(companyCodeQuery.size());
        List<MdmOrgRespVo> mdmOrgRespVos = ApiResultUtil.objResult(mdmOrgFeign.findOrgAndChildrenList(searchReqVo));
        AssertUtils.isNotEmpty(mdmOrgRespVos, companyCodeQuery.toString() + "未查询到组织信息");
        MdmOrgRespVo mdmOrg = mdmOrgRespVos.get(0);
        reqVo.setOrgCode(mdmOrg.getOrgCode());
        //拉取sap发票数据
        List<KmsSapInvoiceEntity> invoiceEntities = kmsSapHelper.pullHanaInvoice(reqVo);
        invoiceEntities.forEach(o -> {
            o.setOrgCode(mdmOrg.getOrgCode());
            o.setCreateOrgCode(mdmOrg.getOrgCode());
        });
        List<String> invIds = invoiceEntities.stream().map(KmsSapInvoiceEntity::getId).collect(Collectors.toList());
        reqVo.setInvoiceIds(invIds);
        kmsSapInvoiceService.removeByIds(invIds);
        kmsSapInvoiceService.saveBatch(invoiceEntities);
    }

    /**
     * 汇总SAP数据
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void pullSapSummary(KmsSapOrderFormReqVo reqVo) {
        KmsTenantryDirectCustomerOrgEntity customerOrgEntity = tenantryDirectCustomerOrgMapper.selectById(reqVo.getBsDirectSystemId());
        //汇总
        reqVo.getAuditTemplateVo().forEach(a -> {
            //获取未汇总的数据
            List<KmsSapInvoiceRespVo> invoice = kmsSapInvoiceMapper.findNotSummary(reqVo.getOrgCode(), a.getId(), reqVo.getInvoiceIds());
            invoice.forEach(e -> {
                a.setDirectId(customerOrgEntity.getDirectId());
                a.setBsDirectSystemId(customerOrgEntity.getId());
                a.setBsDirectSystemCode(customerOrgEntity.getBsDirectSystemCode());
                a.setBsDirectSystemName(customerOrgEntity.getBsDirectSystemName());
            });
            if (!org.springframework.util.CollectionUtils.isEmpty(invoice)) {
                //新增稽核汇总数据
                List<KmsAuditFormEntity> auditFormEntities = Lists.newArrayList();
                //新增关系数据
                List<KmsAuditMatchRelationEntity> relationEntities = Lists.newArrayList();
                kmsAuditFormHelper.summary(invoice, a, auditFormEntities, relationEntities);
                if (!org.springframework.util.CollectionUtils.isEmpty(auditFormEntities)) {
                    this.saveBatch(auditFormEntities);
                }
                Map<String, KmsAuditFormEntity> newAuditMap = auditFormEntities.stream()
                        .collect(Collectors.toMap(KmsAuditFormEntity::getAuditNumber, Function.identity()));
                relationEntities.forEach(re -> {
                    KmsAuditFormEntity auditFormEntity = newAuditMap.get(re.getAuditNumber());
                    if (!org.springframework.util.ObjectUtils.isEmpty(auditFormEntity)) {
                        re.setAuditId(auditFormEntity.getId());
                    }
                });
                kmsAuditMatchRelationService.saveBatch(relationEntities);
            }
        });
    }

    /**
     * 手动取消匹配提交
     *
     * @param kmsAuditFormReqVo
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void manualCancelmatch(KmsAuditFormReqVo kmsAuditFormReqVo) {
        AssertUtils.isNotEmpty(kmsAuditFormReqVo.getId(), "主数据ID不能为空");
        AssertUtils.isNotEmpty(kmsAuditFormReqVo.getAcceptanceFormVos(), "请选择验收单信息");
        List<String> accIds = kmsAuditFormReqVo.getAcceptanceFormVos().stream()
                .map(KmsAuditAcceptanceFormRespVo::getId).collect(Collectors.toList());
        //更新数据
        KmsAuditFormEntity auditFormEntity = kmsAuditFormMapper.selectById(kmsAuditFormReqVo.getId());
        AssertUtils.isNotNull(auditFormEntity, "未查询到该稽核数据信息");
        KmsAuditFormRespVo afVo = CrmBeanUtil.copy(auditFormEntity, KmsAuditFormRespVo.class);
        //稽核模版
        String auditTemplateId = afVo.getAuditTemplateId();
        KmsAuditTemplateReqVo templateReqVo = new KmsAuditTemplateReqVo();
        templateReqVo.setId(auditTemplateId);
        KmsAuditTemplateRespVo templateRespVo = kmsAuditTemplateService.query(templateReqVo);
        kmsAuditFormHelper.findMatchDataByIds(accIds, afVo, templateRespVo);
        //取消数据绑定
        kmsAuditFormHelper.cancelMatchData(accIds, afVo, templateRespVo);
        //根据稽核ID查询关联SAP数据
        List<KmsSapOrderFormRespVo> sapFormVos = kmsSapInvoiceMapper.findByAuditFormId(kmsAuditFormReqVo.getId());
        sapFormVos.forEach(o -> {
            o.setSapMaterielCode(KmsUtils.removeFrontZero(o.getSapMaterielCode()));
        });
        afVo.setSapOrderFormVos(sapFormVos);
        //匹配数据信息
        kmsAuditFormHelper.matchDataSucc(afVo, templateRespVo);
        //数据处理
        KmsUtils.sapInvoiceData(afVo);
        //设置保留两位小数
        KmsUtils.setScaleTwo(afVo);
        //刷新数据
        KmsUtils.updateAuditFormData(afVo, auditFormEntity);
        kmsAuditFormMapper.updateById(auditFormEntity);
    }

    /**
     * 手动匹配详情
     *
     * @param kmsAuditFormReqVo
     * @return
     */
    @Override
    public KmsAuditFormRespVo manualmatchQuery(KmsAuditFormReqVo reqVo) {
        String auditFormId = reqVo.getId();
        AssertUtils.isNotEmpty(auditFormId, "请选择数据");
        KmsAuditFormEntity byId = this.getById(auditFormId);
        if (ObjectUtils.isEmpty(byId)) {
            throw new BusinessException("未查询到数据信息");
        }
        KmsAuditFormRespVo respVo = CrmBeanUtil.copy(byId, KmsAuditFormRespVo.class);
        //根据稽核ID查询关联SAP数据
        List<KmsSapOrderFormRespVo> sapFormVos = kmsSapInvoiceMapper.findByAuditFormId(auditFormId);
        sapFormVos.forEach(o -> {
            o.setSapMaterielCode(KmsUtils.removeFrontZero(o.getSapMaterielCode()));
        });
        respVo.setSapOrderFormVos(sapFormVos);
        //数据处理
        KmsUtils.sapInvoiceData(respVo);
        //设置保留两位小数
        KmsUtils.setScaleTwo(respVo);
        return respVo;
    }

    /**
     * 手动匹配查询待匹配验收单数据列表
     *
     * @param kmsAuditFormReqVo
     * @return
     */
    @Override
    public PageResult<KmsAuditAcceptanceFormRespVo> waitMatchedAcc(KmsAuditFormReqVo kmsAuditFormReqVo) {
        String auditFormId = kmsAuditFormReqVo.getId();
        AssertUtils.isNotEmpty(auditFormId, "请选择数据Id");
        KmsAuditFormEntity entity = this.getById(auditFormId);
        if (ObjectUtils.isEmpty(entity)) {
            throw new BusinessException("未查询到数据信息");
        }
        KmsAuditFormRespVo respVo = CrmBeanUtil.copy(entity, KmsAuditFormRespVo.class);
        //根据稽核ID查询关联SAP数据
        List<KmsSapOrderFormRespVo> sapFormVos = kmsSapInvoiceMapper.findByAuditFormId(auditFormId);
        sapFormVos.forEach(o -> {
            o.setSapMaterielCode(KmsUtils.removeFrontZero(o.getSapMaterielCode()));
        });
        respVo.setSapOrderFormVos(sapFormVos);
        //稽核模版
        String auditTemplateId = entity.getAuditTemplateId();
        KmsAuditTemplateReqVo templateReqVo = new KmsAuditTemplateReqVo();
        templateReqVo.setId(auditTemplateId);
        KmsAuditTemplateRespVo templateRespVo = kmsAuditTemplateService.query(templateReqVo);
        //手动匹配查询待匹配验收单数据列表
        PageResult<KmsAuditAcceptanceFormRespVo> result = kmsAuditFormHelper.waitMatchedAcc(kmsAuditFormReqVo, respVo, templateRespVo);
        //数据处理
        respVo.setAcceptanceFormVos(result.getData());
        KmsUtils.sapInvoiceData(respVo);
        //设置保留两位小数
        KmsUtils.setScaleTwo(respVo);
        result.setData(respVo.getAcceptanceFormVos());
        if (!org.springframework.util.CollectionUtils.isEmpty(result.getData())) {
            result.getData().forEach(a -> {
                //单价
                BigDecimal acceptanceAmount = org.springframework.util.StringUtils.isEmpty(a.getAcceptanceAmount()) ? null : new BigDecimal(a.getAcceptanceAmount());
                BigDecimal acceptanceQuantity = org.springframework.util.StringUtils.isEmpty(a.getAcceptanceQuantity()) ? null : new BigDecimal(a.getAcceptanceQuantity());
                if (!org.springframework.util.ObjectUtils.isEmpty(acceptanceAmount)
                        && !org.springframework.util.ObjectUtils.isEmpty(acceptanceQuantity) && acceptanceQuantity.compareTo(BigDecimal.ZERO) == 1) {
                    a.setDanjia(acceptanceAmount.divide(acceptanceQuantity, 2, BigDecimal.ROUND_HALF_UP));
                }
            });
        }
        return result;
    }

    /**
     * 手动匹配提交
     *
     * @param kmsAuditFormReqVo
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void manualmatch(KmsAuditFormReqVo kmsAuditFormReqVo) {
        AssertUtils.isNotEmpty(kmsAuditFormReqVo.getId(), "主数据ID不能为空");
        AssertUtils.isNotEmpty(kmsAuditFormReqVo.getAcceptanceFormVos(), "请选择验收单信息");
        List<String> accIds = kmsAuditFormReqVo.getAcceptanceFormVos().stream()
                .map(KmsAuditAcceptanceFormRespVo::getId).collect(Collectors.toList());
        //更新数据
        KmsAuditFormEntity auditFormEntity = kmsAuditFormMapper.selectById(kmsAuditFormReqVo.getId());
        AssertUtils.isNotNull(auditFormEntity, "未查询到该稽核数据信息");
        KmsAuditFormRespVo afVo = CrmBeanUtil.copy(auditFormEntity, KmsAuditFormRespVo.class);
        //稽核模版
        String auditTemplateId = afVo.getAuditTemplateId();
        KmsAuditTemplateReqVo templateReqVo = new KmsAuditTemplateReqVo();
        templateReqVo.setId(auditTemplateId);
        KmsAuditTemplateRespVo templateRespVo = kmsAuditTemplateService.query(templateReqVo);
        kmsAuditFormHelper.findMatchDataByIds(accIds, afVo, templateRespVo);
        //数据绑定
        kmsAuditFormHelper.matchDataBinding(afVo, templateRespVo);

        //根据稽核ID查询关联SAP数据
        List<KmsSapOrderFormRespVo> sapFormVos = kmsSapInvoiceMapper.findByAuditFormId(kmsAuditFormReqVo.getId());
        sapFormVos.forEach(o -> {
            o.setSapMaterielCode(KmsUtils.removeFrontZero(o.getSapMaterielCode()));
        });
        afVo.setSapOrderFormVos(sapFormVos);
        //已匹配数据信息
        kmsAuditFormHelper.matchDataSucc(afVo, templateRespVo);
        //数据处理
        KmsUtils.sapInvoiceData(afVo);
        //设置保留两位小数
        KmsUtils.setScaleTwo(afVo);
        //刷新数据
        KmsUtils.updateAuditFormData(afVo, auditFormEntity);
        kmsAuditFormMapper.updateById(auditFormEntity);
    }

    /**
     * 查询模版下待匹配稽核数据信息
     *
     * @param formReqVo
     * @return
     */
    @Override
    public List<KmsAuditFormRespVo> findWaitList(KmsAuditFormReqVo formReqVo) {
        return kmsAuditFormMapper.findList(formReqVo);
    }

    /**
     * 稽核自动匹配
     *
     * @param afVo
     * @param templateRespVo
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void auditMatch(KmsAuditFormRespVo afVo, KmsAuditTemplateRespVo templateRespVo) {
        //根据稽核ID查询关联SAP数据
        List<KmsSapOrderFormRespVo> sapFormVos = kmsSapInvoiceMapper.findByAuditFormId(afVo.getId());
        sapFormVos.forEach(o -> {
            o.setSapMaterielCode(KmsUtils.removeFrontZero(o.getSapMaterielCode()));
        });
        afVo.setSapOrderFormVos(sapFormVos);
        //匹配数据
        kmsAuditFormHelper.matchData(afVo, templateRespVo);
        if (!CollectionUtils.isEmpty(afVo.getAcceptanceFormVos())) {
            //数据绑定
            kmsAuditFormHelper.matchDataBinding(afVo, templateRespVo);
        }
        //数据处理
        KmsUtils.sapInvoiceData(afVo);
        //设置保留两位小数
        KmsUtils.setScaleTwo(afVo);
        //更新数据
        KmsAuditFormEntity auditFormEntity = kmsAuditFormMapper.selectById(afVo.getId());
        //刷新数据
        KmsUtils.updateAuditFormData(afVo, auditFormEntity);
        kmsAuditFormMapper.updateById(auditFormEntity);
    }

    /**
     * 刷新稽核结果
     *
     * @param formReqVo
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void refreshAuditResult(KmsAuditFormReqVo formReqVo) {
        //查询所有稽核单号
        List<KmsAuditFormRespVo> formRespVos = kmsAuditFormMapper.findList(formReqVo);
        //查询关联SAP发票集合
        List<KmsSapOrderFormRespVo> sapFormVos = kmsSapInvoiceMapper.findList(formReqVo);
        Map<String, List<KmsSapOrderFormRespVo>> sapMap = sapFormVos.stream()
                .collect(Collectors.groupingBy(KmsSapOrderFormRespVo::getAuditId));
        //查询模版信息
        KmsAuditTemplateReqVo templateReqVo = new KmsAuditTemplateReqVo();
        templateReqVo.setIds(formRespVos.stream().map(KmsAuditFormRespVo::getAuditTemplateId)
                .distinct().collect(Collectors.toList()));
        List<KmsAuditTemplateRespVo> templateRespVos = kmsAuditTemplateMapper.findList(templateReqVo);
        Map<String, KmsAuditTemplateRespVo> templateRespVoMap = templateRespVos.stream()
                .collect(Collectors.toMap(KmsAuditTemplateRespVo::getId, Function.identity()));
        //稽核结果map
        Map<String, KmsAuditFormRespVo> auditResultMap = Maps.newHashMap();
        formRespVos.forEach(o -> {
            //sap
            List<KmsSapOrderFormRespVo> respVos = sapMap.get(o.getId());
            o.setSapOrderFormVos(respVos);
            KmsAuditTemplateRespVo templateRespVo = templateRespVoMap.get(o.getAuditTemplateId());
            kmsAuditFormHelper.matchDataSucc(o, templateRespVo);
            //数据处理
            KmsUtils.sapInvoiceData(o);
            auditResultMap.put(o.getId(), o);
        });
        List<KmsAuditFormEntity> kmsAuditFormEntities = kmsAuditFormMapper.selectBatchIds(formReqVo.getIds());
        kmsAuditFormEntities.forEach(o -> {
            KmsAuditFormRespVo auditForm = auditResultMap.get(o.getId());
            if (!ObjectUtils.isEmpty(auditForm)) {
                //刷新数据
                KmsUtils.updateAuditFormData(auditForm, o);
            }
        });
        this.updateBatchById(kmsAuditFormEntities);
    }

    /**
     * 忽略标点符号；
     *
     * @param s
     * @return
     */
    public static String format(String s) {
        String str = s.replaceAll("[`qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM~!@#$%^&*()+=|{}':;',\\[\\].<>/?~！@#￥%……& amp;*（）——+|{}【】‘；：”“’。，、？|-]", "");
        return str;
    }

    /**
     * 处理延迟收货
     *
     * @param o
     * @param auditTemplateRespVo
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void delayedReceipt(KmsAuditFormRespVo o, KmsAuditTemplateRespVo auditTemplateRespVo) {
        if (!KmsEnum.AuditResult.WAIT.getValue().equals(o.getAuditResult()) || org.springframework.util.StringUtils.isEmpty(o.getSapPostingDate())) {
            return;
        }
        //处理延迟收货查询验收单数据信息
        kmsAuditFormHelper.delayedReceiptAcc(o, auditTemplateRespVo);
        //计算延迟收货
        if (org.springframework.util.CollectionUtils.isEmpty(o.getAcceptanceFormVos())) {
            //SAP数量是否等于0并且状态为待匹配改成无差异
            if (KmsEnum.AuditResult.WAIT.getValue().equals(o.getAuditResult()) && o.getSapQuantity().compareTo(BigDecimal.ZERO) == 0) {
                //更新数据
                KmsAuditFormEntity auditFormEntity = kmsAuditFormMapper.selectById(o.getId());
                auditFormEntity.setAuditResult(KmsEnum.AuditResult.NO_DIFFERENCE.getValue());
                kmsAuditFormMapper.updateById(auditFormEntity);
            }
        } else {
            //正负分组
            List<KmsAuditAcceptanceFormRespVo> zAcc = Lists.newArrayList();
            List<KmsAuditAcceptanceFormRespVo> fAcc = Lists.newArrayList();
            o.getAcceptanceFormVos().forEach(a -> {
                if (a.getDifferenceDay().compareTo(BigDecimal.ZERO) < 0) {
                    fAcc.add(a);
                }
                if (a.getDifferenceDay().compareTo(BigDecimal.ZERO) >= 0) {
                    zAcc.add(a);
                }
            });
            //匹配验收单
            List<KmsAuditAcceptanceFormRespVo> accFormRespList = Lists.newArrayList();
            //负数sap
            List<KmsSapOrderFormRespVo> negativeSapList = o.getSapOrderFormVos().stream()
                    .filter(s -> s.getSapQuantity().compareTo(BigDecimal.ZERO) == -1)
                    .collect(Collectors.toList());

            o.getSapOrderFormVos().stream().filter(s -> s.getSapQuantity().compareTo(BigDecimal.ZERO) == 1).forEach(s -> {
                //判断是否有抵消
                List<KmsSapOrderFormRespVo> counteract = negativeSapList.stream()
                        .filter(n -> s.getSapQuantity().compareTo(n.getSapQuantity().multiply(new BigDecimal(-1))) == 0)
                        .collect(Collectors.toList());
                if (org.springframework.util.CollectionUtils.isEmpty(counteract)) {
                    for (int i = 1, j = 7; i <= j; i++) {
                        int flag = i;
                        //寻找正向
                        List<KmsAuditAcceptanceFormRespVo> selected = o.getAcceptanceFormVos().stream()
                                .filter(za -> za.getDifferenceDay().compareTo(new BigDecimal(flag)) == 0
                                        && !StringUtils.isEmpty(za.getAcceptanceQuantity())
                                        && new BigDecimal(za.getAcceptanceQuantity()).compareTo(s.getSapQuantity()) == 0)
                                .collect(Collectors.toList());
                        if (!org.springframework.util.CollectionUtils.isEmpty(selected)) {
                            //过滤掉已经使用的单子
                            List<KmsAuditAcceptanceFormRespVo> selection = selected.stream().filter(se -> !accFormRespList.contains(se))
                                    .collect(Collectors.toList());
                            if (!org.springframework.util.CollectionUtils.isEmpty(selection)) {
                                accFormRespList.add(selection.get(0));
                                break;
                            }
                        }
                    }
                }
            });
            o.setAcceptanceFormVos(accFormRespList);
            if (!CollectionUtils.isEmpty(o.getAcceptanceFormVos())) {
                //数据绑定
                kmsAuditFormHelper.matchDataBinding(o, auditTemplateRespVo);
            }
            //数据处理
            KmsUtils.sapInvoiceData(o);
            //设置保留两位小数
            KmsUtils.setScaleTwo(o);
            //更新数据
            KmsAuditFormEntity auditFormEntity = kmsAuditFormMapper.selectById(o.getId());
            //刷新数据
            KmsUtils.updateAuditFormData(o, auditFormEntity);
            if (!KmsEnum.AuditResult.WAIT.getValue().equals(auditFormEntity.getAuditResult())) {
                auditFormEntity.setRemarks(o.getRemarks());
            } else {
                //SAP数量是否等于0并且状态为待匹配改成无差异
                if (o.getSapQuantity().compareTo(BigDecimal.ZERO) == 0) {
                    auditFormEntity.setAuditResult(KmsEnum.AuditResult.NO_DIFFERENCE.getValue());
                }
            }
            kmsAuditFormMapper.updateById(auditFormEntity);
        }
    }

    /**
     * 未匹配验收单匹配稽核单提交
     *
     * @param kmsAuditFormReqVo
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void submitUnmatchedAcce(KmsAuditFormReqVo kmsAuditFormReqVo) {
        AssertUtils.isNotEmpty(kmsAuditFormReqVo.getAcceptanceId(), "未匹配验收单[acceptanceId]不能为空");
        AssertUtils.isNotEmpty(kmsAuditFormReqVo.getId(), "所选稽核数据Id不能为空");
        //验收单
        List<String> accIds = Lists.newArrayList();
        accIds.add(kmsAuditFormReqVo.getAcceptanceId());
        //更新数据
        KmsAuditFormEntity auditFormEntity = kmsAuditFormMapper.selectById(kmsAuditFormReqVo.getId());
        AssertUtils.isNotNull(auditFormEntity, "未查询到该稽核数据信息");
        KmsAuditFormRespVo afVo = CrmBeanUtil.copy(auditFormEntity, KmsAuditFormRespVo.class);
        //稽核模版
        String auditTemplateId = afVo.getAuditTemplateId();
        KmsAuditTemplateReqVo templateReqVo = new KmsAuditTemplateReqVo();
        templateReqVo.setId(auditTemplateId);
        KmsAuditTemplateRespVo templateRespVo = kmsAuditTemplateService.query(templateReqVo);
        kmsAuditFormHelper.findMatchDataByIds(accIds, afVo, templateRespVo);
        //数据绑定
        kmsAuditFormHelper.matchDataBinding(afVo, templateRespVo);

        //根据稽核ID查询关联SAP数据
        List<KmsSapOrderFormRespVo> sapFormVos = kmsSapInvoiceMapper.findByAuditFormId(kmsAuditFormReqVo.getId());
        sapFormVos.forEach(o -> {
            o.setSapMaterielCode(KmsUtils.removeFrontZero(o.getSapMaterielCode()));
        });
        afVo.setSapOrderFormVos(sapFormVos);
        //已匹配数据信息
        kmsAuditFormHelper.matchDataSucc(afVo, templateRespVo);
        //数据处理
        KmsUtils.sapInvoiceData(afVo);
        //设置保留两位小数
        KmsUtils.setScaleTwo(afVo);
        //刷新数据
        KmsUtils.updateAuditFormData(afVo, auditFormEntity);
        kmsAuditFormMapper.updateById(auditFormEntity);
    }
}
