package com.biz.crm.finance.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.finance.mapper.KmsAuditTemplateDirectMapper;
import com.biz.crm.finance.model.KmsAuditTemplateDirectEntity;
import com.biz.crm.finance.service.IKmsAuditTemplateDirectService;
import com.biz.crm.nebular.kms.finance.req.KmsAuditTemplateDirectReqVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditTemplateDirectRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 稽核模板商超信息接口实现
 *
 * @author Gavin
 * @date 2021-05-25 17:56:09
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="KmsAuditTemplateDirectServiceExpandImpl")
public class KmsAuditTemplateDirectServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<KmsAuditTemplateDirectMapper, KmsAuditTemplateDirectEntity> implements IKmsAuditTemplateDirectService {

    @Resource
    private KmsAuditTemplateDirectMapper kmsAuditTemplateDirectMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<KmsAuditTemplateDirectRespVo> findList(KmsAuditTemplateDirectReqVo reqVo){
        Page<KmsAuditTemplateDirectRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<KmsAuditTemplateDirectRespVo> list = kmsAuditTemplateDirectMapper.findList(page, reqVo);
        return PageResult.<KmsAuditTemplateDirectRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return kmsAuditTemplateDirectRespVo
     */
    @Override
    public KmsAuditTemplateDirectRespVo query(KmsAuditTemplateDirectReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(KmsAuditTemplateDirectReqVo reqVo){
        KmsAuditTemplateDirectEntity entity = CrmBeanUtil.copy(reqVo,KmsAuditTemplateDirectEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(KmsAuditTemplateDirectReqVo reqVo){
        KmsAuditTemplateDirectEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(KmsAuditTemplateDirectReqVo reqVo){
        List<KmsAuditTemplateDirectEntity> kmsAuditTemplateDirectEntities = kmsAuditTemplateDirectMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsAuditTemplateDirectEntities)){
            kmsAuditTemplateDirectEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(kmsAuditTemplateDirectEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(KmsAuditTemplateDirectReqVo reqVo){
        //设置状态为启用
        List<KmsAuditTemplateDirectEntity> kmsAuditTemplateDirectEntities = kmsAuditTemplateDirectMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsAuditTemplateDirectEntities)){
            kmsAuditTemplateDirectEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(kmsAuditTemplateDirectEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(KmsAuditTemplateDirectReqVo reqVo){
        //设置状态为禁用
        List<KmsAuditTemplateDirectEntity> kmsAuditTemplateDirectEntities = kmsAuditTemplateDirectMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsAuditTemplateDirectEntities)){
                kmsAuditTemplateDirectEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(kmsAuditTemplateDirectEntities);
    }
}
