package com.biz.crm.grabrule.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.grabrule.service.IKmsGrabRuleService;
import com.biz.crm.grabrule.service.IKmsRequestService;
import com.biz.crm.nebular.kms.grabrule.req.KmsGrabRuleReqVo;
import com.biz.crm.nebular.kms.grabrule.resp.KmsGrabRuleRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * 抓单规则配置表
 *
 * @author Gavin
 * @date 2021-04-16 17:00:42
 */
@Slf4j
@RestController
@RequestMapping("/kmsgrabrule")
@Api(tags = "抓单规则配置表")
public class KmsGrabRuleController {
    @Autowired
    private IKmsGrabRuleService kmsGrabRuleService;

    @Resource
    private IKmsRequestService kmsRequestService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<KmsGrabRuleRespVo>> list(@RequestBody KmsGrabRuleReqVo kmsGrabRuleReqVo) {
        PageResult<KmsGrabRuleRespVo> result=kmsGrabRuleService.findList(kmsGrabRuleReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<KmsGrabRuleRespVo> query(@RequestBody KmsGrabRuleReqVo kmsGrabRuleReqVo) {
        KmsGrabRuleRespVo respVo=kmsGrabRuleService.query(kmsGrabRuleReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody KmsGrabRuleReqVo kmsGrabRuleReqVo) {
        if(StringUtils.isEmpty(kmsGrabRuleReqVo.getId())) {
            kmsGrabRuleService.save(kmsGrabRuleReqVo);
        }else{
            kmsGrabRuleService.update(kmsGrabRuleReqVo);
        }
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody KmsGrabRuleReqVo kmsGrabRuleReqVo) {
        kmsGrabRuleService.update(kmsGrabRuleReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        kmsGrabRuleService.deleteBatch(new KmsGrabRuleReqVo().setIds(ids));
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        kmsGrabRuleService.enableBatch(new KmsGrabRuleReqVo().setIds(ids));
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        kmsGrabRuleService.disableBatch(new KmsGrabRuleReqVo().setIds(ids));
        return Result.ok("禁用成功");
    }

    /**
     * 手动抓单
     */
    @ApiOperation(value = "手动抓单")
    @PostMapping("/manualGrab")
    @CrmLog
    public Result manualGrab(@RequestBody KmsGrabRuleReqVo reqVo) {
        kmsRequestService.manualGrab(reqVo);
        return Result.ok("操作成功");
    }
}
