package com.biz.crm.grabrule.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.grabrule.model.KmsGrabRuleStoreEntity;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.kms.grabrule.req.KmsGrabRuleStoreReqVo;
import com.biz.crm.nebular.kms.grabrule.resp.KmsGrabRuleStoreRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 抓单规则门店配置表
 * 
 * @author Gavin
 * @date 2021-04-16 17:00:42
 */
public interface KmsGrabRuleStoreMapper extends BaseMapper<KmsGrabRuleStoreEntity> {
    /**
     * 列表
     * @param page
     * @param kmsGrabRuleStoreReqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code",orgCode = "t.create_org_code")
    List<KmsGrabRuleStoreRespVo> findList(Page<KmsGrabRuleStoreRespVo> page, @Param("vo") KmsGrabRuleStoreReqVo kmsGrabRuleStoreReqVo);

    /**
     * 根据抓单规则获取门店列表
     * @param ruleId
     * @return
     */
    List<KmsGrabRuleStoreRespVo> findByGrabRuleId(@Param("ruleId") String ruleId);
}
