package com.biz.crm.grabrule.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.grabrule.helper.KmsLoggerDataProcessHelper;
import com.biz.crm.grabrule.mapper.KmsLoggerDataProcessMapper;
import com.biz.crm.grabrule.model.KmsLoggerDataProcessEntity;
import com.biz.crm.grabrule.service.IKmsLoggerDataProcessService;
import com.biz.crm.nebular.kms.grabrule.req.KmsLoggerDataProcessReqVo;
import com.biz.crm.nebular.kms.grabrule.resp.KmsLoggerDataProcessRespVo;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 单据抓取日志接口实现
 *
 * @author Gavin
 * @date 2021-05-11 11:32:23
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="KmsLoggerDataProcessServiceExpandImpl")
public class KmsLoggerDataProcessServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<KmsLoggerDataProcessMapper, KmsLoggerDataProcessEntity> implements IKmsLoggerDataProcessService {

    @Resource
    private KmsLoggerDataProcessMapper kmsLoggerDataProcessMapper;

    @Resource
    private KmsLoggerDataProcessHelper kmsLoggerDataProcessHelper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<KmsLoggerDataProcessRespVo> findList(KmsLoggerDataProcessReqVo reqVo){
        Page<KmsLoggerDataProcessRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<KmsLoggerDataProcessRespVo> list = kmsLoggerDataProcessMapper.findList(page, reqVo);
        return PageResult.<KmsLoggerDataProcessRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return kmsLoggerDataProcessRespVo
     */
    @Override
    public KmsLoggerDataProcessRespVo query(KmsLoggerDataProcessReqVo reqVo){
        return null;
    }

    /**
     * 保存抓单日志
     * @param reqVo
     * @return
     */
    @Override
    @Async
    @Transactional(rollbackFor = Exception.class)
    public void save(KmsLoggerDataProcessReqVo reqVo){
        KmsLoggerDataProcessEntity entity = kmsLoggerDataProcessHelper.buildEntity(reqVo);
        if(StringUtils.isEmpty(entity.getId())) {
            this.save(entity);
        }else{
            this.updateById(entity);
        }
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(KmsLoggerDataProcessReqVo reqVo){
        KmsLoggerDataProcessEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(KmsLoggerDataProcessReqVo reqVo){
        List<KmsLoggerDataProcessEntity> kmsLoggerDataProcessEntities = kmsLoggerDataProcessMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsLoggerDataProcessEntities)){
            kmsLoggerDataProcessEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(kmsLoggerDataProcessEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(KmsLoggerDataProcessReqVo reqVo){
        //设置状态为启用
        List<KmsLoggerDataProcessEntity> kmsLoggerDataProcessEntities = kmsLoggerDataProcessMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsLoggerDataProcessEntities)){
            kmsLoggerDataProcessEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(kmsLoggerDataProcessEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(KmsLoggerDataProcessReqVo reqVo){
        //设置状态为禁用
        List<KmsLoggerDataProcessEntity> kmsLoggerDataProcessEntities = kmsLoggerDataProcessMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsLoggerDataProcessEntities)){
                kmsLoggerDataProcessEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(kmsLoggerDataProcessEntities);
    }
}
