package com.biz.crm.kaproduct.mapper;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.kaproduct.model.KmsTenantryDirectProductEntity;
import com.biz.crm.nebular.kms.kaproduct.req.KmsTenantryDirectProductReqVo;
import com.biz.crm.nebular.kms.kaproduct.resp.KmsProductForExportRespVo;
import com.biz.crm.nebular.kms.kaproduct.resp.KmsTenantryDirectProductRespVo;

/**
 * 企业产品与商超产品关系
 *
 * @author Gavin
 * @date 2021-04-15 14:28:52
 */
public interface KmsTenantryDirectProductMapper extends BaseMapper<KmsTenantryDirectProductEntity> {
    /**
     * 列表
     *
     * @param page
     * @param params
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code", orgCode = "t.create_org_code")
    List<KmsTenantryDirectProductRespVo> findList(Page<KmsTenantryDirectProductRespVo> page, @Param("vo") KmsTenantryDirectProductReqVo params);

    //@SqlPrivilege(posCode = "t.create_pos_code", orgCode = "t.create_org_code")
    List<KmsTenantryDirectProductRespVo> findList(@Param("vo") KmsTenantryDirectProductReqVo params);

    /**
     * 根据ID查询
     *
     * @param id
     * @return
     */
    KmsTenantryDirectProductRespVo findById(@Param("id") String id);

    /**
     * 列表导出
     *
     * @param page
     * @param reqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code", orgCode = "t.create_org_code")
    List<KmsProductForExportRespVo> findListForExport(Page<KmsProductForExportRespVo> page, @Param("vo") KmsTenantryDirectProductReqVo reqVo);

    /**
     * 新增或修改数据
     *
     * @param reqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code", orgCode = "t.create_org_code")
    List<KmsTenantryDirectProductEntity> selectListForSave(@Param("vo") KmsTenantryDirectProductReqVo reqVo);

    /**
     * 查询上架产品判断是否为星期商品
     * @param params
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code", orgCode = "t.create_org_code")
    List<KmsTenantryDirectProductRespVo> findListByWeek(@Param("vo") KmsTenantryDirectProductReqVo params);
}
