package com.biz.crm.kaproduct.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.kaproduct.mapper.KmsProductUnitMapper;
import com.biz.crm.kaproduct.model.KmsProductUnitEntity;
import com.biz.crm.kaproduct.service.IKmsProductUnitService;
import com.biz.crm.nebular.kms.kaproduct.req.KmsProductUnitReqVo;
import com.biz.crm.nebular.kms.kaproduct.resp.KmsProductUnitRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 企业产品与商超产品单位转换关系表接口实现
 *
 * @author Gavin
 * @date 2021-04-15 14:28:52
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="KmsProductUnitServiceExpandImpl")
public class KmsProductUnitServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<KmsProductUnitMapper, KmsProductUnitEntity> implements IKmsProductUnitService {

    @Resource
    private KmsProductUnitMapper kmsProductUnitMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<KmsProductUnitRespVo> findList(KmsProductUnitReqVo reqVo){
        Page<KmsProductUnitRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<KmsProductUnitRespVo> list = kmsProductUnitMapper.findList(page, reqVo);
        return PageResult.<KmsProductUnitRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return kmsProductUnitRespVo
     */
    @Override
    public KmsProductUnitRespVo query(KmsProductUnitReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(KmsProductUnitReqVo reqVo){
        KmsProductUnitEntity entity = CrmBeanUtil.copy(reqVo,KmsProductUnitEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(KmsProductUnitReqVo reqVo){
        KmsProductUnitEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(KmsProductUnitReqVo reqVo){
        List<KmsProductUnitEntity> kmsProductUnitEntities = kmsProductUnitMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsProductUnitEntities)){
            kmsProductUnitEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(kmsProductUnitEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(KmsProductUnitReqVo reqVo){
        //设置状态为启用
        List<KmsProductUnitEntity> kmsProductUnitEntities = kmsProductUnitMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsProductUnitEntities)){
            kmsProductUnitEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(kmsProductUnitEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(KmsProductUnitReqVo reqVo){
        //设置状态为禁用
        List<KmsProductUnitEntity> kmsProductUnitEntities = kmsProductUnitMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsProductUnitEntities)){
                kmsProductUnitEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(kmsProductUnitEntities);
    }
}
