package com.biz.crm.orderform.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.kms.orderform.req.KmsOrderFormReqVo;
import com.biz.crm.nebular.kms.orderform.resp.KmsOrderFormExportRespVo;
import com.biz.crm.nebular.kms.orderform.resp.KmsOrderFormRespVo;
import com.biz.crm.nebular.kms.orderform.resp.WebServiceFindOrderRespVo;
import com.biz.crm.orderform.model.KmsOrderFormEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 商超订货单表
 *
 * @author Gavin
 * @date 2021-05-12 18:17:09
 */
public interface KmsOrderFormMapper extends BaseMapper<KmsOrderFormEntity> {
    /**
     * 列表
     *
     * @param page
     * @param kmsOrderFormReqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code", orgCode = "t.create_org_code")
    List<KmsOrderFormRespVo> findList(Page<KmsOrderFormRespVo> page, @Param("vo") KmsOrderFormReqVo kmsOrderFormReqVo);

    @SqlPrivilege(posCode = "t.create_pos_code", orgCode = "t.create_org_code")
    List<KmsOrderFormExportRespVo> findListForExport(Page<KmsOrderFormExportRespVo> page, @Param("vo") KmsOrderFormReqVo reqVo);

    List<KmsOrderFormRespVo> findAreaName(@Param("ids") List<String> ids);

    /**
     * 外部系统查询商超订货单
     *
     * @param reqVo
     * @return
     */
    List<WebServiceFindOrderRespVo> webServiceFindList(@Param("vo") KmsOrderFormReqVo reqVo);
}
