package com.biz.crm.orderform.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.kms.orderform.req.KmsOrderGoodsReqVo;
import com.biz.crm.nebular.kms.orderform.resp.KmsOrderGoodsRespVo;
import com.biz.crm.nebular.kms.orderform.resp.WebServiceFindOrderItemRespVo;
import com.biz.crm.orderform.model.KmsOrderGoodsEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 商超订货单商品表
 *
 * @author Gavin
 * @date 2021-05-12 18:17:09
 */
public interface KmsOrderGoodsMapper extends BaseMapper<KmsOrderGoodsEntity> {
    /**
     * 列表
     *
     * @param page
     * @param kmsOrderGoodsReqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code", orgCode = "t.create_org_code")
    List<KmsOrderGoodsRespVo> findList(Page<KmsOrderGoodsRespVo> page, @Param("vo") KmsOrderGoodsReqVo kmsOrderGoodsReqVo);

    /**
     * 外部系统查询商超货订货单明细
     *
     * @param goodsReqVo
     * @return
     */
    List<WebServiceFindOrderItemRespVo> webServiceFindList(@Param("vo") KmsOrderGoodsReqVo goodsReqVo);
}
