package com.biz.crm.orderform.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.kms.orderform.req.KmsOrderStatusRecordReqVo;
import com.biz.crm.nebular.kms.orderform.resp.KmsOrderStatusRecordRespVo;
import com.biz.crm.orderform.model.KmsOrderStatusRecordEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 商超订货单状态流转记录表
 * 
 * @author Gavin
 * @date 2021-05-12 18:17:09
 */
public interface KmsOrderStatusRecordMapper extends BaseMapper<KmsOrderStatusRecordEntity> {
    /**
     * 列表
     * @param page
     * @param kmsOrderStatusRecordReqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code",orgCode = "t.create_org_code")
    List<KmsOrderStatusRecordRespVo> findList(Page<KmsOrderStatusRecordRespVo> page, @Param("vo") KmsOrderStatusRecordReqVo kmsOrderStatusRecordReqVo);

}
