package com.biz.crm.orderform.service;

import java.util.List;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.kms.orderform.req.KmsOrderFormReqVo;
import com.biz.crm.nebular.kms.orderform.resp.KmsOrderFormExportRespVo;
import com.biz.crm.nebular.kms.orderform.resp.KmsOrderFormRespVo;
import com.biz.crm.nebular.kms.rawdata.resp.KmsOrderFormDetailDwRespVo;
import com.biz.crm.orderform.model.KmsOrderFormEntity;

/**
 * 商超订货单表接口
 *
 * @author Gavin
 * @date 2021-05-12 18:17:09
 */
public interface IKmsOrderFormService extends IService<KmsOrderFormEntity> {

    /**
     * 列表
     *
     * @param kmsOrderFormReqVo
     * @return PageResult<KmsOrderFormRespVo>
     */
    PageResult<KmsOrderFormRespVo> findList(KmsOrderFormReqVo kmsOrderFormReqVo);

    /**
     * 查询
     *
     * @param kmsOrderFormReqVo
     * @return KmsOrderFormRespVo
     */
    KmsOrderFormRespVo query(KmsOrderFormReqVo kmsOrderFormReqVo);

    /**
     * 新增
     *
     * @param kmsOrderFormReqVo
     * @return
     */
    void save(KmsOrderFormReqVo kmsOrderFormReqVo);

    /**
     * 更新
     *
     * @param kmsOrderFormReqVo
     * @return
     */
    void update(KmsOrderFormReqVo kmsOrderFormReqVo);

    /**
     * 删除
     *
     * @param
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     *
     * @param kmsOrderFormReqVo
     * @return
     */
    void enableBatch(KmsOrderFormReqVo kmsOrderFormReqVo);

    /**
     * 禁用
     *
     * @param kmsOrderFormReqVo
     * @return
     */
    void disableBatch(KmsOrderFormReqVo kmsOrderFormReqVo);

    /**
     * 手动转换单据
     *
     * @param kmsOrderFormReqVo
     */
    void manualTrans(KmsOrderFormReqVo kmsOrderFormReqVo);

    /**
     * 自动转换单据
     *
     * @param dwRespVo
     */
    void autoTransData(KmsOrderFormDetailDwRespVo dwRespVo);

    /**
     * 单据推送查询单据信息
     *
     * @param kmsOrderFormReqVo
     * @return
     */
    List<KmsOrderFormRespVo> pushList(KmsOrderFormReqVo kmsOrderFormReqVo);

    /**
     * 单据推送
     *
     * @param kmsOrderFormReqVo
     * @return
     */
    void push(KmsOrderFormReqVo kmsOrderFormReqVo);

    /**
     * 加急订单
     *
     * @param kmsOrderFormReqVo
     */
    void expedited(KmsOrderFormReqVo kmsOrderFormReqVo);

    /**
     * 取消加急
     *
     * @param kmsOrderFormReqVo
     */
    void cancelExpedited(KmsOrderFormReqVo kmsOrderFormReqVo);

    /**
     * 行信息导出
     *
     * @param reqVo
     * @return
     */
    PageResult<KmsOrderFormExportRespVo> listFprExport(KmsOrderFormReqVo reqVo);
}

