package com.biz.crm.orderform.service;

import com.biz.crm.orderform.model.KmsOrderGoodsEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.kms.orderform.resp.KmsOrderGoodsRespVo;
import com.biz.crm.nebular.kms.orderform.req.KmsOrderGoodsReqVo;

import java.util.Map;

/**
 * 商超订货单商品表接口
 *
 * @author Gavin
 * @date 2021-05-12 18:17:09
 */
public interface IKmsOrderGoodsService extends IService<KmsOrderGoodsEntity> {

    /**
     * 列表
     * @param kmsOrderGoodsReqVo
     * @return PageResult<KmsOrderGoodsRespVo>
     */
    PageResult<KmsOrderGoodsRespVo> findList(KmsOrderGoodsReqVo kmsOrderGoodsReqVo);

    /**
     * 查询
     * @param kmsOrderGoodsReqVo
     * @return KmsOrderGoodsRespVo
     */
    KmsOrderGoodsRespVo query(KmsOrderGoodsReqVo kmsOrderGoodsReqVo);

    /**
     * 新增
     * @param kmsOrderGoodsReqVo
     * @return
     */
    void save(KmsOrderGoodsReqVo kmsOrderGoodsReqVo);

    /**
     * 更新
     * @param kmsOrderGoodsReqVo
     * @return
     */
    void update(KmsOrderGoodsReqVo kmsOrderGoodsReqVo);

    /**
     * 删除
     * @param kmsOrderGoodsReqVo
     * @return
     */
    void deleteBatch(KmsOrderGoodsReqVo kmsOrderGoodsReqVo);

    /**
     * 启用
     * @param kmsOrderGoodsReqVo
     * @return
     */
    void enableBatch(KmsOrderGoodsReqVo kmsOrderGoodsReqVo);

    /**
     * 禁用
     * @param kmsOrderGoodsReqVo
     * @return
     */
    void disableBatch(KmsOrderGoodsReqVo kmsOrderGoodsReqVo);
}

