package com.biz.crm.orderform.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.kms.orderform.req.KmsOrderStatusRecordReqVo;
import com.biz.crm.nebular.kms.orderform.resp.KmsOrderStatusRecordRespVo;
import com.biz.crm.orderform.mapper.KmsOrderStatusRecordMapper;
import com.biz.crm.orderform.model.KmsOrderFormEntity;
import com.biz.crm.orderform.model.KmsOrderStatusRecordEntity;
import com.biz.crm.orderform.service.IKmsOrderStatusRecordService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 商超订货单状态流转记录表接口实现
 *
 * @author Gavin
 * @date 2021-05-12 18:17:09
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="KmsOrderStatusRecordServiceExpandImpl")
public class KmsOrderStatusRecordServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<KmsOrderStatusRecordMapper, KmsOrderStatusRecordEntity> implements IKmsOrderStatusRecordService {

    @Resource
    private KmsOrderStatusRecordMapper kmsOrderStatusRecordMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<KmsOrderStatusRecordRespVo> findList(KmsOrderStatusRecordReqVo reqVo){
        Page<KmsOrderStatusRecordRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<KmsOrderStatusRecordRespVo> list = kmsOrderStatusRecordMapper.findList(page, reqVo);
        return PageResult.<KmsOrderStatusRecordRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return kmsOrderStatusRecordRespVo
     */
    @Override
    public KmsOrderStatusRecordRespVo query(KmsOrderStatusRecordReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(KmsOrderStatusRecordReqVo reqVo){
        KmsOrderStatusRecordEntity entity = CrmBeanUtil.copy(reqVo,KmsOrderStatusRecordEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(KmsOrderStatusRecordReqVo reqVo){
        KmsOrderStatusRecordEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(KmsOrderStatusRecordReqVo reqVo){
        List<KmsOrderStatusRecordEntity> kmsOrderStatusRecordEntities = kmsOrderStatusRecordMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsOrderStatusRecordEntities)){
            kmsOrderStatusRecordEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(kmsOrderStatusRecordEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(KmsOrderStatusRecordReqVo reqVo){
        //设置状态为启用
        List<KmsOrderStatusRecordEntity> kmsOrderStatusRecordEntities = kmsOrderStatusRecordMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsOrderStatusRecordEntities)){
            kmsOrderStatusRecordEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(kmsOrderStatusRecordEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(KmsOrderStatusRecordReqVo reqVo){
        //设置状态为禁用
        List<KmsOrderStatusRecordEntity> kmsOrderStatusRecordEntities = kmsOrderStatusRecordMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsOrderStatusRecordEntities)){
                kmsOrderStatusRecordEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(kmsOrderStatusRecordEntities);
    }

    /**
     * 保存订货单状态记录表
     * @param orderFormEntities
     */
    @Override
    public void insert(List<KmsOrderFormEntity> orderFormEntities) {
        List<KmsOrderStatusRecordEntity> recordEntities = CrmBeanUtil.copyList(orderFormEntities,KmsOrderStatusRecordEntity.class);
        recordEntities.forEach(o -> {
            setNull(o);
        });
        this.saveBatch(recordEntities);
    }

    private void setNull(KmsOrderStatusRecordEntity o) {
        o.setId(null);
        o.setCreateDate(null);
        o.setCreateDateAll(null);
        o.setCreateDateSecond(null);
        o.setUpdateDateAll(null);
        o.setUpdateDateSecond(null);
        o.setUpdateDate(null);
    }

    /**
     * 保存订货单状态记录表
     * @param orderFormEntities
     */
    @Override
    public void insert(KmsOrderFormEntity orderFormEntities) {
        KmsOrderStatusRecordEntity recordEntity = CrmBeanUtil.copy(orderFormEntities,KmsOrderStatusRecordEntity.class);
        setNull(recordEntity);
        this.save(recordEntity);
    }
}
