package com.biz.crm.rawdata.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.kms.rawdata.req.KmsAcceptanceGoodsDetailDwReqVo;
import com.biz.crm.nebular.kms.rawdata.resp.KmsAcceptanceGoodsDetailDwRespVo;
import com.biz.crm.rawdata.service.IKmsAcceptanceGoodsDetailDwService;
import com.biz.crm.util.Result;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 验收单原始单据详情
 *
 * @author Gavin
 * @date 2021-05-12 19:21:10
 */
@Slf4j
@RestController
@RequestMapping("/kmsacceptancegoodsdetaildw")
//@Api(tags = "验收单原始单据详情")
public class KmsAcceptanceGoodsDetailDwController {
    @Autowired
    private IKmsAcceptanceGoodsDetailDwService kmsAcceptanceGoodsDetailDwService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<KmsAcceptanceGoodsDetailDwRespVo>> list(@RequestBody KmsAcceptanceGoodsDetailDwReqVo kmsAcceptanceGoodsDetailDwReqVo) {
        PageResult<KmsAcceptanceGoodsDetailDwRespVo> result=kmsAcceptanceGoodsDetailDwService.findList(kmsAcceptanceGoodsDetailDwReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<KmsAcceptanceGoodsDetailDwRespVo> query(@RequestBody KmsAcceptanceGoodsDetailDwReqVo kmsAcceptanceGoodsDetailDwReqVo) {
        KmsAcceptanceGoodsDetailDwRespVo respVo=kmsAcceptanceGoodsDetailDwService.query(kmsAcceptanceGoodsDetailDwReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody KmsAcceptanceGoodsDetailDwReqVo kmsAcceptanceGoodsDetailDwReqVo) {
        kmsAcceptanceGoodsDetailDwService.save(kmsAcceptanceGoodsDetailDwReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody KmsAcceptanceGoodsDetailDwReqVo kmsAcceptanceGoodsDetailDwReqVo) {
        kmsAcceptanceGoodsDetailDwService.update(kmsAcceptanceGoodsDetailDwReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody KmsAcceptanceGoodsDetailDwReqVo kmsAcceptanceGoodsDetailDwReqVo) {
        kmsAcceptanceGoodsDetailDwService.deleteBatch(kmsAcceptanceGoodsDetailDwReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody KmsAcceptanceGoodsDetailDwReqVo kmsAcceptanceGoodsDetailDwReqVo) {
        kmsAcceptanceGoodsDetailDwService.enableBatch(kmsAcceptanceGoodsDetailDwReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  KmsAcceptanceGoodsDetailDwReqVo kmsAcceptanceGoodsDetailDwReqVo) {
        kmsAcceptanceGoodsDetailDwService.disableBatch(kmsAcceptanceGoodsDetailDwReqVo);
        return Result.ok("禁用成功");
    }
}
