package com.biz.crm.rawdata.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.rawdata.service.IKmsSaleDataFormDetailDwService;
import com.biz.crm.nebular.kms.rawdata.resp.KmsSaleDataFormDetailDwRespVo;
import com.biz.crm.nebular.kms.rawdata.req.KmsSaleDataFormDetailDwReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 库存商超原始单据
 *
 * @author gavin
 * @date 2021-11-24 14:17:12
 */
@Slf4j
@RestController
@RequestMapping("/kmssaledataformdetaildw")
@Api(tags = "库存商超原始单据")
public class KmsSaleDataFormDetailDwController {
    @Autowired
    private IKmsSaleDataFormDetailDwService kmsSaleDataFormDetailDwService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<KmsSaleDataFormDetailDwRespVo>> list(@RequestBody KmsSaleDataFormDetailDwReqVo kmsSaleDataFormDetailDwReqVo) {
        PageResult<KmsSaleDataFormDetailDwRespVo> result=kmsSaleDataFormDetailDwService.findList(kmsSaleDataFormDetailDwReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<KmsSaleDataFormDetailDwRespVo> query(@RequestBody KmsSaleDataFormDetailDwReqVo kmsSaleDataFormDetailDwReqVo) {
        KmsSaleDataFormDetailDwRespVo respVo=kmsSaleDataFormDetailDwService.query(kmsSaleDataFormDetailDwReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody KmsSaleDataFormDetailDwReqVo kmsSaleDataFormDetailDwReqVo) {
        kmsSaleDataFormDetailDwService.save(kmsSaleDataFormDetailDwReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody KmsSaleDataFormDetailDwReqVo kmsSaleDataFormDetailDwReqVo) {
        kmsSaleDataFormDetailDwService.update(kmsSaleDataFormDetailDwReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody KmsSaleDataFormDetailDwReqVo kmsSaleDataFormDetailDwReqVo) {
        kmsSaleDataFormDetailDwService.deleteBatch(kmsSaleDataFormDetailDwReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody KmsSaleDataFormDetailDwReqVo kmsSaleDataFormDetailDwReqVo) {
        kmsSaleDataFormDetailDwService.enableBatch(kmsSaleDataFormDetailDwReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  KmsSaleDataFormDetailDwReqVo kmsSaleDataFormDetailDwReqVo) {
        kmsSaleDataFormDetailDwService.disableBatch(kmsSaleDataFormDetailDwReqVo);
        return Result.ok("禁用成功");
    }
}
