package com.biz.crm.rawdata.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.kms.rawdata.req.KmsOrderFormDetailDwReqVo;
import com.biz.crm.nebular.kms.rawdata.resp.KmsOrderFormDetailDwRespVo;
import com.biz.crm.rawdata.mapper.KmsOrderFormDetailDwMapper;
import com.biz.crm.rawdata.model.KmsOrderFormDetailDwEntity;
import com.biz.crm.rawdata.service.IKmsOrderFormDetailDwService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 原始订单头表接口实现
 *
 * @author Gavin
 * @date 2021-05-12 19:21:10
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="KmsOrderFormDetailDwServiceExpandImpl")
public class KmsOrderFormDetailDwServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<KmsOrderFormDetailDwMapper, KmsOrderFormDetailDwEntity> implements IKmsOrderFormDetailDwService {

    @Resource
    private KmsOrderFormDetailDwMapper kmsOrderFormDetailDwMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<KmsOrderFormDetailDwRespVo> findList(KmsOrderFormDetailDwReqVo reqVo){
        Page<KmsOrderFormDetailDwRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<KmsOrderFormDetailDwRespVo> list = kmsOrderFormDetailDwMapper.findList(page, reqVo);
        return PageResult.<KmsOrderFormDetailDwRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return kmsOrderFormDetailDwRespVo
     */
    @Override
    public KmsOrderFormDetailDwRespVo query(KmsOrderFormDetailDwReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(KmsOrderFormDetailDwReqVo reqVo){
        KmsOrderFormDetailDwEntity entity = CrmBeanUtil.copy(reqVo,KmsOrderFormDetailDwEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(KmsOrderFormDetailDwReqVo reqVo){
        KmsOrderFormDetailDwEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(KmsOrderFormDetailDwReqVo reqVo){
        List<KmsOrderFormDetailDwEntity> kmsOrderFormDetailDwEntities = kmsOrderFormDetailDwMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsOrderFormDetailDwEntities)){
            kmsOrderFormDetailDwEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(kmsOrderFormDetailDwEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(KmsOrderFormDetailDwReqVo reqVo){
        //设置状态为启用
        List<KmsOrderFormDetailDwEntity> kmsOrderFormDetailDwEntities = kmsOrderFormDetailDwMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsOrderFormDetailDwEntities)){
            kmsOrderFormDetailDwEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(kmsOrderFormDetailDwEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(KmsOrderFormDetailDwReqVo reqVo){
        //设置状态为禁用
        List<KmsOrderFormDetailDwEntity> kmsOrderFormDetailDwEntities = kmsOrderFormDetailDwMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsOrderFormDetailDwEntities)){
                kmsOrderFormDetailDwEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(kmsOrderFormDetailDwEntities);
    }

    /**
     * 查询待转换单据信息
     * @param params
     * @return
     */
    @Override
    public List<KmsOrderFormDetailDwRespVo> findNotTransData(KmsOrderFormDetailDwReqVo params) {
        return kmsOrderFormDetailDwMapper.findNotTransData(params);
    }
}
