package com.biz.crm.rawdata.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.kms.rawdata.req.KmsReturnFormDetailDwReqVo;
import com.biz.crm.nebular.kms.rawdata.resp.KmsReturnFormDetailDwRespVo;
import com.biz.crm.rawdata.mapper.KmsReturnFormDetailDwMapper;
import com.biz.crm.rawdata.model.KmsReturnFormDetailDwEntity;
import com.biz.crm.rawdata.service.IKmsReturnFormDetailDwService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 退货单原始数据表接口实现
 *
 * @author Gavin
 * @date 2021-05-12 19:21:10
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="KmsReturnFormDetailDwServiceExpandImpl")
public class KmsReturnFormDetailDwServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<KmsReturnFormDetailDwMapper, KmsReturnFormDetailDwEntity> implements IKmsReturnFormDetailDwService {

    @Resource
    private KmsReturnFormDetailDwMapper kmsReturnFormDetailDwMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<KmsReturnFormDetailDwRespVo> findList(KmsReturnFormDetailDwReqVo reqVo){
        Page<KmsReturnFormDetailDwRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<KmsReturnFormDetailDwRespVo> list = kmsReturnFormDetailDwMapper.findList(page, reqVo);
        return PageResult.<KmsReturnFormDetailDwRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return kmsReturnFormDetailDwRespVo
     */
    @Override
    public KmsReturnFormDetailDwRespVo query(KmsReturnFormDetailDwReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(KmsReturnFormDetailDwReqVo reqVo){
        KmsReturnFormDetailDwEntity entity = CrmBeanUtil.copy(reqVo,KmsReturnFormDetailDwEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(KmsReturnFormDetailDwReqVo reqVo){
        KmsReturnFormDetailDwEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(KmsReturnFormDetailDwReqVo reqVo){
        List<KmsReturnFormDetailDwEntity> kmsReturnFormDetailDwEntities = kmsReturnFormDetailDwMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsReturnFormDetailDwEntities)){
            kmsReturnFormDetailDwEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(kmsReturnFormDetailDwEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(KmsReturnFormDetailDwReqVo reqVo){
        //设置状态为启用
        List<KmsReturnFormDetailDwEntity> kmsReturnFormDetailDwEntities = kmsReturnFormDetailDwMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsReturnFormDetailDwEntities)){
            kmsReturnFormDetailDwEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(kmsReturnFormDetailDwEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(KmsReturnFormDetailDwReqVo reqVo){
        //设置状态为禁用
        List<KmsReturnFormDetailDwEntity> kmsReturnFormDetailDwEntities = kmsReturnFormDetailDwMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsReturnFormDetailDwEntities)){
                kmsReturnFormDetailDwEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(kmsReturnFormDetailDwEntities);
    }

    /**
     * 查询待转换单据信息
     * @param params
     * @return
     */
    @Override
    public List<KmsReturnFormDetailDwRespVo> findNotTransData(KmsReturnFormDetailDwReqVo params) {
        return kmsReturnFormDetailDwMapper.findNotTransData(params);
    }
}
