package com.biz.crm.returnform.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.kms.returnform.req.KmsReturnGoodsReqVo;
import com.biz.crm.nebular.kms.returnform.resp.KmsReturnGoodsRespVo;
import com.biz.crm.returnform.service.IKmsReturnGoodsService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 退货单详情表
 *
 * @author Gavin
 * @date 2021-05-12 18:23:07
 */
@Slf4j
@RestController
@RequestMapping("/kmsreturngoods")
@Api(tags = "退货单商品信息")
public class KmsReturnGoodsController {
    @Autowired
    private IKmsReturnGoodsService kmsReturnGoodsService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<KmsReturnGoodsRespVo>> list(@RequestBody KmsReturnGoodsReqVo kmsReturnGoodsReqVo) {
        PageResult<KmsReturnGoodsRespVo> result=kmsReturnGoodsService.findList(kmsReturnGoodsReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<KmsReturnGoodsRespVo> query(@RequestBody KmsReturnGoodsReqVo kmsReturnGoodsReqVo) {
        KmsReturnGoodsRespVo respVo=kmsReturnGoodsService.query(kmsReturnGoodsReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody KmsReturnGoodsReqVo kmsReturnGoodsReqVo) {
        kmsReturnGoodsService.save(kmsReturnGoodsReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody KmsReturnGoodsReqVo kmsReturnGoodsReqVo) {
        kmsReturnGoodsService.update(kmsReturnGoodsReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody KmsReturnGoodsReqVo kmsReturnGoodsReqVo) {
        kmsReturnGoodsService.deleteBatch(kmsReturnGoodsReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody KmsReturnGoodsReqVo kmsReturnGoodsReqVo) {
        kmsReturnGoodsService.enableBatch(kmsReturnGoodsReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  KmsReturnGoodsReqVo kmsReturnGoodsReqVo) {
        kmsReturnGoodsService.disableBatch(kmsReturnGoodsReqVo);
        return Result.ok("禁用成功");
    }
}
