package com.biz.crm.returnform.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.kms.returnform.req.KmsReturnStatusRecordReqVo;
import com.biz.crm.nebular.kms.returnform.resp.KmsReturnStatusRecordRespVo;
import com.biz.crm.returnform.model.KmsReturnStatusRecordEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 退货单状态记录表
 * 
 * @author Gavin
 * @date 2021-05-12 18:23:07
 */
public interface KmsReturnStatusRecordMapper extends BaseMapper<KmsReturnStatusRecordEntity> {
    /**
     * 列表
     * @param page
     * @param kmsReturnStatusRecordReqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code",orgCode = "t.create_org_code")
    List<KmsReturnStatusRecordRespVo> findList(Page<KmsReturnStatusRecordRespVo> page, @Param("vo") KmsReturnStatusRecordReqVo kmsReturnStatusRecordReqVo);

}
