package com.biz.crm.returnform.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.kms.returnform.req.KmsReturnGoodsReqVo;
import com.biz.crm.nebular.kms.returnform.resp.KmsReturnGoodsRespVo;
import com.biz.crm.returnform.mapper.KmsReturnGoodsMapper;
import com.biz.crm.returnform.model.KmsReturnGoodsEntity;
import com.biz.crm.returnform.service.IKmsReturnGoodsService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 退货单详情表接口实现
 *
 * @author Gavin
 * @date 2021-05-12 18:23:07
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="KmsReturnGoodsServiceExpandImpl")
public class KmsReturnGoodsServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<KmsReturnGoodsMapper, KmsReturnGoodsEntity> implements IKmsReturnGoodsService {

    @Resource
    private KmsReturnGoodsMapper kmsReturnGoodsMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<KmsReturnGoodsRespVo> findList(KmsReturnGoodsReqVo reqVo){
        Page<KmsReturnGoodsRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<KmsReturnGoodsRespVo> list = kmsReturnGoodsMapper.findList(page, reqVo);
        return PageResult.<KmsReturnGoodsRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return kmsReturnGoodsRespVo
     */
    @Override
    public KmsReturnGoodsRespVo query(KmsReturnGoodsReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(KmsReturnGoodsReqVo reqVo){
        KmsReturnGoodsEntity entity = CrmBeanUtil.copy(reqVo,KmsReturnGoodsEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(KmsReturnGoodsReqVo reqVo){
        KmsReturnGoodsEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(KmsReturnGoodsReqVo reqVo){
        List<KmsReturnGoodsEntity> kmsReturnGoodsEntities = kmsReturnGoodsMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsReturnGoodsEntities)){
            kmsReturnGoodsEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(kmsReturnGoodsEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(KmsReturnGoodsReqVo reqVo){
        //设置状态为启用
        List<KmsReturnGoodsEntity> kmsReturnGoodsEntities = kmsReturnGoodsMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsReturnGoodsEntities)){
            kmsReturnGoodsEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(kmsReturnGoodsEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(KmsReturnGoodsReqVo reqVo){
        //设置状态为禁用
        List<KmsReturnGoodsEntity> kmsReturnGoodsEntities = kmsReturnGoodsMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(kmsReturnGoodsEntities)){
                kmsReturnGoodsEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(kmsReturnGoodsEntities);
    }
}
