package com.biz.crm.salesdata.helper;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.kms.KmsAdminEnum;
import com.biz.crm.eunm.kms.KmsEnum;
import com.biz.crm.nebular.kms.rawdata.resp.KmsSaleDataFormDetailDwRespVo;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.rawdata.model.KmsSaleDataFormDetailDwEntity;
import com.biz.crm.rawdata.service.IKmsSaleDataFormDetailDwService;
import com.biz.crm.salesdata.mapper.KmsSalesDataMapper;
import com.biz.crm.salesdata.model.KmsSalesDataEntity;
import com.biz.crm.trans.service.IKmsTransDataService;
import com.biz.crm.trans.vo.TransDataGoodsVo;
import com.biz.crm.trans.vo.TransDataStoreVo;
import com.biz.crm.trans.vo.TransDataVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.KmsUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * @Project crm
 * @PackageName com.biz.crm.saledata.helper
 * @ClassName KmsSalesDataHelper
 * @Author Gavin
 * @Date 2021/9/14 下午3:15
 * @Description 销售数据助手
 */
@Slf4j
@Component
public class KmsSalesDataHelper {

    @Resource
    private IKmsSaleDataFormDetailDwService kmsSaleDataFormDetailDwService;

    @Resource
    private KmsSalesDataMapper kmsSalesDataMapper;

    @Resource
    private IKmsTransDataService kmsTransDataService;

    /**
     * 匹配处理销售版本信息
     *
     * @param dwRespVo
     * @return
     */
    public KmsSalesDataEntity transFormVersion(KmsSaleDataFormDetailDwRespVo dwRespVo) {
        String orderNumber = dwRespVo.getOrderNumber();
        //根据订单号查询原始单据
        KmsSaleDataFormDetailDwEntity dwEntity = kmsSaleDataFormDetailDwService.lambdaQuery()
                .eq(KmsSaleDataFormDetailDwEntity::getOrderNumber, orderNumber).one();
        if (ObjectUtils.isEmpty(dwEntity)) {
            return null;
        }
        //查询是否存在已转换数据
        LambdaQueryWrapper<KmsSalesDataEntity> build = new LambdaQueryWrapper<KmsSalesDataEntity>()
                .eq(KmsSalesDataEntity::getOrderNumber, orderNumber);
        KmsSalesDataEntity kmsSalesDataEntity = kmsSalesDataMapper.selectOne(build);
        if (ObjectUtils.isEmpty(kmsSalesDataEntity)) {
            kmsSalesDataEntity = CrmBeanUtil.copy(dwEntity, KmsSalesDataEntity.class);
            //赋予权限信息
            kmsSalesDataEntity.setCreateCode(dwRespVo.getCreateCode());
            kmsSalesDataEntity.setCreateName(dwRespVo.getCreateName());
            kmsSalesDataEntity.setCreateOrgCode(dwRespVo.getCreateOrgCode());
            kmsSalesDataEntity.setCreateOrgName(dwRespVo.getCreateOrgName());
            kmsSalesDataEntity.setCreatePosCode(dwRespVo.getCreatePosCode());
            kmsSalesDataEntity.setCreatePosName(dwRespVo.getCreatePosName());
            kmsSalesDataEntity.setBsDirectSystemId(dwRespVo.getBsDirectSystemId());
        } else if (!KmsEnum.OrderStatus.S600.getValue().equals(kmsSalesDataEntity.getOrderStatus())) {
            BeanUtils.copyProperties(dwEntity, kmsSalesDataEntity, KmsUtils.ignoreProperties());
            kmsSalesDataEntity.setRemarks(dwEntity.getRemarks());
        }
        //更改转换标示为已转换
        dwEntity.setTransStatus(YesNoEnum.yesNoEnum.ONE.getValue());
        kmsSaleDataFormDetailDwService.updateById(dwEntity);
        return kmsSalesDataEntity;
    }

    /**
     * 数据转换
     *
     * @param salesDataEntity
     */
    public void transData(KmsSalesDataEntity salesDataEntity) {
        //封装转换数据信息
        TransDataVo transDataVo = new TransDataVo();
        transDataVo.setOrderType(KmsAdminEnum.OrderType.SALES_DATA.getValue());
        //头信息
        salesDataEntity.setOrderStatusMsg("");
        TransDataStoreVo dataStoreVo = CrmBeanUtil.copy(salesDataEntity, TransDataStoreVo.class);
        dataStoreVo.setOrderStatusMsg("");
        dataStoreVo.setKaName(salesDataEntity.getKaName());
        dataStoreVo.setKaOrderNumber(salesDataEntity.getKaOrderNumber());
        transDataVo.setStoreVos(dataStoreVo);
        //商品信息
        TransDataGoodsVo dataGoodsVo = CrmBeanUtil.copy(salesDataEntity, TransDataGoodsVo.class);
        dataGoodsVo.setCurUnitOrderQuantity(salesDataEntity.getCurUnitSalesQuantity());
        dataGoodsVo.setKaOrderNumber(salesDataEntity.getKaOrderNumber());
        dataGoodsVo.setOrderStatusMsg("");
        dataGoodsVo.setKaName(salesDataEntity.getKaName());
        dataGoodsVo.setOrderDate(salesDataEntity.getSalesDate());
        transDataVo.getGoodsVos().add(dataGoodsVo);
        //数据转换
        kmsTransDataService.transData(transDataVo);
        //结果数据处理
        resultProcessing(salesDataEntity, transDataVo);
    }

    /**
     * 结果数据处理
     *
     * @param salesDataEntity
     * @param transDataVo
     */
    private void resultProcessing(KmsSalesDataEntity salesDataEntity, TransDataVo transDataVo) {
        String orderNumber = salesDataEntity.getOrderNumber();
        //转换结果信息
        TransDataStoreVo transDataStoreVo = transDataVo.getStoreVos();
        //确认转换状态
        String orderStatusMsg = salesDataEntity.getOrderStatusMsg();
        //商品处理
        TransDataGoodsVo transDataGoodsVo = transDataVo.getGoodsVos().get(0);
        //商品行信息处理
        BeanUtils.copyProperties(transDataGoodsVo, salesDataEntity, Arrays.stream(CrmBaseVo.class.getDeclaredFields())
                .map(Field::getName)
                .collect(Collectors.toList()).toArray(new String[]{}));
        salesDataEntity.setKaCode(transDataStoreVo.getKaCode());
        //门店处理
        salesDataEntity.setStoreCode(transDataStoreVo.getStoreCode());
        salesDataEntity.setStoreName(transDataStoreVo.getStoreName());
        salesDataEntity.setAreaName(transDataStoreVo.getAreaName());

        if (!StringUtils.isEmpty(transDataStoreVo.getOrderStatusMsg()) || !StringUtils.isEmpty(transDataGoodsVo.getOrderStatusMsg())) {
            salesDataEntity.setOrderStatus(KmsEnum.OrderStatus.S100.getValue());
            salesDataEntity.setOrderStatusMsg(transDataStoreVo.getOrderStatusMsg() + "|" + transDataGoodsVo.getOrderStatusMsg());
        } else {
            salesDataEntity.setOrderStatus(KmsEnum.OrderStatus.S400.getValue());
            salesDataEntity.setOrderStatusMsg(KmsEnum.OrderStatus.S400.getDescription());
        }
    }
}