package com.biz.crm.sap.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.nebular.kms.finance.req.KmsAuditFormReqVo;
import com.biz.crm.nebular.kms.sap.req.KmsSapInvoiceReqVo;
import com.biz.crm.nebular.kms.sap.resp.KmsSapInvoiceRespVo;
import com.biz.crm.nebular.kms.sap.resp.KmsSapOrderFormRespVo;
import com.biz.crm.sap.model.KmsSapInvoiceEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * SAP发票信息
 *
 * @author Gavin
 * @date 2021-06-01 17:23:11
 */
public interface KmsSapInvoiceMapper extends BaseMapper<KmsSapInvoiceEntity> {

    /**
     * 根据稽核ID查询关联SAP数据
     *
     * @param auditFormId
     * @return
     */
    List<KmsSapOrderFormRespVo> findByAuditFormId(@Param("auditFormId") String auditFormId);

    /**
     * 查询关联SAP发票集合
     *
     * @return
     */
    List<KmsSapOrderFormRespVo> findList(@Param("vo") KmsAuditFormReqVo formReqVo);

    /**
     * SAP原始数据列表
     *
     * @param page
     * @param params
     * @return
     */
    List<KmsSapInvoiceRespVo> findSapInvoicePage(Page<KmsSapInvoiceRespVo> page, @Param("vo") KmsSapInvoiceReqVo params);

    /**
     * 获取未汇总的数据
     *
     * @param orgCode
     * @param id
     * @return
     */
    List<KmsSapInvoiceRespVo> findNotSummary(@Param("orgCode") String orgCode, @Param("auditTemplateId") String auditTemplateId, @Param("invoiceIds") List<String> invoiceIds);

    /**
     * 根据稽核ID集合批量查询稽核单关联的SAP数据
     *
     * @param auditIds
     * @return
     */
    List<KmsSapOrderFormRespVo> findByAuditFormAuditIds(@Param("auditIds") List<String> auditIds);
}
