package com.biz.crm.sap.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.kms.sap.req.KmsSapOrderFormReqVo;
import com.biz.crm.nebular.kms.sap.resp.KmsSapOrderFormRespVo;
import com.biz.crm.sap.model.KmsSapOrderFormEntity;

/**
 * SAP数据接口
 *
 * @author Gavin
 * @date 2021-05-27 14:34:14
 */
public interface IKmsSapOrderFormService extends IService<KmsSapOrderFormEntity> {

    /**
     * 列表
     * @param kmsSapOrderFormReqVo
     * @return PageResult<KmsSapOrderFormRespVo>
     */
    PageResult<KmsSapOrderFormRespVo> findList(KmsSapOrderFormReqVo kmsSapOrderFormReqVo);

    /**
     * 查询
     * @param kmsSapOrderFormReqVo
     * @return KmsSapOrderFormRespVo
     */
    KmsSapOrderFormRespVo query(KmsSapOrderFormReqVo kmsSapOrderFormReqVo);

    /**
     * 新增
     * @param kmsSapOrderFormReqVo
     * @return
     */
    void save(KmsSapOrderFormReqVo kmsSapOrderFormReqVo);

    /**
     * 更新
     * @param kmsSapOrderFormReqVo
     * @return
     */
    void update(KmsSapOrderFormReqVo kmsSapOrderFormReqVo);

    /**
     * 删除
     * @param kmsSapOrderFormReqVo
     * @return
     */
    void deleteBatch(KmsSapOrderFormReqVo kmsSapOrderFormReqVo);

    /**
     * 启用
     * @param kmsSapOrderFormReqVo
     * @return
     */
    void enableBatch(KmsSapOrderFormReqVo kmsSapOrderFormReqVo);

    /**
     * 禁用
     * @param kmsSapOrderFormReqVo
     * @return
     */
    void disableBatch(KmsSapOrderFormReqVo kmsSapOrderFormReqVo);
}

