package com.biz.crm.stockdata.helper;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.kms.KmsAdminEnum;
import com.biz.crm.eunm.kms.KmsEnum;
import com.biz.crm.nebular.kms.rawdata.resp.KmsInventoryDataFormDetailDwRespVo;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.rawdata.model.KmsInventoryDataFormDetailDwEntity;
import com.biz.crm.rawdata.service.IKmsInventoryDataFormDetailDwService;
import com.biz.crm.stockdata.mapper.KmsStockDataMapper;
import com.biz.crm.stockdata.model.KmsStockDataEntity;
import com.biz.crm.trans.service.IKmsTransDataService;
import com.biz.crm.trans.vo.TransDataGoodsVo;
import com.biz.crm.trans.vo.TransDataStoreVo;
import com.biz.crm.trans.vo.TransDataVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.KmsUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * @Project crm
 * @PackageName com.biz.crm.stockdata.helper
 * @ClassName KmsStockDataHelper
 * @Author Gavin
 * @Date 2021/9/14 下午3:19
 * @Description 库存数据助手
 */
@Slf4j
@Component
public class KmsStockDataHelper {

    @Resource
    private IKmsInventoryDataFormDetailDwService kmsInventoryDataFormDetailDwService;

    @Resource
    private KmsStockDataMapper kmsStockDataMapper;

    @Resource
    private IKmsTransDataService kmsTransDataService;

    /**
     * 匹配处理库存版本信息
     *
     * @param dwRespVo
     * @return
     */
    public KmsStockDataEntity transFormVersion(KmsInventoryDataFormDetailDwRespVo dwRespVo) {
        String orderNumber = dwRespVo.getOrderNumber();
        //根据订单号查询原始单据
        KmsInventoryDataFormDetailDwEntity dwEntity = kmsInventoryDataFormDetailDwService.lambdaQuery()
                .eq(KmsInventoryDataFormDetailDwEntity::getOrderNumber, orderNumber).one();
        if (ObjectUtils.isEmpty(dwEntity)) {
            return null;
        }
        //查询是否存在已转换数据
        LambdaQueryWrapper<KmsStockDataEntity> build = new LambdaQueryWrapper<KmsStockDataEntity>()
                .eq(KmsStockDataEntity::getOrderNumber, orderNumber);
        KmsStockDataEntity kmsStockDataEntity = kmsStockDataMapper.selectOne(build);
        if (ObjectUtils.isEmpty(kmsStockDataEntity)) {
            kmsStockDataEntity = CrmBeanUtil.copy(dwEntity, KmsStockDataEntity.class);
            //赋予权限信息
            kmsStockDataEntity.setCreateCode(dwRespVo.getCreateCode());
            kmsStockDataEntity.setCreateName(dwRespVo.getCreateName());
            kmsStockDataEntity.setCreateOrgCode(dwRespVo.getCreateOrgCode());
            kmsStockDataEntity.setCreateOrgName(dwRespVo.getCreateOrgName());
            kmsStockDataEntity.setCreatePosCode(dwRespVo.getCreatePosCode());
            kmsStockDataEntity.setCreatePosName(dwRespVo.getCreatePosName());
            kmsStockDataEntity.setBsDirectSystemId(dwRespVo.getBsDirectSystemId());
        } else if (!KmsEnum.OrderStatus.S600.getValue().equals(kmsStockDataEntity.getOrderStatus())) {
            BeanUtils.copyProperties(dwEntity, kmsStockDataEntity, KmsUtils.ignoreProperties());
            kmsStockDataEntity.setRemarks(dwEntity.getRemarks());
        }
        //更改转换标示为已转换
        dwEntity.setTransStatus(YesNoEnum.yesNoEnum.ONE.getValue());
        kmsInventoryDataFormDetailDwService.updateById(dwEntity);
        return kmsStockDataEntity;
    }

    /**
     * 数据转换
     *
     * @param stockDataEntity
     */
    public void transData(KmsStockDataEntity stockDataEntity) {
        //封装转换数据信息
        TransDataVo transDataVo = new TransDataVo();
        transDataVo.setOrderType(KmsAdminEnum.OrderType.SALES_DATA.getValue());
        //头信息
        stockDataEntity.setOrderStatusMsg("");
        TransDataStoreVo dataStoreVo = CrmBeanUtil.copy(stockDataEntity, TransDataStoreVo.class);
        dataStoreVo.setOrderStatusMsg("");
        dataStoreVo.setKaName(stockDataEntity.getKaName());
        dataStoreVo.setKaOrderNumber(stockDataEntity.getKaOrderNumber());
        transDataVo.setStoreVos(dataStoreVo);
        //商品信息
        TransDataGoodsVo dataGoodsVo = CrmBeanUtil.copy(stockDataEntity, TransDataGoodsVo.class);
        dataGoodsVo.setCurUnitOrderQuantity(stockDataEntity.getCurUnitInventoryQuantity());
        dataGoodsVo.setKaOrderNumber(stockDataEntity.getKaOrderNumber());
        dataGoodsVo.setOrderStatusMsg("");
        dataGoodsVo.setKaName(stockDataEntity.getKaName());
        dataGoodsVo.setOrderDate(stockDataEntity.getInventoryDate());
        transDataVo.getGoodsVos().add(dataGoodsVo);
        //数据转换
        kmsTransDataService.transData(transDataVo);
        //结果数据处理
        resultProcessing(stockDataEntity, transDataVo);
    }

    /**
     * 结果数据处理
     *
     * @param stockDataEntity
     * @param transDataVo
     */
    private void resultProcessing(KmsStockDataEntity stockDataEntity, TransDataVo transDataVo) {
        String orderNumber = stockDataEntity.getOrderNumber();
        //转换结果信息
        TransDataStoreVo transDataStoreVo = transDataVo.getStoreVos();
        //商品处理
        TransDataGoodsVo transDataGoodsVo = transDataVo.getGoodsVos().get(0);
        //商品行信息处理
        BeanUtils.copyProperties(transDataGoodsVo, stockDataEntity, Arrays.stream(CrmBaseVo.class.getDeclaredFields())
                .map(Field::getName)
                .collect(Collectors.toList()).toArray(new String[]{}));
        stockDataEntity.setKaCode(transDataStoreVo.getKaCode());
        //门店处理
        stockDataEntity.setStoreCode(transDataStoreVo.getStoreCode());
        stockDataEntity.setStoreName(transDataStoreVo.getStoreName());
        stockDataEntity.setAreaName(transDataStoreVo.getAreaName());

        if (!StringUtils.isEmpty(transDataStoreVo.getOrderStatusMsg()) || !StringUtils.isEmpty(transDataGoodsVo.getOrderStatusMsg())) {
            stockDataEntity.setOrderStatus(KmsEnum.OrderStatus.S100.getValue());
            stockDataEntity.setOrderStatusMsg(transDataStoreVo.getOrderStatusMsg() + "|" + transDataGoodsVo.getOrderStatusMsg());
        } else {
            stockDataEntity.setOrderStatus(KmsEnum.OrderStatus.S400.getValue());
            stockDataEntity.setOrderStatusMsg(KmsEnum.OrderStatus.S400.getDescription());
        }
    }
}