package com.biz.crm.supermarket.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectCustomerOrgReqVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsTenantryDirectCustomerOrgRespVo;
import com.biz.crm.supermarket.service.IKmsTenantryDirectCustomerOrgService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 客户组织与抓单商超（直营体系）关系表
 *
 * @author Gavin
 * @date 2021-04-13 17:05:17
 */
@Slf4j
@RestController
@RequestMapping("/kmstenantrydirectcustomerorg")
@Api(tags = "客户组织与抓单商超（直营体系）关系表")
public class KmsTenantryDirectCustomerOrgController {
    @Autowired
    private IKmsTenantryDirectCustomerOrgService kmsTenantryDirectCustomerOrgService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<KmsTenantryDirectCustomerOrgRespVo>> list(@RequestBody KmsTenantryDirectCustomerOrgReqVo kmsTenantryDirectCustomerOrgReqVo) {
        PageResult<KmsTenantryDirectCustomerOrgRespVo> result = kmsTenantryDirectCustomerOrgService.findList(kmsTenantryDirectCustomerOrgReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @CrmLog
    public Result<KmsTenantryDirectCustomerOrgRespVo> query(@RequestParam(value = "id", required = false) String id) {
        KmsTenantryDirectCustomerOrgRespVo respVo = kmsTenantryDirectCustomerOrgService.query(id);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody KmsTenantryDirectCustomerOrgReqVo kmsTenantryDirectCustomerOrgReqVo) {
        kmsTenantryDirectCustomerOrgService.save(kmsTenantryDirectCustomerOrgReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody KmsTenantryDirectCustomerOrgReqVo kmsTenantryDirectCustomerOrgReqVo) {
        kmsTenantryDirectCustomerOrgService.update(kmsTenantryDirectCustomerOrgReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        kmsTenantryDirectCustomerOrgService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        kmsTenantryDirectCustomerOrgService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        kmsTenantryDirectCustomerOrgService.disableBatch(ids);
        return Result.ok("禁用成功");
    }

//    /**
//     * 新增直营体系 获取客户组织下拉框
//     */
//    @ApiOperation(value = "新增直营体系 获取客户组织下拉框")
//    @PostMapping("/findCusOrgList")
//    @CrmLog
//    public Result<List<MdmCustomerOrgSelectRespVo>> findCusOrgList(@RequestBody CusOrgVo cusOrgVo) {
//        List<MdmCustomerOrgSelectRespVo> customerOrgSelectRespVos = kmsTenantryDirectCustomerOrgService.findCusOrgList(cusOrgVo);
//        return Result.ok(customerOrgSelectRespVos);
//    }
}
