package com.biz.crm.supermarket.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectStoreReqVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsTenantryDirectStoreRespVo;
import com.biz.crm.supermarket.service.IKmsTenantryDirectStoreService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 企业门店与商超门店关系
 *
 * @author Gavin
 * @date 2021-04-15 11:31:07
 */
@Slf4j
@RestController
@RequestMapping("/kmstenantrydirectstore")
@Api(tags = "企业门店与商超门店关系")
public class KmsTenantryDirectStoreController {

    @Autowired
    private IKmsTenantryDirectStoreService kmsTenantryDirectStoreService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<KmsTenantryDirectStoreRespVo>> list(@RequestBody KmsTenantryDirectStoreReqVo kmsTenantryDirectStoreReqVo) {
        PageResult<KmsTenantryDirectStoreRespVo> result = kmsTenantryDirectStoreService.findList(kmsTenantryDirectStoreReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @CrmLog
    public Result<KmsTenantryDirectStoreRespVo> query(@RequestParam(value = "id", required = false) String id) {
        KmsTenantryDirectStoreRespVo respVo = kmsTenantryDirectStoreService.query(id);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody KmsTenantryDirectStoreReqVo kmsTenantryDirectStoreReqVo) {
        kmsTenantryDirectStoreService.save(kmsTenantryDirectStoreReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody KmsTenantryDirectStoreReqVo kmsTenantryDirectStoreReqVo) {
        kmsTenantryDirectStoreService.update(kmsTenantryDirectStoreReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        kmsTenantryDirectStoreService.deleteBatch(ids);
        return Result.ok("操作成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        kmsTenantryDirectStoreService.enableBatch(ids);
        return Result.ok("操作成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        kmsTenantryDirectStoreService.disableBatch(ids);
        return Result.ok("操作成功");
    }


//    @ApiOperation(value = "企业门店与商超门店关系新增获取企业门店集合")
//    @PostMapping("/findTerminalList")
//    @CrmLog
//    public List<MdmTerminalVo> finTerminalList(@RequestBody MdmTerminalVo mdmTerminalVo) {
//        List<MdmTerminalVo> terminalVos = kmsTenantryDirectStoreService.findTerminalList(mdmTerminalVo);
//        return terminalVos;
//    }
}
