package com.biz.crm.supermarket.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.kms.supermarket.req.KmsSupplierReqVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsSupplierRespVo;
import com.biz.crm.supermarket.model.KmsSupplierEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 售达方与供应商关系表
 * 
 * @author gavin
 * @date 2021-07-06 13:58:17
 */
public interface KmsSupplierMapper extends BaseMapper<KmsSupplierEntity> {
    /**
     * 列表
     * @param page
     * @param kmsSupplierReqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code", orgCode = "t.create_org_code")
    List<KmsSupplierRespVo> findList(Page<KmsSupplierRespVo> page, @Param("vo") KmsSupplierReqVo kmsSupplierReqVo);


    /**
     * 集合
     * @param page
     * @param kmsSupplierReqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code", orgCode = "t.create_org_code")
    List<KmsSupplierRespVo> findList(@Param("vo") KmsSupplierReqVo kmsSupplierReqVo);
}
