package com.biz.crm.supermarket.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectAccountReqVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsTenantryDirectAccountRespVo;
import com.biz.crm.supermarket.model.KmsTenantryDirectAccountEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 抓单账号管理
 *
 * @author Gavin
 * @date 2021-04-13 23:19:46
 */
public interface KmsTenantryDirectAccountMapper extends BaseMapper<KmsTenantryDirectAccountEntity> {
    /**
     * 列表
     *
     * @param page
     * @param kmsTenantryDirectAccountReqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code", orgCode = "t.create_org_code")
    List<KmsTenantryDirectAccountRespVo> findList(Page<KmsTenantryDirectAccountRespVo> page, @Param("vo") KmsTenantryDirectAccountReqVo kmsTenantryDirectAccountReqVo);

    /**
     * 查询列表 （为了检验重复）
     *
     * @param accountReqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code", orgCode = "t.create_org_code")
    List<KmsTenantryDirectAccountEntity> selectListByCompetenceForExist(@Param("vo") KmsTenantryDirectAccountReqVo accountReqVo);
}
