package com.biz.crm.supermarket.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectCustomerOrgReqVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsTenantryDirectCustomerOrgRespVo;
import com.biz.crm.supermarket.model.KmsTenantryDirectCustomerOrgEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 客户组织与抓单商超（直营体系）关系表
 *
 * @author Gavin
 * @date 2021-04-13 17:05:17
 */
public interface KmsTenantryDirectCustomerOrgMapper extends BaseMapper<KmsTenantryDirectCustomerOrgEntity> {
    /**
     * 列表
     *
     * @param page
     * @param kmsTenantryDirectCustomerOrgReqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code", orgCode = "t.create_org_code")
    List<KmsTenantryDirectCustomerOrgRespVo> findList(Page<KmsTenantryDirectCustomerOrgRespVo> page, @Param("vo") KmsTenantryDirectCustomerOrgReqVo kmsTenantryDirectCustomerOrgReqVo);

    /**
     * 列表
     *
     * @param page
     * @param kmsTenantryDirectCustomerOrgReqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code", orgCode = "t.create_org_code")
    List<KmsTenantryDirectCustomerOrgRespVo> findList(@Param("vo") KmsTenantryDirectCustomerOrgReqVo kmsTenantryDirectCustomerOrgReqVo);


    /**
     * 条件查询
     * 数据权限
     *
     * @param customerOrgReqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code", orgCode = "t.create_org_code")
    List<KmsTenantryDirectCustomerOrgEntity> selectListByCompetence(@Param("vo") KmsTenantryDirectCustomerOrgReqVo customerOrgReqVo);

    /**
     * 条件查询（检验存在）
     * 数据权限
     *
     * @param customerOrgReqVoForId
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code", orgCode = "t.create_org_code")
    List<KmsTenantryDirectCustomerOrgEntity> selectListByCompetenceForExist(@Param("vo") KmsTenantryDirectCustomerOrgReqVo customerOrgReqVoForId);
}
