package com.biz.crm.supermarket.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectStoreReqVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsTenantryDirectStoreRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.supermarket.model.KmsTenantryDirectStoreEntity;

import java.util.List;

/**
 * 企业门店与商超门店关系接口
 *
 * @author Gavin
 * @date 2021-04-15 11:31:07
 */
public interface IKmsTenantryDirectStoreService extends IService<KmsTenantryDirectStoreEntity> {

    /**
     * 列表
     *
     * @param kmsTenantryDirectStoreReqVo
     * @return PageResult<KmsTenantryDirectStoreRespVo>
     */
    PageResult<KmsTenantryDirectStoreRespVo> findList(KmsTenantryDirectStoreReqVo kmsTenantryDirectStoreReqVo);


    /**
     * 新增
     *
     * @param kmsTenantryDirectStoreReqVo
     * @return
     */
    void save(KmsTenantryDirectStoreReqVo kmsTenantryDirectStoreReqVo);

    /**
     * 更新
     *
     * @param kmsTenantryDirectStoreReqVo
     * @return
     */
    void update(KmsTenantryDirectStoreReqVo kmsTenantryDirectStoreReqVo);

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    void disableBatch(List<String> ids);

    /**
     * 查询
     *
     * @param id
     * @return
     */
    KmsTenantryDirectStoreRespVo query(String id);

    /**
     * 企业门店与商超门店关系新增获取企业门店集合
     *
     * @param mdmTerminalVo
     * @return
     */
    List<MdmTerminalVo> findTerminalList(MdmTerminalVo mdmTerminalVo);

   
}

