package com.biz.crm.trans.vo;

import lombok.Data;

import java.math.BigDecimal;

/**
 * @Project crm
 * @PackageName com.biz.crm.vo
 * @ClassName TransDataGoodsVo
 * @Author Gavin
 * @Date 2021/5/18 上午11:01
 * @Description 商品数据转换对象
 */
@Data
public class TransDataGoodsVo extends TransBaseVo {
    private static final long serialVersionUID = -1879314103040406919L;

    /**
     * 商超名称
     */
    private String kaName;

    /**
     * 单据号
     */
    private String kaOrderNumber;

    /**
     * 企业产品编号
     */
    private String goodsCode;

    /**
     * 企业产品名称
     */
    private String goodsName;

    /**
     * 商超产品编号
     */
    private String kaGoodsCode;

    /**
     * 关联ID(企业商品与商超商品表ID)
     */
    private String goodsRelatedId;

    /**
     * 商超当前单位
     */
    private String curUnit;

    /**
     * 单据日期
     */
    private String orderDate;

    /**
     * 商超当前单位单据数量
     */
    private String curUnitOrderQuantity;

    /**
     * 单位转换系数
     */
    private BigDecimal numerator;

    /**
     * 单位转换系数
     */
    private BigDecimal ratio;

    /**
     * 企业当前单位
     */
    private String curCompanyUnit;

    /**
     * 企业当前单位订货数量
     */
    private String curCompanyUnitOrderQuantity;

    /**
     * 转换异常信息
     */
    private String orderStatusMsg;
}