package com.biz.crm.trans.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @Project crm
 * @PackageName com.biz.crm.vo
 * @ClassName TransDataStoreVo
 * @Author Gavin
 * @Date 2021/5/18 上午11:00
 * @Description 门店转换数据封装对象
 */
@Data
public class TransDataStoreVo extends TransBaseVo {
    private static final long serialVersionUID = 4015089980380634762L;

    /**
     * 商超ID（看着是编码实际是ID）
     */
    private String kaCode;

    /**
     * 商超名称
     */
    private String kaName;

    /**
     * 单据号
     */
    private String kaOrderNumber;

    /**
     * 商超门店/大仓编号
     */
    private String kaStoreCode;

    /**
     * 商超门店名称
     */
    private String kaStoreName;

    /**
     * 供应商名称
     */
    private String supplierName;

    /**
     * 供应商编码
     */
    private String supplierCode;

    /**
     * 门店区域编码
     */
    private String areaCode;

    /**
     * 门店区域名称
     */
    private String areaName;


    /**
     * 企业门店/大仓编号
     */
    private String storeCode;

    /**
     * 企业门店/大仓名称
     */
    private String storeName;

    /**
     * 直营体系
     */
    private String bsDirectSystemId;

    @ApiModelProperty("售达方名称")
    private String soldToPartyName;

    @ApiModelProperty("售达方编码")
    private String soldToPartyCode;

    @ApiModelProperty("客户组织编码")
    private String customerOrgCode;

    @ApiModelProperty("客户组织类型")
    private String customerOrgType;

    @ApiModelProperty("渠道")
    private String channel;

    @ApiModelProperty("对账匹配阈值（天数）")
    private Integer timeOfDay;

    /**
     * 关联ID(企业门店与商超门店表ID)
     */
    private String storeRelatedId;

    /**
     * 转换异常信息
     */
    private String orderStatusMsg;
}