package com.biz.crm.util;

import com.biz.crm.eunm.mdm.MdmOrgTypeEnum;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.google.common.collect.Maps;
import org.springframework.util.ObjectUtils;

import java.util.List;
import java.util.Map;

/**
 * @Project crm
 * @PackageName com.biz.crm.util
 * @ClassName KmsOrgUtil
 * @Author Gavin
 * @Date 2021/5/20 下午3:50
 * @Description kms专用组织工具类
 */
public class KmsOrgUtil {

    /**
     * 获取当前组织公司层级编码
     * @param currOrgCode
     * @return
     */
    public static String getCompanyOrgCode(String currOrgCode) {
        List<MdmOrgRespVo> includeSelf = OrgUtil.getParentOrgListIncludeSelf(currOrgCode);
        MdmOrgRespVo mdmOrgRespVo = includeSelf.stream()
                .filter(o -> MdmOrgTypeEnum.COMPANY.getValue().equals(o.getOrgType()))
                .findFirst().orElse(null);
        return ObjectUtils.isEmpty(mdmOrgRespVo) ? null : mdmOrgRespVo.getOrgCode();
    }

    /**
     * 获取当前组织公司
     * @param currOrgCode
     * @return
     */
    public static MdmOrgRespVo getCompanyOrg(String currOrgCode) {
        List<MdmOrgRespVo> includeSelf = OrgUtil.getParentOrgListIncludeSelf(currOrgCode);
        MdmOrgRespVo mdmOrgRespVo = includeSelf.stream()
                .filter(o -> MdmOrgTypeEnum.COMPANY.getValue().equals(o.getOrgType()))
                .findFirst().orElse(null);
        return mdmOrgRespVo;
    }

    /**
     * 查询当前创建者所属公司
     * @param createOrgCodes
     * @return
     */
    public static Map<String, String> findCompanyByCreateOrgCodes(List<String> createOrgCodes) {
        Map<String,String> orgCompanyMap = Maps.newHashMap();
        createOrgCodes.forEach(o -> {
            MdmOrgRespVo companyOrg = getCompanyOrg(o);
            if(!ObjectUtils.isEmpty(companyOrg)){
                orgCompanyMap.put(o,companyOrg.getOrgName());
            }
        });
        return orgCompanyMap;
    }
}