package com.biz.crm.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.HashMap;
import java.util.Map;

/**
 * 响应
 *
 * @author wangyihuai
 * @version 1.0
 * @date  2019/03/18 下午 04:31
 */
@ApiModel(description = "通用json返回对象")
@Data
public class JsonResult {
    public static final String CODE_SUCCESS = "SUCCESS";
    public static final String CODE_ERROR = "ERROR";
    /**
     * 响应 SUCCESS，ERROR
     */
    @ApiModelProperty(value = "请求成功Code",example = CODE_SUCCESS)
    private String code = CODE_SUCCESS;
    /**
     * 响应信息
     */
    @ApiModelProperty(value = "响应信息",example = "操作成功")
    private String message = "操作成功";
    /**
     * 响应数据
     */
    @ApiModelProperty(value = "响应数据")
    private Object data;
    /**
     * 时间戳
     */
    @ApiModelProperty(value = "时间戳",example = "123456789")
    private Long ts = System.currentTimeMillis();

    public JsonResult() {
    }

    public JsonResult(String service){
        this(JsonResult.CODE_ERROR,service+"服务不可用");
    }

    public JsonResult(Object data) {
        this(CODE_SUCCESS, null, data);
    }

    public JsonResult(String code, String message) {
        this(code, message, null);
    }

    public JsonResult(String key, Object value) {
        this.ts = System.currentTimeMillis();
        this.code = CODE_SUCCESS;
        Map<String, Object> m = new HashMap<>(1);
        m.put(key, value);
        data = m;
    }

    public JsonResult(String code, String message, Object data) {
        this.code = code;
        this.message = message;
        this.data = data;
        ts = System.currentTimeMillis();
    }

}
