package com.biz.crm.webservice.order.req;

import com.biz.crm.base.BusinessException;
import com.biz.crm.constant.KmsConstant;
import com.biz.crm.nebular.kms.orderform.resp.KmsOrderFormRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.KmsUtils;
import lombok.Builder;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import java.util.Calendar;
import java.util.Map;

/**
 * @Project crm
 * @PackageName com.biz.crm.webservice.data
 * @ClassName KmsSapOrderHeaderVo
 * @Author Gavin
 * @Date 2021/5/28 下午1:56
 * @Description sap订单头
 */
@XmlRootElement
public class KmsSapOrderHeaderVo {

    private static final String SAP_KA_ORDER_PREFIX = "KMS-";

    /**
     * 客户编号(MDM-客户中心-客户信息)
     */
    @XmlElement(name = "KUNNR")
    private String kunnr = "";

    /**
     * 送达方(MDM-客户中心-终端信息)
     */
    @XmlElement(name = "KUNWE")
    private String kunwe = "";

    /**
     * 销售组织(MDM-组织中心-客户组织)
     */
    @XmlElement(name = "VKORG")
    private String vkorg = "";

    /**
     * 分销渠道(MDM-客户中心-客户信息-渠道，数据字典中维护“CRM产品通用渠道类型”)
     */
    @XmlElement(name = "VTWEG")
    private String vtweg = "";

    /**
     * 产品组
     */
    @XmlElement(name = "SPART")
    private String spart = "01";

    /**
     * 销售凭证类型
     */
    @XmlElement(name = "AUART")
    private String auart = "ZOR";

    /**
     * 客户采购订单编号(KMS + 商超订单号 + 送达方编号)
     */
    @XmlElement(name = "BSTKD")
    private String bstkd = "";

    /**
     * 交货日期
     */
    @XmlElement(name = "LFDAT")
    private String lfdat = "";

    /**
     * 订购原因( 业务原因 )
     */
    @XmlElement(name = "AUGRU")
    private String augru = "";

    /**
     * 备注
     */
    @XmlElement(name = "ZZ001")
    private String zz001 = "";

    /**
     * 成本中心
     */
    @XmlElement(name = "KOSTL")
    private String kostl = "";

    /**
     * 凭证日期 (接收/发送日期)
     */
    @XmlElement(name = "AUDAT")
    private String audat = "";

    /**
     * 活动(外部标识)
     */
    @XmlElement(name = "CMPGN_EXTID")
    private String cmpgnExtid = "";

    /**
     * 送达方 2
     */
    @XmlElement(name = "KUNWE2")
    private String kunwe2 = "";

    /**
     * 您的参考 单据-订单-是否加急为“是”
     */
    @XmlElement(name = "IHREZ")
    private String ihrez = "";

    /**
     * 集中编号 (SD)
     */
    @XmlElement(name = "SUBMI")
    private String submi = "";

    @XmlTransient
    public String getKunnr() {
        return kunnr;
    }

    public void setKunnr(String kunnr) {
        this.kunnr = kunnr;
    }

    @XmlTransient
    public String getKunwe() {
        return kunwe;
    }

    public void setKunwe(String kunwe) {
        this.kunwe = kunwe;
    }

    @XmlTransient
    public String getVkorg() {
        return vkorg;
    }

    public void setVkorg(String vkorg) {
        this.vkorg = vkorg;
    }

    @XmlTransient
    public String getVtweg() {
        return vtweg;
    }

    public void setVtweg(String vtweg) {
        this.vtweg = vtweg;
    }

    @XmlTransient
    public String getSpart() {
        return spart;
    }

    public void setSpart(String spart) {
        this.spart = spart;
    }

    @XmlTransient
    public String getAuart() {
        return auart;
    }

    public void setAuart(String auart) {
        this.auart = auart;
    }

    @XmlTransient
    public String getBstkd() {
        return bstkd;
    }

    public void setBstkd(String bstkd) {
        this.bstkd = bstkd;
    }

    @XmlTransient
    public String getLfdat() {
        return lfdat;
    }

    public void setLfdat(String lfdat) {
        this.lfdat = lfdat;
    }

    @XmlTransient
    public String getAugru() {
        return augru;
    }

    public void setAugru(String augru) {
        this.augru = augru;
    }

    @XmlTransient
    public String getZz001() {
        return zz001;
    }

    public void setZz001(String zz001) {
        this.zz001 = zz001;
    }

    @XmlTransient
    public String getKostl() {
        return kostl;
    }

    public void setKostl(String kostl) {
        this.kostl = kostl;
    }

    @XmlTransient
    public String getAudat() {
        return audat;
    }

    public void setAudat(String audat) {
        this.audat = audat;
    }

    @XmlTransient
    public String getCmpgnExtid() {
        return cmpgnExtid;
    }

    public void setCmpgnExtid(String cmpgnExtid) {
        this.cmpgnExtid = cmpgnExtid;
    }

    @XmlTransient
    public String getKunwe2() {
        return kunwe2;
    }

    public void setKunwe2(String kunwe2) {
        this.kunwe2 = kunwe2;
    }

    @XmlTransient
    public String getIhrez() {
        return ihrez;
    }

    public void setIhrez(String ihrez) {
        this.ihrez = ihrez;
    }

    @XmlTransient
    public String getSubmi() {
        return submi;
    }

    public void setSubmi(String submi) {
        this.submi = submi;
    }

    public KmsSapOrderHeaderVo() {
        super();
    }

    @Builder
    public KmsSapOrderHeaderVo(KmsOrderFormRespVo header) {
        //客户编号 MDM-客户中心-客户信息
        AssertUtils.isNotEmpty(header.getSoldToPartyCode(), "客户编号-售达方为空");
        header.setSoldToPartyCode(KmsUtils.addZero(header.getSoldToPartyCode(), 10));
        this.kunnr = header.getSoldToPartyCode();
        //送达方 MDM-客户中心-终端信息
        AssertUtils.isNotEmpty(header.getStoreCode(), "送达方-企业门店为空");
        header.setStoreCode(KmsUtils.addZero(header.getStoreCode(), 10));
        this.kunwe = header.getStoreCode();
        //销售组织 MDM-组织中心-客户组织
        AssertUtils.isNotEmpty(header.getCustomerOrgCode(), "销售组织-客户组织为空");
        AssertUtils.isNotEmpty(header.getCustomerOrgType(), "销售组织-客户组织类型为空");
        this.vkorg = header.getCustomerOrgCode();
        //分销渠道 MDM-客户中心-客户信息-渠道，数据字典中维护“CRM产品通用渠道类型”
        AssertUtils.isNotEmpty(header.getChannel(), "分销渠道-客户渠道为空");
        this.vtweg = header.getChannel();
        //产品组 01
        this.spart = "01";
        //销售凭证类型
        this.auart = "ZOR";
        //客户采购订单编号 商超订单号“/”送达方编号
        this.bstkd = SAP_KA_ORDER_PREFIX + header.getKaOrderNumber() + "-" + header.getStoreCode();
        //计算交货日期（当前日期加）加急订单，的交货日期要用推送日期
        //非加急订单走配置
        Calendar cl = Calendar.getInstance();
        Map<String, String> dateMap = DictUtil.dictMap(KmsConstant.KMS_ORDER_SHIPPING_DATE);
        //获取当前用户所属公司
        String day = dateMap.get(header.getCustomerOrgCode());
        if (!StringUtils.isEmpty(day)) {
            if (ObjectUtils.isEmpty(header.getTimeOfDay())) {
                throw new BusinessException("请配置直营体系订单推送时间阈值");
            }
            int dayInt = header.getTimeOfDay();
            cl.add(Calendar.DAY_OF_MONTH, dayInt);
            String deliveryDate = DateUtil.format(cl.getTime(), DateUtil.DEFAULT_MONTH_DAY_PATTERN);
            header.setDeliveryDate(deliveryDate);
            this.lfdat = deliveryDate;
            this.audat = deliveryDate;
        } else {
            header.setDeliveryDate("");
            this.lfdat = "";
            this.audat = "";
        }
        this.augru = "";
        this.zz001 = "";
        this.kostl = "";
        this.cmpgnExtid = "";
        this.kunwe2 = "";
        //单据-订单-是否加急为“是
        this.ihrez = header.getIsExpedited();
        this.submi = "";
    }
}