package com.biz.crm.webservice.order.req;

import com.biz.crm.nebular.kms.orderform.resp.KmsOrderFormRespVo;
import com.biz.crm.nebular.kms.orderform.resp.KmsOrderGoodsRespVo;
import com.biz.crm.util.AssertUtils;
import lombok.Builder;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

/**
 * @Project crm
 * @PackageName com.biz.crm.webservice.data
 * @ClassName KmsSapOrderItmeDataVo
 * @Author Gavin
 * @Date 2021/5/28 下午2:40
 * @Description 行数据
 */
@XmlRootElement
public class KmsSapOrderItmeDataVo {

    /**
     * 物料号(KMS-单据展示-订单-企业产品编号)
     */
    @XmlElement(name = "MATNR")
    private String matnr = "";

    /**
     * 以销售单位表示的累计订单数量(KMS-单据展示-订单-商超数量)
     */
    @XmlElement(name = "KWMENG")
    private String kwmeng = "";

    /**
     * 销售单位 MDM-产品中心-销售单位，数据字典中维护的“字典编码”
     */
    @XmlElement(name = "VRKME")
    private String vrkme = "";

    /**
     * 工厂(自有或外部) MDM-组织中心-客户组织-客户组织类型
     */
    @XmlElement(name = "WERKS")
    private String werks = "";

    /**
     * 库存地点
     */
    @XmlElement(name = "LGORT")
    private String lgort = "";

    /**
     * 优先采购订单的项目号
     */
    @XmlElement(name = "POSEX")
    private String posex = "";

    /**
     * 订购原因( 业务原因 )
     */
    @XmlElement(name = "AUGRU")
    private String augru = "";

    /**
     * 价格( 条件金额或百分数 )
     */
    @XmlElement(name = "KBETR")
    private String kbetr = "";

    /**
     * 日期
     */
    @XmlElement(name = "REQ_DATE")
    private String reqDate = "";

    /**
     * 销售凭证项目类别
     */
    @XmlElement(name = "PSTYV")
    private String pstyv = "";

    /**
     * 定价参考物料
     */
    @XmlElement(name = "PR_REF_MAT")
    private String prRefMat = "";

    /**
     * WBS元素
     */
    @XmlElement(name = "WBS_ELEM")
    private String wbsElem = "";

    /**
     * 价格( 条件金额或百分数 )
     */
    @XmlElement(name = "YK01")
    private String yk01 = "";

    /**
     * 价格( 条件金额或百分数 )
     */
    @XmlElement(name = "YK21")
    private String yk21 = "";

    /**
     * 条件定价单位
     */
    @XmlElement(name = "KPEIN")
    private String kpein = "";

    @XmlTransient
    public String getMatnr() {
        return matnr;
    }

    public void setMatnr(String matnr) {
        this.matnr = matnr;
    }

    @XmlTransient
    public String getKwmeng() {
        return kwmeng;
    }

    public void setKwmeng(String kwmeng) {
        this.kwmeng = kwmeng;
    }

    @XmlTransient
    public String getVrkme() {
        return vrkme;
    }

    public void setVrkme(String vrkme) {
        this.vrkme = vrkme;
    }

    @XmlTransient
    public String getWerks() {
        return werks;
    }

    public void setWerks(String werks) {
        this.werks = werks;
    }

    @XmlTransient
    public String getLgort() {
        return lgort;
    }

    public void setLgort(String lgort) {
        this.lgort = lgort;
    }

    @XmlTransient
    public String getPosex() {
        return posex;
    }

    public void setPosex(String posex) {
        this.posex = posex;
    }

    @XmlTransient
    public String getAugru() {
        return augru;
    }

    public void setAugru(String augru) {
        this.augru = augru;
    }

    @XmlTransient
    public String getKbetr() {
        return kbetr;
    }

    public void setKbetr(String kbetr) {
        this.kbetr = kbetr;
    }

    @XmlTransient
    public String getReqDate() {
        return reqDate;
    }

    public void setReqDate(String reqDate) {
        this.reqDate = reqDate;
    }

    @XmlTransient
    public String getPstyv() {
        return pstyv;
    }

    public void setPstyv(String pstyv) {
        this.pstyv = pstyv;
    }

    @XmlTransient
    public String getPrRefMat() {
        return prRefMat;
    }

    public void setPrRefMat(String prRefMat) {
        this.prRefMat = prRefMat;
    }

    @XmlTransient
    public String getWbsElem() {
        return wbsElem;
    }

    public void setWbsElem(String wbsElem) {
        this.wbsElem = wbsElem;
    }

    @XmlTransient
    public String getYk01() {
        return yk01;
    }

    public void setYk01(String yk01) {
        this.yk01 = yk01;
    }

    @XmlTransient
    public String getYk21() {
        return yk21;
    }

    public void setYk21(String yk21) {
        this.yk21 = yk21;
    }

    @XmlTransient
    public String getKpein() {
        return kpein;
    }

    public void setKpein(String kpein) {
        this.kpein = kpein;
    }

    public KmsSapOrderItmeDataVo() {
        super();
    }

    @Builder
    public KmsSapOrderItmeDataVo(KmsOrderFormRespVo header, KmsOrderGoodsRespVo item) {
        //物料号 KMS-单据展示-订单-企业产品编号
        AssertUtils.isNotEmpty(item.getGoodsCode(), "物料号-企业物料号为空");
        this.matnr = item.getGoodsCode();

        //以销售单位表示的累计订单数量 KMS-单据展示-订单-商超数量
        AssertUtils.isNotEmpty(item.getCurCompanyUnitOrderQuantity(), "订单数量为空");
        this.kwmeng = item.getCurCompanyUnitOrderQuantity();

        //销售单位 MDM-产品中心-销售单位，数据字典中维护的“字典编码”
        AssertUtils.isNotEmpty(item.getCurCompanyUnit(), "销售单位为空");
        this.vrkme = item.getCurCompanyUnit();

        //工厂(自有或外部) MDM-组织中心-客户组织-客户组织类型
        AssertUtils.isNotEmpty(header.getCustomerOrgType(), "工厂(自有或外部)-客户组织类型为空");
        this.werks = header.getCustomerOrgType();

        this.lgort = "";
        //优先采购订单的项目号
        this.posex = item.getItemIndex().toString();

        this.augru = "";
        this.kbetr = "";
        this.reqDate = header.getDeliveryDate();
        this.pstyv = "";
        this.prRefMat = "";
        this.wbsElem = "";
        this.yk01 = "";
        this.yk21 = "";
        this.kpein = "";
    }
}