package com.biz.crm.webservice.service.impl;

import com.biz.crm.eunm.kms.KmsEnum;
import com.biz.crm.nebular.kms.orderform.req.KmsOrderFormReqVo;
import com.biz.crm.nebular.kms.orderform.req.KmsOrderGoodsReqVo;
import com.biz.crm.nebular.kms.orderform.req.WebServiceFindOrderReqVo;
import com.biz.crm.nebular.kms.orderform.resp.KmsOrderFormRespVo;
import com.biz.crm.nebular.kms.orderform.resp.WebServiceFindOrderItemRespVo;
import com.biz.crm.nebular.kms.orderform.resp.WebServiceFindOrderRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.orderform.mapper.KmsOrderFormMapper;
import com.biz.crm.orderform.mapper.KmsOrderGoodsMapper;
import com.biz.crm.supermarket.mapper.KmsTenantryDirectCustomerOrgMapper;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.UserUtils;
import com.biz.crm.webservice.service.IKmsOrderWebService;
import lombok.extern.slf4j.Slf4j;
import org.apache.cxf.interceptor.Fault;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import javax.jws.WebService;
import javax.xml.soap.SOAPException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Project crm-core
 * @PackageName com.biz.crm.webservice.service.impl
 * @ClassName KmsOrderWebServiceImpl
 * @Author Gavin
 * @Date 2021/10/22 上午11:19
 * @Description 订货单webservice接口实现
 */
@Slf4j
@WebService(name = "查询商超订货单", serviceName = "KmsOrderWebService", targetNamespace = "http://www.biz-united.com.cn/", endpointInterface = "com.biz.crm.webservice.service.IKmsOrderWebService")
@Component
public class KmsOrderWebServiceImpl implements IKmsOrderWebService {

    @Resource
    private KmsTenantryDirectCustomerOrgMapper kmsTenantryDirectCustomerOrgMapper;

    @Resource
    private KmsOrderFormMapper kmsOrderFormMapper;

    @Resource
    private KmsOrderGoodsMapper kmsOrderGoodsMapper;

    @Override
    public List<WebServiceFindOrderRespVo> findKmsOrderFormList(WebServiceFindOrderReqVo webServiceFindOrderReqVo) {
        UserUtils.doTokenForNull();
        log.info("外部系统查询商超订货单====");
        KmsOrderFormReqVo reqVo = paramCheck(webServiceFindOrderReqVo);

        List<WebServiceFindOrderRespVo> list = kmsOrderFormMapper.webServiceFindList(reqVo);
        if (!org.springframework.util.CollectionUtils.isEmpty(list)) {
            //区域名称
            List<String> ids = list.stream().map(WebServiceFindOrderRespVo::getStoreRelatedId).distinct().collect(Collectors.toList());
            List<KmsOrderFormRespVo> nameList = kmsOrderFormMapper.findAreaName(ids);
            Map<String, List<KmsOrderFormRespVo>> areaNameMap = nameList.stream()
                    .collect(Collectors.groupingBy(KmsOrderFormRespVo::getId));
            //外部系统查询商超货订货单明细
            KmsOrderGoodsReqVo goodsReqVo = new KmsOrderGoodsReqVo();
            goodsReqVo.setOrderNumberList(list.stream().map(WebServiceFindOrderRespVo::getOrderNumber).collect(Collectors.toList()));
            List<WebServiceFindOrderItemRespVo> itemRespVos = kmsOrderGoodsMapper.webServiceFindList(goodsReqVo);
            Map<String, List<WebServiceFindOrderItemRespVo>> itemMap = itemRespVos.stream()
                    .collect(Collectors.groupingBy(WebServiceFindOrderItemRespVo::getOrderNumber));
            list.forEach(o -> {
                List<KmsOrderFormRespVo> vos = areaNameMap.get(o.getStoreRelatedId());
                if (CollectionUtil.listNotEmptyNotSizeZero(vos)) {
                    o.setAreaName(vos.get(0).getAreaName());
                }
                o.setGoodsVos(itemMap.get(o.getOrderNumber()));
            });
        }
        return list;
    }

    /**
     * 参数检查
     *
     * @param reqVo
     */
    private KmsOrderFormReqVo paramCheck(WebServiceFindOrderReqVo reqVo) {
        if (StringUtils.isEmpty(reqVo.getOwnedCompany())) {
            throw new Fault(new SOAPException("公司代码不能为空"));
        }
        if (StringUtils.isEmpty(reqVo.getOrderDateStart()) || StringUtils.isEmpty(reqVo.getOrderDateEnd())) {
            throw new Fault(new SOAPException("开始结束日期不能为空"));
        }
        KmsOrderFormReqVo formReqVo = CrmBeanUtil.copy(reqVo, KmsOrderFormReqVo.class);
        formReqVo.setOrderStatus(KmsEnum.OrderStatus.S400.getValue());
        //查询公司代码下所有直营体系
        try {
            List<MdmOrgRespVo> childrenOrgListIncludeSelf = OrgUtil.getChildrenOrgListIncludeSelf(reqVo.getOwnedCompany());
            if (CollectionUtils.isEmpty(childrenOrgListIncludeSelf)) {
                throw new Fault(new SOAPException("公司代码错误，企业组织查询不到相关信息"));
            }
            List<String> orgCodes = childrenOrgListIncludeSelf.stream()
                    .map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
            formReqVo.setOrgCodes(orgCodes);
        } catch (Exception e) {
            throw new Fault(new SOAPException("查询公司代码信息异常：" + e.getMessage()));
        }
        return formReqVo;
    }
}