/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.acceptanceform.controller;

import com.biz.crm.acceptanceform.service.IKmsAcceptanceFormService;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.kms.acceptanceform.req.KmsAcceptanceFormReqVo;
import com.biz.crm.nebular.kms.acceptanceform.resp.KmsAcceptanceFormExportRespVo;
import com.biz.crm.nebular.kms.acceptanceform.resp.KmsAcceptanceFormRespVo;
import com.biz.crm.util.RedissonUtil;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.redisson.api.RLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/kmsacceptanceform"})
@Api(tags={"\u5546\u8d85\u5355\u636e-\u9a8c\u6536\u5355"})
public class KmsAcceptanceFormController {
    private static final Logger log = LoggerFactory.getLogger(KmsAcceptanceFormController.class);
    @Autowired
    private IKmsAcceptanceFormService kmsAcceptanceFormService;
    @Resource
    private RedissonUtil redissonUtil;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    public Result<PageResult<KmsAcceptanceFormRespVo>> list(@RequestBody KmsAcceptanceFormReqVo kmsAcceptanceFormReqVo) {
        PageResult<KmsAcceptanceFormRespVo> result = this.kmsAcceptanceFormService.findList(kmsAcceptanceFormReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @PostMapping(value={"/query"})
    @CrmLog
    public Result<KmsAcceptanceFormRespVo> query(@RequestBody KmsAcceptanceFormReqVo kmsAcceptanceFormReqVo) {
        KmsAcceptanceFormRespVo respVo = this.kmsAcceptanceFormService.query(kmsAcceptanceFormReqVo);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody KmsAcceptanceFormReqVo kmsAcceptanceFormReqVo) {
        this.kmsAcceptanceFormService.save(kmsAcceptanceFormReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody KmsAcceptanceFormReqVo kmsAcceptanceFormReqVo) {
        this.kmsAcceptanceFormService.update(kmsAcceptanceFormReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        KmsAcceptanceFormReqVo reqVo = new KmsAcceptanceFormReqVo().setIds(ids);
        this.kmsAcceptanceFormService.deleteBatch(reqVo);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody KmsAcceptanceFormReqVo kmsAcceptanceFormReqVo) {
        this.kmsAcceptanceFormService.enableBatch(kmsAcceptanceFormReqVo);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody KmsAcceptanceFormReqVo kmsAcceptanceFormReqVo) {
        this.kmsAcceptanceFormService.disableBatch(kmsAcceptanceFormReqVo);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u624b\u52a8\u8f6c\u6362\u9a8c\u6536\u5355")
    @PostMapping(value={"/manualTrans"})
    @CrmLog
    public Result manualTrans(@RequestBody List<String> ids) {
        block7: {
            RLock rLock = null;
            try {
                rLock = this.redissonUtil.createLock("MANUAL_TRANS_FORM");
                if (this.redissonUtil.tryLock(rLock, 0L, 3600L)) {
                    KmsAcceptanceFormReqVo kmsAcceptanceFormReqVo = new KmsAcceptanceFormReqVo();
                    kmsAcceptanceFormReqVo.setIds(ids);
                    this.kmsAcceptanceFormService.manualTrans(kmsAcceptanceFormReqVo);
                    break block7;
                }
                throw new BusinessException("\u6709\u4eba\u6b63\u5728\u8fdb\u884c\u5355\u636e\u8f6c\u6362\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            }
            catch (BusinessException e) {
                throw e;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.redissonUtil.unLock(rLock);
            }
        }
        return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/listForExport"})
    @CrmLog
    public Result<PageResult<KmsAcceptanceFormExportRespVo>> listForExport(@RequestBody KmsAcceptanceFormReqVo kmsAcceptanceFormReqVo) {
        PageResult<KmsAcceptanceFormExportRespVo> result = this.kmsAcceptanceFormService.listForExport(kmsAcceptanceFormReqVo);
        return Result.ok(result);
    }
}

