/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.acceptanceform.helper;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.acceptanceform.mapper.KmsAcceptanceFormMapper;
import com.biz.crm.acceptanceform.mapper.KmsAcceptanceGoodsMapper;
import com.biz.crm.acceptanceform.model.KmsAcceptanceFormEntity;
import com.biz.crm.acceptanceform.model.KmsAcceptanceGoodsEntity;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.kms.KmsAdminEnum;
import com.biz.crm.eunm.kms.KmsEnum;
import com.biz.crm.grabrule.mapper.KmsDataAuthMapper;
import com.biz.crm.nebular.kms.rawdata.resp.KmsAcceptanceFormDetailDwRespVo;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.rawdata.model.KmsAcceptanceFormDetailDwEntity;
import com.biz.crm.rawdata.model.KmsAcceptanceGoodsDetailDwEntity;
import com.biz.crm.rawdata.service.IKmsAcceptanceFormDetailDwService;
import com.biz.crm.rawdata.service.IKmsAcceptanceGoodsDetailDwService;
import com.biz.crm.trans.service.IKmsTransDataService;
import com.biz.crm.trans.vo.TransDataGoodsVo;
import com.biz.crm.trans.vo.TransDataStoreVo;
import com.biz.crm.trans.vo.TransDataVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.KmsUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Component
public class KmsAcceptanceFormHelper {
    private static final Logger log = LoggerFactory.getLogger(KmsAcceptanceFormHelper.class);
    @Resource
    private KmsAcceptanceFormMapper kmsAcceptanceFormMapper;
    @Resource
    private KmsAcceptanceGoodsMapper kmsAcceptanceGoodsMapper;
    @Resource
    private IKmsAcceptanceFormDetailDwService kmsAcceptanceFormDetailDwService;
    @Resource
    private IKmsAcceptanceGoodsDetailDwService kmsAcceptanceGoodsDetailDwService;
    @Resource
    private IKmsTransDataService kmsTransDataService;
    @Resource
    private KmsDataAuthMapper kmsDataAuthMapper;

    public KmsAcceptanceFormEntity transFormVersion(KmsAcceptanceFormDetailDwRespVo dwRespVo) {
        String orderNumber = dwRespVo.getOrderNumber();
        KmsAcceptanceFormDetailDwEntity dwEntity = (KmsAcceptanceFormDetailDwEntity)((LambdaQueryChainWrapper)this.kmsAcceptanceFormDetailDwService.lambdaQuery().eq(KmsAcceptanceFormDetailDwEntity::getOrderNumber, (Object)orderNumber)).one();
        LambdaQueryWrapper build = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(KmsAcceptanceFormEntity::getOrderNumber, (Object)orderNumber);
        KmsAcceptanceFormEntity acceptanceFormEntity = (KmsAcceptanceFormEntity)this.kmsAcceptanceFormMapper.selectOne((Wrapper)build);
        if (ObjectUtils.isEmpty((Object)acceptanceFormEntity)) {
            acceptanceFormEntity = (KmsAcceptanceFormEntity)CrmBeanUtil.copy((Object)dwEntity, KmsAcceptanceFormEntity.class);
            acceptanceFormEntity.setCreateCode(dwRespVo.getCreateCode());
            acceptanceFormEntity.setCreateName(dwRespVo.getCreateName());
            acceptanceFormEntity.setCreateOrgCode(dwRespVo.getCreateOrgCode());
            acceptanceFormEntity.setCreateOrgName(dwRespVo.getCreateOrgName());
            acceptanceFormEntity.setCreatePosCode(dwRespVo.getCreatePosCode());
            acceptanceFormEntity.setCreatePosName(dwRespVo.getCreatePosName());
            acceptanceFormEntity.setBsDirectSystemId(dwRespVo.getBsDirectSystemId());
        }
        dwEntity.setTransStatus(YesNoEnum.yesNoEnum.ONE.getValue());
        this.kmsAcceptanceFormDetailDwService.updateById(dwEntity);
        return acceptanceFormEntity;
    }

    public List<KmsAcceptanceGoodsEntity> transGoodsVersion(KmsAcceptanceFormEntity acceptanceFormEntity) {
        String orderNumber = acceptanceFormEntity.getOrderNumber();
        LambdaUpdateWrapper wrapper = (LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(KmsAcceptanceGoodsEntity::getOrderNumber, (Object)orderNumber);
        List deleteAcceptanceGoodsEntities = this.kmsAcceptanceGoodsMapper.selectList((Wrapper)wrapper);
        Map goodsMap = deleteAcceptanceGoodsEntities.stream().collect(Collectors.toMap(o -> o.getOrderNumber() + "-" + o.getKaGoodsCode(), Function.identity()));
        List detailDwEntities = ((LambdaQueryChainWrapper)this.kmsAcceptanceGoodsDetailDwService.lambdaQuery().eq(KmsAcceptanceGoodsDetailDwEntity::getOrderNumber, (Object)orderNumber)).list();
        Map dwEntityMap = detailDwEntities.stream().collect(Collectors.toMap(o -> o.getOrderNumber() + "-" + o.getKaGoodsCode(), Function.identity(), (v1, v2) -> v1));
        HashMap onlyMap = Maps.newHashMap();
        detailDwEntities.forEach(o -> {
            KmsAcceptanceGoodsEntity goodsEntity;
            String key = o.getOrderNumber() + "-" + o.getKaGoodsCode();
            goodsEntity.setAcceptanceAmount(StringUtils.isEmpty((Object)(goodsEntity = (KmsAcceptanceGoodsEntity)CrmBeanUtil.copy((Object)o, KmsAcceptanceGoodsEntity.class)).getAcceptanceAmount()) ? "0" : goodsEntity.getAcceptanceAmount());
            goodsEntity.setAcceptanceAmountNot(StringUtils.isEmpty((Object)goodsEntity.getAcceptanceAmountNot()) ? "0" : goodsEntity.getAcceptanceAmountNot());
            goodsEntity.setCurUnitAcceptanceQuantity(StringUtils.isEmpty((Object)goodsEntity.getCurUnitAcceptanceQuantity()) ? "0" : goodsEntity.getCurUnitAcceptanceQuantity());
            goodsEntity.setOrderAmount(StringUtils.isEmpty((Object)goodsEntity.getOrderAmount()) ? "0" : goodsEntity.getOrderAmount());
            goodsEntity.setOrderAmountNot(StringUtils.isEmpty((Object)goodsEntity.getOrderAmountNot()) ? "0" : goodsEntity.getOrderAmountNot());
            goodsEntity.setOrderQuantity(StringUtils.isEmpty((Object)goodsEntity.getOrderQuantity()) ? "0" : goodsEntity.getOrderQuantity());
            goodsEntity.setRemarks(o.getRemarks());
            if (!ObjectUtils.isEmpty(onlyMap.get(key))) {
                KmsAcceptanceGoodsEntity en = (KmsAcceptanceGoodsEntity)onlyMap.get(key);
                en.setAcceptanceAmount(new BigDecimal(en.getAcceptanceAmount()).add(new BigDecimal(goodsEntity.getAcceptanceAmount())).toString());
                en.setAcceptanceAmountNot(new BigDecimal(en.getAcceptanceAmountNot()).add(new BigDecimal(goodsEntity.getAcceptanceAmountNot())).toString());
                en.setCurUnitAcceptanceQuantity(new BigDecimal(en.getCurUnitAcceptanceQuantity()).add(new BigDecimal(goodsEntity.getCurUnitAcceptanceQuantity())).toString());
                en.setOrderAmount(new BigDecimal(en.getOrderAmount()).add(new BigDecimal(goodsEntity.getOrderAmount())).toString());
                en.setOrderAmountNot(new BigDecimal(en.getOrderAmountNot()).add(new BigDecimal(goodsEntity.getOrderAmountNot())).toString());
                en.setOrderQuantity(new BigDecimal(en.getOrderQuantity()).add(new BigDecimal(goodsEntity.getOrderQuantity())).toString());
                onlyMap.put(key, en);
            } else {
                KmsAcceptanceGoodsEntity entity = ObjectUtils.isEmpty(goodsMap.get(key)) ? new KmsAcceptanceGoodsEntity() : (KmsAcceptanceGoodsEntity)goodsMap.get(key);
                BeanUtils.copyProperties((Object)goodsEntity, (Object)entity, (String[])KmsUtils.ignoreProperties());
                onlyMap.put(key, entity);
            }
        });
        ArrayList goodsIds = Lists.newArrayList();
        goodsMap.forEach((k, v) -> {
            if (ObjectUtils.isEmpty(dwEntityMap.get(k))) {
                goodsIds.add(v.getId());
            }
        });
        if (!CollectionUtils.isEmpty((Collection)goodsIds)) {
            this.kmsAcceptanceGoodsMapper.deleteBatchIds(goodsIds);
        }
        ArrayList onlyList = Lists.newArrayList();
        onlyMap.forEach((k, v) -> onlyList.add(v));
        return onlyList;
    }

    public void transData(KmsAcceptanceFormEntity acceptanceFormEntity, List<KmsAcceptanceGoodsEntity> goodsEntities) {
        TransDataVo transDataVo = new TransDataVo();
        transDataVo.setOrderType(KmsAdminEnum.OrderType.ACCEPTANCE.getValue());
        acceptanceFormEntity.setOrderStatusMsg("");
        TransDataStoreVo dataStoreVo = (TransDataStoreVo)((Object)CrmBeanUtil.copy((Object)acceptanceFormEntity, TransDataStoreVo.class));
        dataStoreVo.setSoldToPartyCode(null);
        dataStoreVo.setSoldToPartyName(null);
        dataStoreVo.setOrderStatusMsg("");
        dataStoreVo.setKaName(acceptanceFormEntity.getKaName());
        dataStoreVo.setKaOrderNumber(acceptanceFormEntity.getKaOrderNumber());
        transDataVo.setStoreVos(dataStoreVo);
        goodsEntities.forEach(o -> {
            TransDataGoodsVo dataGoodsVo = (TransDataGoodsVo)((Object)((Object)CrmBeanUtil.copy((Object)o, TransDataGoodsVo.class)));
            dataGoodsVo.setCurUnitOrderQuantity(o.getCurUnitAcceptanceQuantity());
            dataGoodsVo.setKaOrderNumber(o.getKaOrderNumber());
            dataGoodsVo.setOrderStatusMsg("");
            dataGoodsVo.setKaName(o.getKaName());
            dataGoodsVo.setOrderDate(acceptanceFormEntity.getAcceptanceDate());
            transDataVo.getGoodsVos().add(dataGoodsVo);
        });
        this.kmsTransDataService.transData(transDataVo);
        this.resultProcessing(acceptanceFormEntity, goodsEntities, transDataVo);
    }

    private void resultProcessing(KmsAcceptanceFormEntity acceptanceFormEntity, List<KmsAcceptanceGoodsEntity> goodsEntities, TransDataVo transDataVo) {
        String orderNumber = acceptanceFormEntity.getOrderNumber();
        TransDataStoreVo transDataStoreVo = transDataVo.getStoreVos();
        BeanUtils.copyProperties((Object)((Object)transDataStoreVo), (Object)acceptanceFormEntity, (String[])Arrays.stream(CrmBaseVo.class.getDeclaredFields()).map(Field::getName).collect(Collectors.toList()).toArray(new String[0]));
        if (!StringUtils.isEmpty((Object)acceptanceFormEntity.getAcceptanceDate())) {
            Date acceptanceDate = DateUtil.getDateByFormat((String)acceptanceFormEntity.getAcceptanceDate(), (String)"yyyy-MM-dd");
            if (!ObjectUtils.isEmpty((Object)transDataStoreVo.getTimeOfDay())) {
                Calendar cl = Calendar.getInstance();
                cl.setTime(acceptanceDate);
                cl.add(5, transDataStoreVo.getTimeOfDay() * -1);
                acceptanceFormEntity.setAuditDate(DateUtil.format((Date)cl.getTime(), (String)"yyyy-MM-dd"));
            } else {
                acceptanceFormEntity.setAuditDate(DateUtil.format((Date)acceptanceDate, (String)"yyyy-MM-dd"));
            }
        }
        String orderStatusMsg = acceptanceFormEntity.getOrderStatusMsg();
        if (!CollectionUtils.isEmpty(goodsEntities)) {
            Map dataGoodsVoMap = transDataVo.getGoodsVos().stream().collect(Collectors.toMap(TransDataGoodsVo::getKaGoodsCode, Function.identity()));
            goodsEntities.forEach(goods -> {
                String kaGoodsCode = goods.getKaGoodsCode();
                TransDataGoodsVo transDataGoodsVo = (TransDataGoodsVo)((Object)((Object)dataGoodsVoMap.get(kaGoodsCode)));
                BeanUtils.copyProperties((Object)((Object)transDataGoodsVo), (Object)goods, (String[])Arrays.stream(CrmBaseVo.class.getDeclaredFields()).map(Field::getName).collect(Collectors.toList()).toArray(new String[0]));
                if (!StringUtils.isEmpty((Object)goods.getOrderStatusMsg())) {
                    goods.setOrderStatus(KmsEnum.OrderStatus.S100.getValue());
                } else {
                    goods.setOrderStatus(KmsEnum.OrderStatus.S400.getValue());
                    goods.setOrderStatusMsg("\u8f6c\u6362\u6210\u529f");
                }
            });
            List errorList = goodsEntities.stream().filter(goods -> KmsEnum.OrderStatus.S100.getValue().equals(goods.getOrderStatus())).collect(Collectors.toList());
            if (!StringUtils.isEmpty((Object)orderStatusMsg) || !CollectionUtils.isEmpty(errorList)) {
                acceptanceFormEntity.setOrderStatus(KmsEnum.OrderStatus.S100.getValue());
                if (!CollectionUtils.isEmpty(errorList) && !StringUtils.isEmpty((Object)orderStatusMsg)) {
                    acceptanceFormEntity.setOrderStatusMsg(orderStatusMsg + "|\u5546\u54c1\u884c\u4fe1\u606f\u5b58\u5728\u8f6c\u6362\u5931\u8d25\u6570\u636e");
                } else if (!CollectionUtils.isEmpty(errorList) && StringUtils.isEmpty((Object)orderStatusMsg)) {
                    acceptanceFormEntity.setOrderStatusMsg("\u5546\u54c1\u884c\u4fe1\u606f\u5b58\u5728\u8f6c\u6362\u5931\u8d25\u6570\u636e");
                }
            } else if (!KmsEnum.OrderStatus.S600.getValue().equals(acceptanceFormEntity.getOrderStatus())) {
                acceptanceFormEntity.setOrderStatus(KmsEnum.OrderStatus.S400.getValue());
            }
        } else if (!StringUtils.isEmpty((Object)orderStatusMsg)) {
            acceptanceFormEntity.setOrderStatus(KmsEnum.OrderStatus.S100.getValue());
            acceptanceFormEntity.setOrderStatusMsg(orderStatusMsg);
        } else if (!KmsEnum.OrderStatus.S600.getValue().equals(acceptanceFormEntity.getOrderStatus())) {
            acceptanceFormEntity.setOrderStatus(KmsEnum.OrderStatus.S400.getValue());
        }
        if (StringUtils.isEmpty((Object)acceptanceFormEntity.getOrderStatusMsg())) {
            acceptanceFormEntity.setOrderStatusMsg("\u8f6c\u6362\u6210\u529f");
        }
    }
}

