/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.confadmin.helper;

import com.biz.crm.base.BusinessException;
import com.biz.crm.confadmin.model.KmsInterfaceParamOptionEntity;
import com.biz.crm.confadmin.model.KmsInterfaceSubParamOptionEntity;
import com.biz.crm.eunm.kms.KmsAdminEnum;
import com.biz.crm.nebular.kms.confadmin.base.BaseClassifyConstants;
import com.biz.crm.nebular.kms.confadmin.base.BaseDateFlagConstants;
import com.biz.crm.nebular.kms.confadmin.base.ComomStatus;
import com.biz.crm.nebular.kms.confadmin.req.KmsInterfaceParamReqVo;
import com.biz.crm.nebular.kms.confadmin.req.KmsInterfaceSubParamOptionReqVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class KmsInterfaceParamHelper {
    private static final Logger log = LoggerFactory.getLogger(KmsInterfaceParamHelper.class);

    public void paramCheck(KmsInterfaceParamReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getDirectId(), (String)"\u5546\u8d85ID[directId]\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getFieldEn(), (String)"\u53c2\u6570\u5c5e\u6027\u540d[fieldEn]\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getFieldCn(), (String)"\u53c2\u6570\u6587\u672c\u540d[fieldCn]\u4e0d\u80fd\u4e3a\u7a7a");
        String isRequired = reqVo.getIsRequired();
        AssertUtils.isNotEmpty((String)isRequired, (String)"\u5b57\u6bb5\u662f\u5426\u5fc5\u586b\u6807\u793a[isRequired]\u4e0d\u80fd\u4e3a\u7a7a");
        ComomStatus ifPresentEnum = ComomStatus.getIfPresent((String)isRequired);
        AssertUtils.isNotNull((Object)ifPresentEnum, (String)"\u5b57\u6bb5\u662f\u5426\u5fc5\u586b\u6807\u793a\u6570\u636e\u9519\u8bef");
        String orderType = reqVo.getOrderType();
        AssertUtils.isNotEmpty((String)orderType, (String)"\u5355\u636e\u7c7b\u578b\u7f16\u7801[orderType]\u4e0d\u80fd\u4e3a\u7a7a");
        KmsAdminEnum.OrderType orderTypeEnum = KmsAdminEnum.OrderType.getIfPresent((String)orderType);
        AssertUtils.isNotNull((Object)orderTypeEnum, (String)"\u5355\u636e\u7c7b\u578b\u7f16\u7801\u6570\u636e\u9519\u8bef");
        String fieldClassify = reqVo.getFieldClassify();
        AssertUtils.isNotEmpty((String)fieldClassify, (String)"\u63a7\u4ef6\u7c7b\u578b[fieldClassify]\u4e0d\u80fd\u4e3a\u7a7a");
        BaseClassifyConstants.FieldClassify fieldClassifyEnum = BaseClassifyConstants.FieldClassify.getIfPresent((String)fieldClassify);
        AssertUtils.isNotNull((Object)fieldClassifyEnum, (String)"\u63a7\u4ef6\u7c7b\u578b[fieldClassify]\u6570\u636e\u9519\u8bef");
        String paramClassify = reqVo.getParamClassify();
        AssertUtils.isNotEmpty((String)paramClassify, (String)"\u53c2\u6570\u7c7b\u578b[paramClassify]\u4e0d\u80fd\u4e3a\u7a7a");
        BaseClassifyConstants.ParamClassify paramClassifyEnum = BaseClassifyConstants.ParamClassify.getIfPresent((String)paramClassify);
        AssertUtils.isNotNull((Object)paramClassifyEnum, (String)"\u53c2\u6570\u7c7b\u578b\u6570\u636e\u9519\u8bef");
        if (BaseClassifyConstants.FieldClassify.SELECT.equals((Object)fieldClassifyEnum) || BaseClassifyConstants.FieldClassify.CHECKBOX.equals((Object)fieldClassifyEnum) || BaseClassifyConstants.FieldClassify.DATE.equals((Object)fieldClassifyEnum) || BaseClassifyConstants.FieldClassify.DATERANGE.equals((Object)fieldClassifyEnum)) {
            List options = reqVo.getOptions();
            AssertUtils.isNotEmpty((Collection)options, (String)"\u4e0b\u62c9\u5355\u9009/\u591a\u9009\uff0c\u9009\u9879\u96c6\u5408[options]\u4e0d\u80fd\u4e3a\u7a7a");
            options.forEach(o -> {
                AssertUtils.isNotEmpty((String)o.getOptionName(), (String)"\u9009\u9879\u540d\u79f0[optionName]\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isNotEmpty((String)o.getOptionValue(), (String)"\u9009\u9879\u503c[optionValue]\u4e0d\u80fd\u4e3a\u7a7a");
            });
        }
        if (!BaseClassifyConstants.FieldClassify.DATE.equals((Object)fieldClassifyEnum) && !BaseClassifyConstants.FieldClassify.DATERANGE.equals((Object)fieldClassifyEnum)) {
            reqVo.setSubOptions(null);
        }
        List subOptions = reqVo.getSubOptions();
        if (BaseClassifyConstants.FieldClassify.DATE.equals((Object)fieldClassifyEnum)) {
            AssertUtils.isNotEmpty((Collection)subOptions, (String)"\u65f6\u95f4\u5355\u9009\u5b50\u53c2\u6570[subOptions]\u4e0d\u80fd\u4e3a\u7a7a");
            if (subOptions.size() != 1) {
                throw new BusinessException("\u65f6\u95f4\u5355\u9009\u5b50\u53c2\u6570\u53ea\u80fd\u4e3a\u4e00\u6761");
            }
            KmsInterfaceSubParamOptionReqVo o2 = (KmsInterfaceSubParamOptionReqVo)subOptions.get(0);
            AssertUtils.isNotEmpty((String)o2.getOptionName(), (String)"\u5b50\u53c2\u6570\u4e2d\u6587\u540d[optionName]\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)o2.getOptionValue(), (String)"\u5b50\u53c2\u6570\u82f1\u6587\u5c5e\u6027\u540d[optionValue]\u4e0d\u80fd\u4e3a\u7a7a");
            String dateFlagClassify = o2.getDateFlagClassify();
            AssertUtils.isNotEmpty((String)dateFlagClassify, (String)"\u5b50\u53c2\u6570\u65f6\u95f4\u6807\u793a[dateFlagClassify]\u4e0d\u80fd\u4e3a\u7a7a");
            BaseDateFlagConstants.DateFlagClassify dateFlagClassifyEnum = BaseDateFlagConstants.DateFlagClassify.getIfPresent((String)dateFlagClassify);
            AssertUtils.isNotNull((Object)dateFlagClassifyEnum, (String)("\u65f6\u95f4\u5355\u9009\u5b50\u53c2\u6570\u65f6\u95f4\u6807\u793a[dateFlagClassify]\u6570\u636e\u9519\u8bef\u53ea\u80fd\u4e3a" + BaseDateFlagConstants.DateFlagClassify.START.getValue() + "]"));
        }
        if (BaseClassifyConstants.FieldClassify.DATERANGE.equals((Object)fieldClassifyEnum)) {
            AssertUtils.isNotEmpty((Collection)subOptions, (String)"\u65f6\u95f4\u5355\u9009\u5b50\u53c2\u6570[subOptions]\u4e0d\u80fd\u4e3a\u7a7a");
            if (subOptions.size() != 2) {
                throw new BusinessException("\u65f6\u95f4\u8303\u56f4\u5b50\u53c2\u6570\u5fc5\u987b\u4e3a\u4e24\u6761");
            }
            subOptions.forEach(o -> {
                AssertUtils.isNotEmpty((String)o.getOptionName(), (String)"\u5b50\u53c2\u6570\u4e2d\u6587\u540d[optionName]\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isNotEmpty((String)o.getOptionValue(), (String)"\u5b50\u53c2\u6570\u82f1\u6587\u5c5e\u6027\u540d[optionValue]\u4e0d\u80fd\u4e3a\u7a7a");
                String dateFlagClassify = o.getDateFlagClassify();
                AssertUtils.isNotEmpty((String)dateFlagClassify, (String)"\u5b50\u53c2\u6570\u65f6\u95f4\u6807\u793a[dateFlagClassify]\u4e0d\u80fd\u4e3a\u7a7a");
                BaseDateFlagConstants.DateFlagClassify dateFlagClassifyEnum = BaseDateFlagConstants.DateFlagClassify.getIfPresent((String)dateFlagClassify);
                AssertUtils.isNotNull((Object)dateFlagClassifyEnum, (String)("\u65f6\u95f4\u8303\u56f4\u5b50\u53c2\u6570\u65f6\u95f4\u6807\u793a[dateFlagClassify]\u6570\u636e\u9519\u8bef\u53ea\u80fd\u4e3a[" + BaseDateFlagConstants.DateFlagClassify.START.getValue() + "]\u6216[" + BaseDateFlagConstants.DateFlagClassify.END.getValue() + "]"));
            });
            KmsInterfaceSubParamOptionReqVo startSub = (KmsInterfaceSubParamOptionReqVo)subOptions.get(0);
            KmsInterfaceSubParamOptionReqVo endSub = (KmsInterfaceSubParamOptionReqVo)subOptions.get(1);
            if (startSub.getDateFlagClassify().equals(endSub.getDateFlagClassify())) {
                throw new BusinessException("\u65f6\u95f4\u8303\u56f4\u5b50\u53c2\u6570\u65f6\u95f4\u6807\u793a[dateFlagClassify]\u4e0d\u80fd\u76f8\u540c");
            }
        }
    }

    public List<KmsInterfaceParamOptionEntity> buildOptionEntity(KmsInterfaceParamReqVo reqVo) {
        return reqVo.getOptions().stream().map(o -> {
            o.setFieldId(reqVo.getId());
            return (KmsInterfaceParamOptionEntity)CrmBeanUtil.copy((Object)o, KmsInterfaceParamOptionEntity.class);
        }).collect(Collectors.toList());
    }

    public List<KmsInterfaceSubParamOptionEntity> buildSubOptionEntity(KmsInterfaceParamReqVo reqVo) {
        return reqVo.getSubOptions().stream().map(o -> {
            o.setFieldId(reqVo.getId());
            return (KmsInterfaceSubParamOptionEntity)CrmBeanUtil.copy((Object)o, KmsInterfaceSubParamOptionEntity.class);
        }).collect(Collectors.toList());
    }
}

