/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.confadmin.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.confadmin.mapper.KmsDirectStoreAreaMapper;
import com.biz.crm.confadmin.mapper.KmsDirectStoreMapper;
import com.biz.crm.confadmin.mapper.KmsDirectSystemMapper;
import com.biz.crm.confadmin.model.KmsDirectStoreAreaEntity;
import com.biz.crm.confadmin.model.KmsDirectStoreEntity;
import com.biz.crm.confadmin.service.IKmsDirectStoreAreaService;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.nebular.kms.confadmin.req.KmsDirectStoreAreaReqVo;
import com.biz.crm.nebular.kms.confadmin.resp.KmsDirectStoreAreaRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.PageUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"KmsDirectStoreAreaServiceExpandImpl"})
public class KmsDirectStoreAreaServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<KmsDirectStoreAreaMapper, KmsDirectStoreAreaEntity>
implements IKmsDirectStoreAreaService {
    private static final Logger log = LoggerFactory.getLogger(KmsDirectStoreAreaServiceImpl.class);
    @Resource
    private KmsDirectStoreAreaMapper kmsDirectStoreAreaMapper;
    @Resource
    private KmsDirectStoreMapper kmsDirectStoreMapper;
    @Resource
    private KmsDirectSystemMapper directSystemMapper;
    @Resource
    private CrmLogSendUtil crmLogSendUtil;

    @Override
    public PageResult<KmsDirectStoreAreaRespVo> findList(KmsDirectStoreAreaReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<KmsDirectStoreAreaRespVo> list = this.kmsDirectStoreAreaMapper.findList((Page<KmsDirectStoreAreaRespVo>)page, reqVo);
        if (CollectionUtils.isNotEmpty(list)) {
            Map<String, Map<String, String>> dataMap = this.getDictMaps();
            list.forEach(x -> {
                if (StringUtils.isNotBlank((CharSequence)x.getEnableStatus())) {
                    x.setEnableStatusName((String)((Map)Optional.ofNullable(dataMap.get("enable_status")).orElse(Maps.newHashMap())).get(x.getEnableStatus()));
                }
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    public Map<String, Map<String, String>> getDictMaps() {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("enable_status");
        return DictUtil.getDictValueMapsByCodes((List)dictCodes);
    }

    @Override
    public KmsDirectStoreAreaRespVo query(String id) {
        AssertUtils.isNotEmpty((String)id, (CrmExceptionType)CommonException.IDS_NULL);
        KmsDirectStoreAreaReqVo reqVo = new KmsDirectStoreAreaReqVo();
        reqVo.setId(id);
        List respVos = this.findList(reqVo).getData();
        if (CollectionUtils.isEmpty((Collection)respVos)) {
            throw new BusinessException("\u67e5\u8be2\u6570\u636e\u4e0d\u5b58\u5728");
        }
        return (KmsDirectStoreAreaRespVo)respVos.get(0);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(KmsDirectStoreAreaReqVo reqVo) {
        this.checkAreaSaveOrUpdate(reqVo);
        KmsDirectStoreAreaEntity entity = (KmsDirectStoreAreaEntity)CrmBeanUtil.copy((Object)reqVo, KmsDirectStoreAreaEntity.class);
        this.save(entity);
        KmsDirectStoreAreaRespVo newData = (KmsDirectStoreAreaRespVo)CrmBeanUtil.copy((Object)entity, KmsDirectStoreAreaRespVo.class);
        Object menuCode = ThreadLocalUtil.getObj((String)"menuCode");
        this.crmLogSendUtil.sendForAdd(menuCode.toString(), newData.getId(), newData.getId(), (Object)newData);
    }

    private void checkAreaSaveOrUpdate(KmsDirectStoreAreaReqVo reqVo) {
        this.checkDataNotEmpty(reqVo);
        AssertUtils.isNotNull((Object)this.directSystemMapper.selectById((Serializable)((Object)reqVo.getDirectId())), (String)"\u5546\u8d85\u4f53\u7cfb\u4e0d\u5b58\u5728");
        this.checkDataExist(reqVo);
    }

    private void checkDataExist(KmsDirectStoreAreaReqVo reqVo) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        if (StringUtils.isNotBlank((CharSequence)reqVo.getId())) {
            wrapper.ne(BaseIdEntity::getId, (Object)reqVo.getId());
        }
        wrapper.eq(KmsDirectStoreAreaEntity::getDsAreaCode, (Object)reqVo.getDsAreaCode());
        wrapper.eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode());
        if (CollectionUtils.isNotEmpty((Collection)this.kmsDirectStoreAreaMapper.selectList((Wrapper)wrapper))) {
            throw new BusinessException("\u8be5\u533a\u57df\u5df2\u5b58\u5728");
        }
    }

    protected void checkDataNotEmpty(KmsDirectStoreAreaReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getDirectId(), (String)"\u5546\u8d85\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getDsAreaCode(), (String)"\u533a\u57df\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getDsAreaName(), (String)"\u533a\u57df\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(KmsDirectStoreAreaReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (CrmExceptionType)CommonException.IDS_NULL);
        AssertUtils.isNotNull((Object)this.kmsDirectStoreAreaMapper.selectById((Serializable)((Object)reqVo.getId())), (String)"\u64cd\u4f5c\u6570\u636e\u4e0d\u5b58\u5728");
        this.checkAreaSaveOrUpdate(reqVo);
        KmsDirectStoreAreaEntity entity = (KmsDirectStoreAreaEntity)CrmBeanUtil.copy((Object)reqVo, KmsDirectStoreAreaEntity.class);
        KmsDirectStoreAreaRespVo oldData = this.query(reqVo.getId());
        this.updateById(entity);
        KmsDirectStoreAreaRespVo newData = this.query(reqVo.getId());
        Object menuCode = ThreadLocalUtil.getObj((String)"menuCode");
        this.crmLogSendUtil.sendForUpdate(menuCode.toString(), newData.getId(), newData.getId(), (Object)oldData, (Object)newData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List kmsDirectStoreAreaEntities = this.kmsDirectStoreAreaMapper.selectBatchIds(ids);
        HashMap map = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)kmsDirectStoreAreaEntities)) {
            kmsDirectStoreAreaEntities.forEach(o -> {
                map.put(o.getId(), o.getDsAreaName());
                o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
            List storeEntities = this.kmsDirectStoreMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).in(KmsDirectStoreEntity::getAreaId, map.keySet()));
            if (CollectionUtils.isNotEmpty((Collection)storeEntities)) {
                HashSet names = Sets.newHashSet();
                storeEntities.forEach(x -> {
                    if (map.containsKey(x.getAreaId())) {
                        names.add(map.get(x.getAreaId()));
                    }
                });
                throw new BusinessException(((Object)names).toString() + "\u88ab\u5546\u8d85\u95e8\u5e97\u4f7f\u7528\uff0c\u4e0d\u53ef\u5220\u9664");
            }
        }
        this.updateBatchById(kmsDirectStoreAreaEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List kmsDirectStoreAreaEntities = this.kmsDirectStoreAreaMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)kmsDirectStoreAreaEntities)) {
            kmsDirectStoreAreaEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(kmsDirectStoreAreaEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List kmsDirectStoreAreaEntities = this.kmsDirectStoreAreaMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)kmsDirectStoreAreaEntities)) {
            kmsDirectStoreAreaEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(kmsDirectStoreAreaEntities);
    }
}

