/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.confadmin.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.confadmin.mapper.KmsDirectStoreAreaMapper;
import com.biz.crm.confadmin.mapper.KmsDirectStoreMapper;
import com.biz.crm.confadmin.model.KmsDirectStoreAreaEntity;
import com.biz.crm.confadmin.model.KmsDirectStoreEntity;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.nebular.kms.confadmin.req.KmsDirectStoreReqVo;
import com.biz.crm.nebular.kms.confadmin.resp.KmsDirectStoreRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.DictUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class KmsDirectStoreHelper {
    private static final Logger log = LoggerFactory.getLogger(KmsDirectStoreHelper.class);
    @Resource
    private KmsDirectStoreAreaMapper directStoreAreaMapper;
    @Resource
    private KmsDirectStoreMapper directStoreMapper;

    public Map<String, Map<String, String>> getDictMaps() {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("enable_status");
        return DictUtil.getDictValueMapsByCodes((List)dictCodes);
    }

    public void convertStoreData(List<KmsDirectStoreRespVo> list) {
        Map<String, Map<String, String>> dataMap = this.getDictMaps();
        if (CollectionUtils.isNotEmpty(list)) {
            HashSet areaIds = Sets.newHashSet();
            list.forEach(x -> {
                if (StringUtils.isNotBlank((CharSequence)x.getEnableStatus())) {
                    x.setEnableStatusName((String)((Map)Optional.ofNullable(dataMap.get("enable_status")).orElse(Maps.newHashMap())).get(x.getEnableStatus()));
                }
                if (StringUtils.isNotBlank((CharSequence)x.getAreaId())) {
                    areaIds.add(x.getAreaId());
                }
            });
            if (CollectionUtils.isEmpty((Collection)areaIds)) {
                return;
            }
            List storeAreaEntityList = this.directStoreAreaMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(BaseIdEntity::getId, (Collection)areaIds));
            if (CollectionUtils.isNotEmpty((Collection)storeAreaEntityList)) {
                Map storeAreaEntityMap = storeAreaEntityList.stream().collect(Collectors.toMap(BaseIdEntity::getId, Function.identity()));
                list.forEach(x -> {
                    if (storeAreaEntityMap.containsKey(x.getAreaId())) {
                        x.setAreaName(((KmsDirectStoreAreaEntity)storeAreaEntityMap.get(x.getAreaId())).getDsAreaName());
                    }
                });
            }
        }
    }

    public void saveStoreCheck(KmsDirectStoreReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getStoreCode(), (String)"\u95e8\u5e97\u7f16\u7801[storeCode]\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getStoreName(), (String)"\u95e8\u5e97\u540d\u79f0[storeName]\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getDirectId(), (String)"\u5546\u8d85\u4f53\u7cfb[directId]\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isNotBlank((CharSequence)reqVo.getAreaId())) {
            KmsDirectStoreAreaEntity directStoreAreaEntity = (KmsDirectStoreAreaEntity)this.directStoreAreaMapper.selectById((Serializable)((Object)reqVo.getAreaId()));
            AssertUtils.isNotNull((Object)directStoreAreaEntity, (String)"\u8be5\u95e8\u5e97\u533a\u57df\u4e0d\u5b58\u5728");
            if (!StringUtils.equals((CharSequence)directStoreAreaEntity.getDirectId(), (CharSequence)reqVo.getDirectId())) {
                throw new BusinessException("\u95e8\u5e97\u533a\u57df\u4e0d\u5728\u5f53\u524d\u7ef4\u62a4\u8303\u56f4\u5185");
            }
        }
        this.checkStoreExist(reqVo);
    }

    private void checkStoreExist(KmsDirectStoreReqVo reqVo) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        if (StringUtils.isNotBlank((CharSequence)reqVo.getId())) {
            wrapper.ne(BaseIdEntity::getId, (Object)reqVo.getId());
        }
        wrapper.eq(KmsDirectStoreEntity::getStoreCode, (Object)reqVo.getStoreCode());
        wrapper.eq(KmsDirectStoreEntity::getDirectId, (Object)reqVo.getDirectId());
        wrapper.eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode());
        if (StringUtils.isNotBlank((CharSequence)reqVo.getAreaId())) {
            wrapper.eq(KmsDirectStoreEntity::getAreaId, (Object)reqVo.getAreaId());
            if (CollectionUtils.isNotEmpty((Collection)this.directStoreMapper.selectList((Wrapper)wrapper))) {
                throw new BusinessException("\u8be5\u5546\u8d85\u4e0b\u95e8\u5e97\u5df2\u5b58\u5728");
            }
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)this.directStoreMapper.selectList((Wrapper)wrapper))) {
            throw new BusinessException("\u8be5\u5546\u8d85\u4e0b\u95e8\u5e97\u5df2\u5b58\u5728");
        }
    }

    public void checkUpdate(KmsDirectStoreReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (CrmExceptionType)CommonException.IDS_NULL);
        AssertUtils.isNotNull((Object)this.directStoreMapper.selectById((Serializable)((Object)reqVo.getId())), (String)"\u64cd\u4f5c\u6570\u636e\u4e0d\u5b58\u5728");
    }
}

