/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.confadmin.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.confadmin.mapper.KmsDirectStoreMapper;
import com.biz.crm.confadmin.model.KmsDirectStoreEntity;
import com.biz.crm.confadmin.service.IKmsDirectStoreService;
import com.biz.crm.confadmin.service.impl.KmsDirectStoreHelper;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.nebular.kms.confadmin.req.KmsDirectStoreReqVo;
import com.biz.crm.nebular.kms.confadmin.resp.KmsDirectStoreRespVo;
import com.biz.crm.supermarket.mapper.KmsTenantryDirectStoreMapper;
import com.biz.crm.supermarket.model.KmsTenantryDirectStoreEntity;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"KmsDirectStoreServiceExpandImpl"})
public class KmsDirectStoreServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<KmsDirectStoreMapper, KmsDirectStoreEntity>
implements IKmsDirectStoreService {
    private static final Logger log = LoggerFactory.getLogger(KmsDirectStoreServiceImpl.class);
    @Autowired
    KmsDirectStoreHelper helper;
    @Resource
    private KmsDirectStoreMapper kmsDirectStoreMapper;
    @Resource
    private KmsTenantryDirectStoreMapper kmsTenantryDirectStoreMapper;
    @Resource
    private CrmLogSendUtil crmLogSendUtil;

    @Override
    public PageResult<KmsDirectStoreRespVo> findList(KmsDirectStoreReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<KmsDirectStoreRespVo> list = this.kmsDirectStoreMapper.findList((Page<KmsDirectStoreRespVo>)page, reqVo);
        if (CollectionUtils.isNotEmpty(list)) {
            this.helper.convertStoreData(list);
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public KmsDirectStoreRespVo query(String id) {
        AssertUtils.isNotEmpty((String)id, (CrmExceptionType)CommonException.IDS_NULL);
        KmsDirectStoreReqVo reqVo = new KmsDirectStoreReqVo();
        reqVo.setId(id);
        List respVos = this.findList(reqVo).getData();
        if (CollectionUtils.isEmpty((Collection)respVos)) {
            throw new BusinessException("\u67e5\u8be2\u6570\u636e\u4e0d\u5b58\u5728");
        }
        return (KmsDirectStoreRespVo)respVos.get(0);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(KmsDirectStoreReqVo reqVo) {
        this.helper.saveStoreCheck(reqVo);
        KmsDirectStoreEntity entity = (KmsDirectStoreEntity)CrmBeanUtil.copy((Object)reqVo, KmsDirectStoreEntity.class);
        this.save(entity);
        KmsDirectStoreRespVo newData = (KmsDirectStoreRespVo)CrmBeanUtil.copy((Object)entity, KmsDirectStoreRespVo.class);
        Object menuCode = ThreadLocalUtil.getObj((String)"menuCode");
        this.crmLogSendUtil.sendForAdd(menuCode.toString(), newData.getId(), newData.getId(), (Object)newData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(KmsDirectStoreReqVo reqVo) {
        this.helper.checkUpdate(reqVo);
        this.helper.saveStoreCheck(reqVo);
        KmsDirectStoreEntity entity = (KmsDirectStoreEntity)CrmBeanUtil.copy((Object)reqVo, KmsDirectStoreEntity.class);
        KmsDirectStoreRespVo oldData = (KmsDirectStoreRespVo)CrmBeanUtil.copy((Object)entity, KmsDirectStoreRespVo.class);
        this.updateById(entity);
        Object menuCode = ThreadLocalUtil.getObj((String)"menuCode");
        KmsDirectStoreRespVo newData = this.query(reqVo.getId());
        this.crmLogSendUtil.sendForUpdate(menuCode.toString(), newData.getId(), newData.getId(), (Object)oldData, (Object)newData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List kmsDirectStoreEntities = this.kmsDirectStoreMapper.selectBatchIds(ids);
        HashMap map = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)kmsDirectStoreEntities)) {
            kmsDirectStoreEntities.forEach(o -> {
                map.put(o.getId(), o.getStoreName());
                o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
            List entities = this.kmsTenantryDirectStoreMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(KmsTenantryDirectStoreEntity::getStoreId, map.keySet())).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode()));
            if (CollectionUtils.isNotEmpty((Collection)entities)) {
                HashSet names = Sets.newHashSet();
                entities.forEach(x -> {
                    if (map.containsKey(x.getStoreId())) {
                        names.add(map.get(x.getStoreId()));
                    }
                });
                throw new BusinessException(((Object)names).toString() + "\u7684\u5546\u8d85\u95e8\u5e97\u5728\u76f4\u8425\u4f53\u7cfb\u4e0b\uff0c\u4e0d\u53ef\u5220\u9664");
            }
        }
        this.updateBatchById(kmsDirectStoreEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List kmsDirectStoreEntities = this.kmsDirectStoreMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)kmsDirectStoreEntities)) {
            kmsDirectStoreEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(kmsDirectStoreEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List kmsDirectStoreEntities = this.kmsDirectStoreMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)kmsDirectStoreEntities)) {
            kmsDirectStoreEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(kmsDirectStoreEntities);
    }
}

