/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.confadmin.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.confadmin.mapper.KmsDirectStoreMapper;
import com.biz.crm.confadmin.mapper.KmsDirectSystemMapper;
import com.biz.crm.confadmin.model.KmsDirectOrderTypeEntity;
import com.biz.crm.confadmin.model.KmsDirectStoreEntity;
import com.biz.crm.confadmin.model.KmsDirectSystemEntity;
import com.biz.crm.confadmin.service.IKmsDirectOrderTypeService;
import com.biz.crm.confadmin.service.IKmsDirectSystemService;
import com.biz.crm.confadmin.service.impl.KmsDirectSystemHelper;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.nebular.kms.confadmin.req.KmsDirectSystemReqVo;
import com.biz.crm.nebular.kms.confadmin.resp.KmsDirectOrderTypeRespVo;
import com.biz.crm.nebular.kms.confadmin.resp.KmsDirectSystemRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"KmsDirectSystemServiceExpandImpl"})
public class KmsDirectSystemServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<KmsDirectSystemMapper, KmsDirectSystemEntity>
implements IKmsDirectSystemService {
    private static final Logger log = LoggerFactory.getLogger(KmsDirectSystemServiceImpl.class);
    @Resource
    private KmsDirectSystemMapper kmsDirectSystemMapper;
    @Resource
    private IKmsDirectOrderTypeService directOrderTypeService;
    @Resource
    private KmsDirectSystemHelper helper;
    @Resource
    private IKmsDirectOrderTypeService kmsDirectOrderTypeService;
    @Resource
    private KmsDirectStoreMapper kmsDirectStoreMapper;
    @Resource
    private CrmLogSendUtil crmLogSendUtil;

    @Override
    public PageResult<KmsDirectSystemRespVo> findList(KmsDirectSystemReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<KmsDirectSystemRespVo> list = this.kmsDirectSystemMapper.findList((Page<KmsDirectSystemRespVo>)page, reqVo);
        if (CollectionUtils.isNotEmpty(list)) {
            this.helper.convertData(list);
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public KmsDirectSystemRespVo query(String id) {
        AssertUtils.isNotEmpty((String)id, (CrmExceptionType)CommonException.IDS_NULL);
        KmsDirectSystemEntity entity = (KmsDirectSystemEntity)this.kmsDirectSystemMapper.selectById((Serializable)((Object)id));
        AssertUtils.isNotNull((Object)entity, (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\u4fe1\u606f");
        KmsDirectSystemRespVo directSystemRespVo = (KmsDirectSystemRespVo)CrmBeanUtil.copy((Object)entity, KmsDirectSystemRespVo.class);
        List orderTypeEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.kmsDirectOrderTypeService.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).eq(KmsDirectOrderTypeEntity::getDirectId, (Object)id)).list();
        directSystemRespVo.setOrderTypeVos(CrmBeanUtil.copyList((List)orderTypeEntities, KmsDirectOrderTypeRespVo.class));
        return directSystemRespVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(KmsDirectSystemReqVo reqVo) {
        this.helper.paramCheck(reqVo);
        KmsDirectSystemEntity entity = (KmsDirectSystemEntity)CrmBeanUtil.copy((Object)reqVo, KmsDirectSystemEntity.class);
        this.save(entity);
        reqVo.setId(entity.getId());
        List<KmsDirectOrderTypeEntity> orderTypeEntities = this.helper.buildDirectOrderType(reqVo);
        this.directOrderTypeService.saveBatch(orderTypeEntities);
        KmsDirectSystemRespVo newData = (KmsDirectSystemRespVo)CrmBeanUtil.copy((Object)entity, KmsDirectSystemRespVo.class);
        newData.setOrderTypeVos(CrmBeanUtil.copyList(orderTypeEntities, KmsDirectOrderTypeRespVo.class));
        Object menuCode = ThreadLocalUtil.getObj((String)"menuCode");
        this.crmLogSendUtil.sendForAdd(menuCode.toString(), newData.getId(), newData.getId(), (Object)newData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(KmsDirectSystemReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (CrmExceptionType)CommonException.IDS_NULL);
        AssertUtils.isNotNull((Object)this.kmsDirectSystemMapper.selectById((Serializable)((Object)reqVo.getId())), (String)"\u64cd\u4f5c\u6570\u636e\u4e0d\u5b58\u5728");
        this.helper.paramCheck(reqVo);
        KmsDirectSystemEntity entity = (KmsDirectSystemEntity)CrmBeanUtil.copy((Object)reqVo, KmsDirectSystemEntity.class);
        KmsDirectSystemRespVo oldData = this.query(reqVo.getId());
        this.updateById(entity);
        List allEntities = ((LambdaQueryChainWrapper)this.directOrderTypeService.lambdaQuery().eq(KmsDirectOrderTypeEntity::getDirectId, (Object)entity.getId())).list();
        List<KmsDirectOrderTypeEntity> currEntities = this.helper.buildDirectOrderType(reqVo);
        ArrayList entities = Lists.newArrayList();
        allEntities.forEach(o -> {
            String orderType = o.getOrderType();
            KmsDirectOrderTypeEntity ot = currEntities.stream().filter(e -> e.getOrderType().equals(orderType)).findFirst().orElse(null);
            if (ObjectUtils.isEmpty((Object)ot)) {
                o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
                entities.add(o);
            }
        });
        currEntities.forEach(o -> {
            String orderType = o.getOrderType();
            KmsDirectOrderTypeEntity ot = allEntities.stream().filter(e -> e.getOrderType().equals(orderType)).findFirst().orElse(null);
            if (ObjectUtils.isEmpty((Object)ot)) {
                entities.add(o);
            } else if (StringUtils.isEmpty((Object)o.getId())) {
                o.setId(ot.getId());
                o.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
                entities.add(o);
            }
        });
        this.directOrderTypeService.saveOrUpdateBatch(entities);
        KmsDirectSystemRespVo newData = this.query(reqVo.getId());
        Object menuCode = ThreadLocalUtil.getObj((String)"menuCode");
        this.crmLogSendUtil.sendForUpdate(menuCode.toString(), newData.getId(), newData.getId(), (Object)oldData, (Object)newData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List kmsDirectSystemEntities = this.kmsDirectSystemMapper.selectBatchIds(ids);
        HashSet directIds = Sets.newHashSet();
        HashMap map = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)kmsDirectSystemEntities)) {
            kmsDirectSystemEntities.forEach(o -> {
                map.put(o.getId(), o.getDirectName());
                directIds.add(o.getId());
                o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
            List storeEntities = this.kmsDirectStoreMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).in(KmsDirectStoreEntity::getDirectId, (Collection)directIds));
            if (CollectionUtils.isNotEmpty((Collection)storeEntities)) {
                HashSet names = Sets.newHashSet();
                Set<String> idsByDb = storeEntities.stream().map(KmsDirectStoreEntity::getDirectId).collect(Collectors.toSet());
                idsByDb.forEach(x -> {
                    if (map.containsKey(x)) {
                        names.add(map.get(x));
                    }
                });
                throw new BusinessException(((Object)names).toString() + "\u7684\u5546\u8d85\u7cfb\u7edf\u5b58\u5728\u95e8\u5e97\uff0c\u4e0d\u53ef\u5220\u9664");
            }
        }
        this.updateBatchById(kmsDirectSystemEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List kmsDirectSystemEntities = this.kmsDirectSystemMapper.selectBatchIds(ids);
        List oldDataList = CrmBeanUtil.copyList((List)kmsDirectSystemEntities, KmsDirectSystemRespVo.class);
        if (CollectionUtils.isNotEmpty((Collection)kmsDirectSystemEntities)) {
            kmsDirectSystemEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(kmsDirectSystemEntities);
        List newDataList = CrmBeanUtil.copyList((List)kmsDirectSystemEntities, KmsDirectSystemRespVo.class);
        Object menuCode = ThreadLocalUtil.getObj((String)"menuCode");
        for (int i = 0; i < newDataList.size(); ++i) {
            this.crmLogSendUtil.sendForUpdate(menuCode.toString(), ((KmsDirectSystemRespVo)newDataList.get(0)).getId(), ((KmsDirectSystemRespVo)newDataList.get(0)).getId(), oldDataList.get(0), newDataList.get(0));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List kmsDirectSystemEntities = this.kmsDirectSystemMapper.selectBatchIds(ids);
        List oldDataList = CrmBeanUtil.copyList((List)kmsDirectSystemEntities, KmsDirectSystemRespVo.class);
        if (CollectionUtils.isNotEmpty((Collection)kmsDirectSystemEntities)) {
            kmsDirectSystemEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(kmsDirectSystemEntities);
        List newDataList = CrmBeanUtil.copyList((List)kmsDirectSystemEntities, KmsDirectSystemRespVo.class);
        Object menuCode = ThreadLocalUtil.getObj((String)"menuCode");
        for (int i = 0; i < newDataList.size(); ++i) {
            this.crmLogSendUtil.sendForUpdate(menuCode.toString(), ((KmsDirectSystemRespVo)newDataList.get(0)).getId(), ((KmsDirectSystemRespVo)newDataList.get(0)).getId(), oldDataList.get(0), newDataList.get(0));
        }
    }

    @Override
    public PageResult<KmsDirectSystemRespVo> findDirectSystemList(KmsDirectSystemReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<KmsDirectSystemRespVo> respVos = this.kmsDirectSystemMapper.findSystemListByCusOrg((Page<KmsDirectSystemRespVo>)page, reqVo);
        return PageResult.builder().data(respVos).count(Long.valueOf(page.getTotal())).build();
    }
}

