/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.config;

import javax.servlet.http.HttpServletRequest;
import javax.xml.soap.SOAPException;
import org.apache.commons.codec.binary.Base64;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.springframework.util.StringUtils;

public class AuthInterceptor
extends AbstractPhaseInterceptor<SoapMessage> {
    private static final String BASIC_PREFIX = "Basic ";
    private String USERNAME;
    private String PASSWORD;

    public AuthInterceptor(String username, String password) {
        super("pre-protocol");
        this.USERNAME = username;
        this.PASSWORD = password;
    }

    public void handleMessage(SoapMessage soapMessage) throws Fault {
        HttpServletRequest request = (HttpServletRequest)soapMessage.get((Object)"HTTP.REQUEST");
        String auth = request.getHeader("Authorization");
        if (auth == null) {
            SOAPException exception = new SOAPException("Authorization \u6388\u6743\u4fe1\u606f\u4e3a\u7a7a\uff01");
            throw new Fault((Throwable)exception);
        }
        if (!auth.startsWith(BASIC_PREFIX)) {
            SOAPException exception = new SOAPException("Authorization \u975ebaisc\u9a8c\u8bc1");
            throw new Fault((Throwable)exception);
        }
        String plaintext = new String(Base64.decodeBase64((String)auth.substring(BASIC_PREFIX.length())));
        if (StringUtils.isEmpty((Object)plaintext) || !plaintext.contains(":")) {
            SOAPException exception = new SOAPException("Authorization \u975ebaisc\u9a8c\u8bc1");
            throw new Fault((Throwable)exception);
        }
        String[] usernameAndPass = plaintext.split(":");
        String username = usernameAndPass[0];
        String password = usernameAndPass[1];
        if (!this.USERNAME.equals(username) || !this.PASSWORD.equals(password)) {
            SOAPException exception = new SOAPException("\u7528\u6237\u540d\u6216\u5bc6\u7801\u4e0d\u6b63\u786e\uff01");
            throw new Fault((Throwable)exception);
        }
    }
}

