/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.finance.funcation;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.acceptanceform.mapper.KmsAcceptanceFormMapper;
import com.biz.crm.acceptanceform.service.IKmsAcceptanceStatusRecordService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.kms.KmsAuditConditionEnum;
import com.biz.crm.eunm.kms.KmsEnum;
import com.biz.crm.finance.annotation.KmsFunction;
import com.biz.crm.finance.funcation.base.BaseAuditFunction;
import com.biz.crm.finance.mapper.KmsAuditFormMapper;
import com.biz.crm.finance.mapper.KmsAuditMatchRelationMapper;
import com.biz.crm.finance.model.KmsAcceptanceMatchRelationEntity;
import com.biz.crm.finance.model.KmsAuditFormEntity;
import com.biz.crm.finance.model.KmsAuditMatchRelationEntity;
import com.biz.crm.finance.service.IKmsAcceptanceMatchRelationService;
import com.biz.crm.nebular.kms.acceptanceform.req.KmsAcceptanceFormReqVo;
import com.biz.crm.nebular.kms.acceptanceform.resp.KmsAuditAcceptanceFormRespVo;
import com.biz.crm.nebular.kms.finance.req.KmsAuditFormReqVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditFormRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditTemplateDirectRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditTemplateRespVo;
import com.biz.crm.nebular.kms.sap.resp.KmsSapInvoiceRespVo;
import com.biz.crm.sap.model.KmsSapInvoiceEntity;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.KmsUtils;
import com.biz.crm.util.PageUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@KmsFunction(code=KmsAuditConditionEnum.DS, name="\u95e8\u5e97+\u65e5\u671f", desc="\u7a3d\u6838\u6761\u4ef6")
public class KmsDsFunction
implements BaseAuditFunction {
    private static final Logger log = LoggerFactory.getLogger(KmsDsFunction.class);
    @Resource
    private KmsAuditFormMapper kmsAuditFormMapper;
    @Resource
    private KmsAuditMatchRelationMapper kmsAuditMatchRelationMapper;
    @Resource
    private KmsAcceptanceFormMapper kmsAcceptanceFormMapper;
    @Resource
    private IKmsAcceptanceMatchRelationService kmsAcceptanceMatchRelationService;
    @Resource
    private IKmsAcceptanceStatusRecordService kmsAcceptanceStatusRecordService;

    @Override
    public void summary(List<KmsSapInvoiceRespVo> invoice, KmsAuditTemplateRespVo a, KmsAuditTemplateDirectRespVo templateDirectRespVo, List<KmsAuditFormEntity> auditFormEntities, List<KmsAuditMatchRelationEntity> relationEntities) {
    }

    private KmsAuditFormEntity buildAuditForm(KmsAuditFormEntity afe, KmsSapInvoiceEntity e, KmsAuditTemplateDirectRespVo templateDirectRespVo) {
        if (ObjectUtils.isEmpty((Object)afe)) {
            afe = new KmsAuditFormEntity();
            afe.setKaOrderNumber(e.getBstkd());
            afe.setDirectName(templateDirectRespVo.getDirectName());
            afe.setAuditNumber(CodeUtil.generateCode((String)"kms_audit_code"));
            afe.setStoreCode(KmsUtils.removeFrontZero(e.getKunnr()));
            afe.setStoreName(e.getKunnrname());
            afe.setBukrs(e.getBukrs());
            afe.setOrgCode(e.getOrgCode());
            afe.setCreateOrgCode(e.getOrgCode());
            afe.setSapPostingDate(e.getFkdat());
            afe.setSapMaterielCode(KmsUtils.removeFrontZero(e.getMatnr()));
            afe.setSapMaterielName(e.getMaktx());
            afe.setSapQuantity("0");
            afe.setIsAudit(YesNoEnum.yesNoEnum.no.getValue());
            afe.setAcceptanceQuantity("0");
            afe.setSapAmountNot("0");
            afe.setSapAmount("0");
            afe.setAuditStatus(KmsEnum.AuditStatus.WAIT.getValue());
            afe.setAuditResult(KmsEnum.AuditResult.WAIT.getValue());
            afe.setAcceptanceAmount("0");
            afe.setAcceptanceAmountNot("0");
            afe.setAuditTemplateId(templateDirectRespVo.getAuditTemplateId());
            afe.setDifferencePrice(templateDirectRespVo.getDifferencePrice());
            afe.setAuditRule(templateDirectRespVo.getAuditRule());
        }
        return afe;
    }

    private void saveMatchRelation(KmsAuditFormEntity afe, String relationId, String templateId) {
        KmsAuditMatchRelationEntity relationEntity = new KmsAuditMatchRelationEntity();
        relationEntity.setAuditId(afe.getId());
        relationEntity.setAuditNumber(afe.getAuditNumber());
        relationEntity.setAuditTemplateId(templateId);
        relationEntity.setRelationId(relationId);
        this.kmsAuditMatchRelationMapper.insert(relationEntity);
    }

    @Override
    public void matchData(KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo) {
        String sapDateStr = respVo.getSapPostingDate();
        Date sapDate = DateUtil.getDateByFormat((String)sapDateStr, (String)"yyyyMMdd");
        sapDateStr = DateUtil.format((Date)sapDate, (String)"yyyy-MM-dd");
        KmsAcceptanceFormReqVo reqVo = new KmsAcceptanceFormReqVo();
        reqVo.setAcceptanceDate(sapDateStr);
        reqVo.setStoreCode(respVo.getStoreCode());
        List<KmsAuditAcceptanceFormRespVo> acceptanceFormRespVos = this.kmsAcceptanceFormMapper.findMatchedDS(reqVo);
        reqVo.setAuditTemplateId(templateRespVo.getId());
        reqVo.setAuditId(respVo.getId());
        List<KmsAuditAcceptanceFormRespVo> acceptanceFormSuccRespVos = this.kmsAcceptanceFormMapper.findMatchedSuccDS(reqVo);
        acceptanceFormRespVos.removeAll(acceptanceFormSuccRespVos);
        acceptanceFormRespVos.forEach(a -> a.setId(a.getHeaderId()));
        respVo.setAcceptanceFormVos(acceptanceFormRespVos);
    }

    @Override
    public void matchDataSucc(KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo) {
        KmsAcceptanceFormReqVo reqVo = new KmsAcceptanceFormReqVo();
        reqVo.setAuditTemplateId(templateRespVo.getId());
        reqVo.setAuditId(respVo.getId());
        List<KmsAuditAcceptanceFormRespVo> acceptanceFormSuccRespVos = this.kmsAcceptanceFormMapper.findMatchedSuccDS(reqVo);
        acceptanceFormSuccRespVos.forEach(a -> a.setId(a.getHeaderId()));
        respVo.setAcceptanceFormVos(acceptanceFormSuccRespVos);
    }

    @Override
    public void matchDataBinding(KmsAuditFormRespVo afVo, KmsAuditTemplateRespVo templateRespVo) {
        ArrayList relationEntities = Lists.newArrayList();
        ArrayList accIds = Lists.newArrayList();
        afVo.getAcceptanceFormVos().forEach(o -> {
            KmsAcceptanceMatchRelationEntity relationEntity = KmsUtils.buildAcceptanceMatchRelation(o, afVo, templateRespVo.getId());
            relationEntities.add(relationEntity);
            accIds.add(o.getHeaderId());
        });
        if (!CollectionUtils.isEmpty((Collection)relationEntities)) {
            afVo.setIsAudit(YesNoEnum.yesNoEnum.yes.getValue());
            this.kmsAcceptanceMatchRelationService.saveBatch(relationEntities);
        }
    }

    @Override
    public void findMatchDataByIds(List<String> relationIdIds, KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo) {
        KmsAcceptanceFormReqVo reqVo = new KmsAcceptanceFormReqVo();
        reqVo.setIds(relationIdIds);
        List<KmsAuditAcceptanceFormRespVo> acceptanceFormRespVos = this.kmsAcceptanceFormMapper.findMatchedDS(reqVo);
        respVo.setAcceptanceFormVos(acceptanceFormRespVos);
    }

    @Override
    public void cancelMatchData(List<String> relationIdIds, KmsAuditFormRespVo afVo, KmsAuditTemplateRespVo templateRespVo) {
        ArrayList accIds = Lists.newArrayList();
        afVo.getAcceptanceFormVos().forEach(o -> accIds.add(o.getHeaderId()));
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.kmsAcceptanceMatchRelationService.lambdaUpdate().eq(KmsAcceptanceMatchRelationEntity::getAuditId, (Object)afVo.getId())).eq(KmsAcceptanceMatchRelationEntity::getAuditTemplateId, (Object)templateRespVo.getId())).in(KmsAcceptanceMatchRelationEntity::getRelationId, relationIdIds)).remove();
        List entities = ((LambdaQueryChainWrapper)this.kmsAcceptanceMatchRelationService.lambdaQuery().in(KmsAcceptanceMatchRelationEntity::getHeaderId, (Collection)accIds)).list();
        Map<String, List<KmsAcceptanceMatchRelationEntity>> listMap = entities.stream().collect(Collectors.groupingBy(KmsAcceptanceMatchRelationEntity::getHeaderId));
        ArrayList notRelationIds = Lists.newArrayList();
        accIds.forEach(o -> {
            List relationEntities = (List)listMap.get(o);
            if (CollectionUtils.isEmpty((Collection)relationEntities)) {
                notRelationIds.add(o);
            }
        });
        if (!CollectionUtils.isEmpty((Collection)notRelationIds)) {
            List acceptanceFormEntities = this.kmsAcceptanceFormMapper.selectBatchIds(accIds);
            acceptanceFormEntities.forEach(a -> {
                a.setOrderStatus(KmsEnum.OrderStatus.S400.getValue());
                a.setOrderStatusMsg(KmsEnum.OrderStatus.S400.getDescription());
                this.kmsAcceptanceFormMapper.updateById(a);
            });
            this.kmsAcceptanceStatusRecordService.insert(acceptanceFormEntities);
            afVo.setIsAudit(YesNoEnum.yesNoEnum.no.getValue());
        }
    }

    @Override
    public List<KmsAuditAcceptanceFormRespVo> notmatchedAcceptanceFormList(Page<KmsAuditAcceptanceFormRespVo> page, KmsAcceptanceFormReqVo reqVo) {
        return this.kmsAcceptanceFormMapper.findNotMatchedDS(page, reqVo);
    }

    @Override
    public PageResult<KmsAuditAcceptanceFormRespVo> waitMatchedAcc(KmsAuditFormReqVo reqVo, KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo) {
        KmsAcceptanceFormReqVo queryVo = new KmsAcceptanceFormReqVo();
        queryVo.setStoreCode(respVo.getStoreCode());
        queryVo.setAuditTemplateId(templateRespVo.getId());
        queryVo.setAuditId(respVo.getId());
        List<KmsAuditAcceptanceFormRespVo> acceptanceFormSuccRespVos = this.kmsAcceptanceFormMapper.findMatchedSuccDS(queryVo);
        List matchIds = acceptanceFormSuccRespVos.stream().map(KmsAuditAcceptanceFormRespVo::getHeaderId).distinct().collect(Collectors.toList());
        queryVo.setMatchIds(matchIds);
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        queryVo.setAcceptanceDateStart(reqVo.getAcceptanceDateStart());
        queryVo.setAcceptanceDateEnd(reqVo.getAcceptanceDateEnd());
        queryVo.setOrderNumber(reqVo.getOrderNumber());
        List<KmsAuditAcceptanceFormRespVo> list = this.kmsAcceptanceFormMapper.findMatchedDS((Page<KmsAuditAcceptanceFormRespVo>)page, queryVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<KmsAuditAcceptanceFormRespVo> matchedAcc(KmsAuditFormReqVo reqVo, KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo) {
        KmsAcceptanceFormReqVo queryVo = new KmsAcceptanceFormReqVo();
        queryVo.setAuditTemplateId(templateRespVo.getId());
        queryVo.setAuditId(respVo.getId());
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        queryVo.setAcceptanceDateStart(reqVo.getAcceptanceDateStart());
        queryVo.setAcceptanceDateEnd(reqVo.getAcceptanceDateEnd());
        queryVo.setOrderNumber(reqVo.getOrderNumber());
        List<KmsAuditAcceptanceFormRespVo> list = this.kmsAcceptanceFormMapper.findMatchedSuccDS((Page<KmsAuditAcceptanceFormRespVo>)page, queryVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public void delayedReceiptAcc(KmsAuditFormRespVo o, KmsAuditTemplateRespVo auditTemplateRespVo) {
    }
}

