/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.finance.funcation;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.acceptanceform.mapper.KmsAcceptanceFormMapper;
import com.biz.crm.acceptanceform.service.IKmsAcceptanceStatusRecordService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.kms.KmsAuditConditionEnum;
import com.biz.crm.eunm.kms.KmsEnum;
import com.biz.crm.finance.annotation.KmsFunction;
import com.biz.crm.finance.funcation.base.BaseAuditFunction;
import com.biz.crm.finance.mapper.KmsAuditFormMapper;
import com.biz.crm.finance.mapper.KmsAuditMatchRelationMapper;
import com.biz.crm.finance.model.KmsAcceptanceMatchRelationEntity;
import com.biz.crm.finance.model.KmsAuditFormEntity;
import com.biz.crm.finance.model.KmsAuditMatchRelationEntity;
import com.biz.crm.finance.service.IKmsAcceptanceMatchRelationService;
import com.biz.crm.kaproduct.mapper.KmsTenantryDirectProductMapper;
import com.biz.crm.nebular.kms.acceptanceform.req.KmsAcceptanceFormReqVo;
import com.biz.crm.nebular.kms.acceptanceform.resp.KmsAuditAcceptanceFormRespVo;
import com.biz.crm.nebular.kms.finance.req.KmsAuditFormReqVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditFormRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditTemplateDirectRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditTemplateRespVo;
import com.biz.crm.nebular.kms.kaproduct.req.KmsTenantryDirectProductReqVo;
import com.biz.crm.nebular.kms.kaproduct.resp.KmsTenantryDirectProductRespVo;
import com.biz.crm.nebular.kms.sap.resp.KmsSapInvoiceRespVo;
import com.biz.crm.nebular.kms.supermarket.req.KmsTotalWarehouseStoreReqVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsTotalWarehouseStoreRespVo;
import com.biz.crm.supermarket.mapper.KmsTotalWarehouseStoreMapper;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.KmsUtils;
import com.biz.crm.util.PageUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@KmsFunction(code=KmsAuditConditionEnum.PDS, name="\u95e8\u5e97+\u5546\u54c1+\u65e5\u671f", desc="\u7a3d\u6838\u6761\u4ef6")
public class KmsPdsFunction
implements BaseAuditFunction {
    private static final Logger log = LoggerFactory.getLogger(KmsPdsFunction.class);
    @Resource
    private KmsAuditFormMapper kmsAuditFormMapper;
    @Resource
    private KmsAuditMatchRelationMapper kmsAuditMatchRelationMapper;
    @Resource
    private KmsAcceptanceFormMapper kmsAcceptanceFormMapper;
    @Resource
    private IKmsAcceptanceMatchRelationService kmsAcceptanceMatchRelationService;
    @Resource
    private IKmsAcceptanceStatusRecordService kmsAcceptanceStatusRecordService;
    @Resource
    private KmsTotalWarehouseStoreMapper kmsTotalWarehouseStoreMapper;
    @Resource
    private KmsTenantryDirectProductMapper kmsTenantryDirectProductMapper;

    @Override
    public void summary(List<KmsSapInvoiceRespVo> invoice, KmsAuditTemplateRespVo a, KmsAuditTemplateDirectRespVo templateDirectRespVo, List<KmsAuditFormEntity> auditFormEntities, List<KmsAuditMatchRelationEntity> relationEntities) {
        KmsSapInvoiceRespVo e = invoice.get(0);
        KmsTotalWarehouseStoreReqVo reqVo = new KmsTotalWarehouseStoreReqVo();
        reqVo.setBsDirectSystemId(a.getBsDirectSystemId());
        List<KmsTotalWarehouseStoreRespVo> totalStoreRespVos = this.kmsTotalWarehouseStoreMapper.findTotalStoreList(reqVo);
        Map<String, List<KmsTotalWarehouseStoreRespVo>> totalStoreMap = totalStoreRespVos.stream().collect(Collectors.groupingBy(o -> o.getProductType() + "_" + o.getTerminalCode()));
        HashMap summaryInvStoreMap = Maps.newHashMap();
        HashMap summaryInvSolMap = Maps.newHashMap();
        HashMap summaryAuditStoreMap = Maps.newHashMap();
        HashMap summaryAuditSolMap = Maps.newHashMap();
        ArrayList sapPostingDateList = Lists.newArrayList();
        ArrayList sapMaterielCodeList = Lists.newArrayList();
        invoice.forEach(invo -> {
            invo.setKunnr(KmsUtils.removeFrontZero(invo.getKunnr()));
            invo.setKunag(KmsUtils.removeFrontZero(invo.getKunag()));
            invo.setMatnr(KmsUtils.removeFrontZero(invo.getMatnr()));
            invo.setIsStore(YesNoEnum.yesNoEnum.Y.getValue());
            String key = invo.getMtpos() + "_" + invo.getKunnr();
            List totalWarehouseStoreRespVos = (List)totalStoreMap.get(key);
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)totalWarehouseStoreRespVos)) {
                List storeProductRespVos = totalWarehouseStoreRespVos.stream().filter(o -> !StringUtils.isEmpty((Object)o.getDirectProductId())).collect(Collectors.toList());
                if (!org.springframework.util.CollectionUtils.isEmpty(storeProductRespVos)) {
                    if (!org.springframework.util.CollectionUtils.isEmpty((Collection)storeProductRespVos.stream().filter(o -> o.getProductCode().equals(invo.getMatnr())).collect(Collectors.toList()))) {
                        invo.setIsStore(YesNoEnum.yesNoEnum.N.getValue());
                    }
                } else {
                    invo.setIsStore(YesNoEnum.yesNoEnum.N.getValue());
                }
            }
            sapMaterielCodeList.add(KmsUtils.removeFrontZero(e.getMatnr()));
            if (YesNoEnum.yesNoEnum.Y.getValue().equals(invo.getIsStore())) {
                String storeKey = invo.getKunnr() + "-" + invo.getFkdat() + "-" + invo.getMatnr();
                List invoS = (List)summaryInvStoreMap.get(storeKey);
                if (org.springframework.util.CollectionUtils.isEmpty((Collection)invoS)) {
                    invoS = Lists.newArrayList();
                }
                invoS.add(invo);
                summaryInvStoreMap.put(storeKey, invoS);
            } else {
                String solKey = invo.getKunag() + "-" + invo.getFkdat() + "-" + invo.getMatnr();
                List invoS = (List)summaryInvSolMap.get(solKey);
                if (org.springframework.util.CollectionUtils.isEmpty((Collection)invoS)) {
                    invoS = Lists.newArrayList();
                }
                invoS.add(invo);
                summaryInvSolMap.put(solKey, invoS);
            }
        });
        String templateId = a.getId();
        KmsAuditFormReqVo params = new KmsAuditFormReqVo();
        params.setBukrs(e.getBukrs());
        params.setOrgCode(e.getOrgCode());
        params.setAuditTemplateId(templateId);
        params.setBsDirectSystemId(a.getBsDirectSystemId());
        params.setSapPostingDate(e.getFkdat());
        List<KmsAuditFormEntity> afeEntities = this.kmsAuditFormMapper.findListByParams(params);
        afeEntities.forEach(audit -> {
            if (YesNoEnum.yesNoEnum.Y.getValue().equals(audit.getIsStoreSummary())) {
                String storeKey = audit.getStoreCode() + "-" + audit.getSapPostingDate() + "-" + audit.getSapMaterielCode();
                summaryAuditStoreMap.put(storeKey, audit);
            } else {
                String solKey = audit.getSoldToPartyCode() + "-" + audit.getSapPostingDate() + "-" + audit.getSapMaterielCode();
                summaryAuditSolMap.put(solKey, audit);
            }
        });
        summaryInvStoreMap.forEach((k, v) -> {
            KmsAuditFormEntity afe = (KmsAuditFormEntity)summaryAuditStoreMap.get(k);
            if (ObjectUtils.isEmpty((Object)afe)) {
                afe = new KmsAuditFormEntity();
                KmsSapInvoiceRespVo i = (KmsSapInvoiceRespVo)v.get(0);
                this.buildAuditForm(afe, i, templateDirectRespVo);
                afe.setProductType(i.getMtpos());
                afe.setDirectName(a.getBsDirectSystemName());
                afe.setBsDirectSystemId(a.getBsDirectSystemId());
                auditFormEntities.add(afe);
                for (int iv = 0; iv < v.size(); ++iv) {
                    KmsAuditMatchRelationEntity relationEntity = new KmsAuditMatchRelationEntity();
                    relationEntity.setAuditNumber(afe.getAuditNumber());
                    relationEntity.setAuditTemplateId(templateId);
                    relationEntity.setRelationId(((KmsSapInvoiceRespVo)v.get(iv)).getId());
                    relationEntities.add(relationEntity);
                }
            } else {
                for (int iv = 0; iv < v.size(); ++iv) {
                    KmsAuditMatchRelationEntity relationEntity = new KmsAuditMatchRelationEntity();
                    relationEntity.setAuditId(afe.getId());
                    relationEntity.setAuditNumber(afe.getAuditNumber());
                    relationEntity.setAuditTemplateId(templateId);
                    relationEntity.setRelationId(((KmsSapInvoiceRespVo)v.get(iv)).getId());
                    relationEntities.add(relationEntity);
                }
            }
        });
        summaryInvSolMap.forEach((k, v) -> {
            KmsAuditFormEntity afe = (KmsAuditFormEntity)summaryAuditSolMap.get(k);
            if (ObjectUtils.isEmpty((Object)afe)) {
                afe = new KmsAuditFormEntity();
                KmsSapInvoiceRespVo i = (KmsSapInvoiceRespVo)v.get(0);
                this.buildAuditForm(afe, i, templateDirectRespVo);
                afe.setProductType(i.getMtpos());
                afe.setDirectName(a.getBsDirectSystemName());
                afe.setBsDirectSystemId(a.getBsDirectSystemId());
                auditFormEntities.add(afe);
                for (int iv = 0; iv < v.size(); ++iv) {
                    KmsAuditMatchRelationEntity relationEntity = new KmsAuditMatchRelationEntity();
                    relationEntity.setAuditNumber(afe.getAuditNumber());
                    relationEntity.setAuditTemplateId(templateId);
                    relationEntity.setRelationId(((KmsSapInvoiceRespVo)v.get(iv)).getId());
                    relationEntities.add(relationEntity);
                }
            } else {
                for (int iv = 0; iv < v.size(); ++iv) {
                    KmsAuditMatchRelationEntity relationEntity = new KmsAuditMatchRelationEntity();
                    relationEntity.setAuditId(afe.getId());
                    relationEntity.setAuditNumber(afe.getAuditNumber());
                    relationEntity.setAuditTemplateId(templateId);
                    relationEntity.setRelationId(((KmsSapInvoiceRespVo)v.get(iv)).getId());
                    relationEntities.add(relationEntity);
                }
            }
        });
    }

    private void buildAuditForm(KmsAuditFormEntity afe, KmsSapInvoiceRespVo e, KmsAuditTemplateDirectRespVo templateDirectRespVo) {
        afe.setKaOrderNumber(e.getBstkd());
        afe.setBsDirectSystemId(templateDirectRespVo.getBsDirectSystemId());
        afe.setBsDirectSystemCode(templateDirectRespVo.getBsDirectSystemCode());
        afe.setBsDirectSystemName(templateDirectRespVo.getBsDirectSystemName());
        afe.setDirectName(templateDirectRespVo.getDirectName());
        afe.setAuditNumber(CodeUtil.generateCode((String)"kms_audit_code"));
        if (YesNoEnum.yesNoEnum.Y.getValue().equals(e.getIsStore())) {
            afe.setStoreCode(KmsUtils.removeFrontZero(e.getKunnr()));
            afe.setStoreName(e.getKunnrname());
            afe.setIsStoreSummary(YesNoEnum.yesNoEnum.Y.getValue());
        } else {
            afe.setSoldToPartyCode(KmsUtils.removeFrontZero(e.getKunag()));
            afe.setSoldToPartyName(e.getKunagname());
            afe.setIsStoreSummary(YesNoEnum.yesNoEnum.N.getValue());
        }
        afe.setBukrs(e.getBukrs());
        afe.setOrgCode(e.getOrgCode());
        afe.setCreateOrgCode(e.getOrgCode());
        afe.setSapPostingDate(e.getFkdat());
        afe.setSapMaterielCode(KmsUtils.removeFrontZero(e.getMatnr()));
        afe.setSapMaterielName(e.getMaktx());
        afe.setSapQuantity("0");
        afe.setIsAudit(YesNoEnum.yesNoEnum.no.getValue());
        afe.setAcceptanceQuantity("0");
        afe.setSapAmountNot("0");
        afe.setSapAmount("0");
        afe.setAuditStatus(KmsEnum.AuditStatus.WAIT.getValue());
        afe.setAuditResult(KmsEnum.AuditResult.WAIT.getValue());
        afe.setAcceptanceAmount("0");
        afe.setAcceptanceAmountNot("0");
        afe.setAuditTemplateId(templateDirectRespVo.getAuditTemplateId());
        afe.setDifferencePrice(templateDirectRespVo.getDifferencePrice());
        afe.setAuditRule(templateDirectRespVo.getAuditRule());
    }

    private void saveMatchRelation(KmsAuditFormEntity afe, String relationId, String templateId) {
        KmsAuditMatchRelationEntity relationEntity = new KmsAuditMatchRelationEntity();
        relationEntity.setAuditId(afe.getId());
        relationEntity.setAuditNumber(afe.getAuditNumber());
        relationEntity.setAuditTemplateId(templateId);
        relationEntity.setRelationId(relationId);
        this.kmsAuditMatchRelationMapper.insert(relationEntity);
    }

    @Override
    public void matchData(KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo) {
        List relationEntities = ((LambdaQueryChainWrapper)this.kmsAcceptanceMatchRelationService.lambdaQuery().eq(KmsAcceptanceMatchRelationEntity::getAuditId, (Object)respVo.getId())).list();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)relationEntities)) {
            List<String> relationIds = relationEntities.stream().map(KmsAcceptanceMatchRelationEntity::getRelationId).collect(Collectors.toList());
            this.findMatchDataByIds(relationIds, respVo, templateRespVo);
            this.cancelMatchData(relationIds, respVo, templateRespVo);
        }
        String sapDateStr = respVo.getSapPostingDate();
        Date sapDate = DateUtil.getDateByFormat((String)sapDateStr, (String)"yyyyMMdd");
        sapDateStr = DateUtil.format((Date)sapDate, (String)"yyyy-MM-dd");
        KmsAcceptanceFormReqVo reqVo = new KmsAcceptanceFormReqVo();
        reqVo.setAuditDate(sapDateStr);
        reqVo.setStoreCode(respVo.getStoreCode());
        reqVo.setAuditTemplateId(respVo.getAuditTemplateId());
        reqVo.setSoldToPartyCode(respVo.getSoldToPartyCode());
        reqVo.setProductType(respVo.getProductType());
        reqVo.setGoodsCode(respVo.getSapMaterielCode());
        reqVo.setBsDirectSystemId(respVo.getBsDirectSystemId());
        List<KmsAuditAcceptanceFormRespVo> acceptanceFormRespVos = this.kmsAcceptanceFormMapper.findMatchedPDS(reqVo);
        acceptanceFormRespVos.forEach(a -> a.setId(a.getGoodsId()));
        respVo.setAcceptanceFormVos(acceptanceFormRespVos);
    }

    @Override
    public void matchDataSucc(KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo) {
        KmsAcceptanceFormReqVo reqVo = new KmsAcceptanceFormReqVo();
        reqVo.setAuditTemplateId(templateRespVo.getId());
        reqVo.setAuditId(respVo.getId());
        List<KmsAuditAcceptanceFormRespVo> acceptanceFormSuccRespVos = this.kmsAcceptanceFormMapper.findMatchedSuccPDS(reqVo);
        acceptanceFormSuccRespVos.forEach(a -> a.setId(a.getGoodsId()));
        respVo.setAcceptanceFormVos(acceptanceFormSuccRespVos);
    }

    @Override
    public void matchDataBinding(KmsAuditFormRespVo afVo, KmsAuditTemplateRespVo templateRespVo) {
        ArrayList relationEntities = Lists.newArrayList();
        ArrayList accIds = Lists.newArrayList();
        afVo.getAcceptanceFormVos().forEach(o -> {
            KmsAcceptanceMatchRelationEntity relationEntity = KmsUtils.buildAcceptanceMatchRelation(o, afVo, templateRespVo.getId());
            relationEntities.add(relationEntity);
            accIds.add(o.getHeaderId());
        });
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)relationEntities)) {
            afVo.setIsAudit(YesNoEnum.yesNoEnum.yes.getValue());
            this.kmsAcceptanceMatchRelationService.saveBatch(relationEntities);
            List acceptanceFormEntities = this.kmsAcceptanceFormMapper.selectBatchIds(accIds);
            acceptanceFormEntities.forEach(a -> {
                if (!KmsEnum.OrderStatus.S100.getValue().equals(a.getOrderStatus())) {
                    a.setOrderStatus(KmsEnum.OrderStatus.S600.getValue());
                    a.setOrderStatusMsg(KmsEnum.OrderStatus.S600.getDescription());
                }
                this.kmsAcceptanceFormMapper.updateById(a);
            });
            this.kmsAcceptanceStatusRecordService.insert(acceptanceFormEntities);
        }
    }

    @Override
    public void findMatchDataByIds(List<String> relationIdIds, KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo) {
        KmsAcceptanceFormReqVo reqVo = new KmsAcceptanceFormReqVo();
        reqVo.setIds(relationIdIds);
        List<KmsAuditAcceptanceFormRespVo> acceptanceFormRespVos = this.kmsAcceptanceFormMapper.findMatchedPDS(reqVo);
        respVo.setAcceptanceFormVos(acceptanceFormRespVos);
    }

    @Override
    public void cancelMatchData(List<String> relationIdIds, KmsAuditFormRespVo afVo, KmsAuditTemplateRespVo templateRespVo) {
        ArrayList accIds = Lists.newArrayList();
        afVo.getAcceptanceFormVos().forEach(o -> accIds.add(o.getHeaderId()));
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.kmsAcceptanceMatchRelationService.lambdaUpdate().eq(KmsAcceptanceMatchRelationEntity::getAuditId, (Object)afVo.getId())).eq(KmsAcceptanceMatchRelationEntity::getAuditTemplateId, (Object)templateRespVo.getId())).in(KmsAcceptanceMatchRelationEntity::getRelationId, relationIdIds)).remove();
        ArrayList entities = org.springframework.util.CollectionUtils.isEmpty((Collection)accIds) ? Lists.newArrayList() : ((LambdaQueryChainWrapper)this.kmsAcceptanceMatchRelationService.lambdaQuery().in(KmsAcceptanceMatchRelationEntity::getHeaderId, (Collection)accIds)).list();
        Map<String, List<KmsAcceptanceMatchRelationEntity>> listMap = entities.stream().collect(Collectors.groupingBy(KmsAcceptanceMatchRelationEntity::getHeaderId));
        ArrayList notRelationIds = Lists.newArrayList();
        accIds.forEach(o -> {
            List relationEntities = (List)listMap.get(o);
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)relationEntities)) {
                notRelationIds.add(o);
            }
        });
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)notRelationIds)) {
            List acceptanceFormEntities = this.kmsAcceptanceFormMapper.selectBatchIds(accIds);
            acceptanceFormEntities.forEach(a -> {
                if (KmsEnum.OrderStatus.S400.getDescription().equals(a.getOrderStatusMsg()) || KmsEnum.OrderStatus.S600.getDescription().equals(a.getOrderStatusMsg())) {
                    a.setOrderStatus(KmsEnum.OrderStatus.S400.getValue());
                    a.setOrderStatusMsg(KmsEnum.OrderStatus.S400.getDescription());
                } else {
                    a.setOrderStatus(KmsEnum.OrderStatus.S100.getValue());
                }
                this.kmsAcceptanceFormMapper.updateById(a);
            });
            this.kmsAcceptanceStatusRecordService.insert(acceptanceFormEntities);
            afVo.setIsAudit(YesNoEnum.yesNoEnum.no.getValue());
        }
    }

    @Override
    public List<KmsAuditAcceptanceFormRespVo> notmatchedAcceptanceFormList(Page<KmsAuditAcceptanceFormRespVo> page, KmsAcceptanceFormReqVo reqVo) {
        return this.kmsAcceptanceFormMapper.findNotMatchedPDS(page, reqVo);
    }

    @Override
    public PageResult<KmsAuditAcceptanceFormRespVo> waitMatchedAcc(KmsAuditFormReqVo reqVo, KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo) {
        KmsAcceptanceFormReqVo queryVo = new KmsAcceptanceFormReqVo();
        queryVo.setStoreCode(respVo.getStoreCode());
        queryVo.setSoldToPartyCode(respVo.getSoldToPartyCode());
        queryVo.setProductType(respVo.getProductType());
        queryVo.setBsDirectSystemId(respVo.getBsDirectSystemId());
        KmsTenantryDirectProductReqVo params = new KmsTenantryDirectProductReqVo();
        params.setProductCode(respVo.getSapMaterielCode());
        params.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        params.setBsDirectSystemId(respVo.getBsDirectSystemId());
        List<KmsTenantryDirectProductRespVo> productRespVos = this.kmsTenantryDirectProductMapper.findListByWeek(params);
        if (org.springframework.util.CollectionUtils.isEmpty(productRespVos)) {
            queryVo.setGoodsCode(respVo.getSapMaterielCode());
        } else {
            queryVo.setKaGoodsCodeList(productRespVos.stream().map(KmsTenantryDirectProductRespVo::getKaProductCode).distinct().collect(Collectors.toList()));
        }
        queryVo.setAuditTemplateId(templateRespVo.getId());
        queryVo.setAuditId(respVo.getId());
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        queryVo.setAcceptanceDateStart(reqVo.getAcceptanceDateStart());
        queryVo.setAcceptanceDateEnd(reqVo.getAcceptanceDateEnd());
        queryVo.setOrderNumber(reqVo.getOrderNumber());
        List<KmsAuditAcceptanceFormRespVo> list = this.kmsAcceptanceFormMapper.findMatchedPDS((Page<KmsAuditAcceptanceFormRespVo>)page, queryVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<KmsAuditAcceptanceFormRespVo> matchedAcc(KmsAuditFormReqVo reqVo, KmsAuditFormRespVo respVo, KmsAuditTemplateRespVo templateRespVo) {
        KmsAcceptanceFormReqVo queryVo = new KmsAcceptanceFormReqVo();
        queryVo.setAuditTemplateId(templateRespVo.getId());
        queryVo.setAuditId(respVo.getId());
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        queryVo.setAcceptanceDateStart(reqVo.getAcceptanceDateStart());
        queryVo.setAcceptanceDateEnd(reqVo.getAcceptanceDateEnd());
        queryVo.setOrderNumber(reqVo.getOrderNumber());
        List<KmsAuditAcceptanceFormRespVo> list = this.kmsAcceptanceFormMapper.findMatchedSuccPDS((Page<KmsAuditAcceptanceFormRespVo>)page, queryVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public void delayedReceiptAcc(KmsAuditFormRespVo auditFormRespVo, KmsAuditTemplateRespVo auditTemplateRespVo) {
        ArrayList quantityArray = Lists.newArrayList();
        auditFormRespVo.getSapOrderFormVos().forEach(o -> quantityArray.add(o.getSapQuantity()));
        KmsAcceptanceFormReqVo queryVo = new KmsAcceptanceFormReqVo();
        queryVo.setQuantityArray((List)quantityArray);
        queryVo.setStoreCode(auditFormRespVo.getStoreCode());
        queryVo.setSoldToPartyCode(auditFormRespVo.getSoldToPartyCode());
        queryVo.setProductType(auditFormRespVo.getProductType());
        queryVo.setGoodsCode(auditFormRespVo.getSapMaterielCode());
        queryVo.setAuditTemplateId(auditTemplateRespVo.getId());
        queryVo.setBsDirectSystemId(auditFormRespVo.getBsDirectSystemId());
        queryVo.setAuditId(auditFormRespVo.getId());
        KmsTenantryDirectProductReqVo productParams = new KmsTenantryDirectProductReqVo();
        productParams.setProductCode(queryVo.getGoodsCode());
        productParams.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        productParams.setBsDirectSystemId(queryVo.getBsDirectSystemId());
        List<KmsTenantryDirectProductRespVo> productRespVos = this.kmsTenantryDirectProductMapper.findListByWeek(productParams);
        if (CollectionUtils.isNotEmpty(productRespVos)) {
            queryVo.setKaGoodsCode(productRespVos.get(0).getKaProductCode());
            queryVo.setGoodsCode(null);
        }
        Date dateByFormat = DateUtil.getDateByFormat((String)auditFormRespVo.getSapPostingDate(), (String)"yyyyMMdd");
        Calendar cl = Calendar.getInstance();
        queryVo.setAcceptanceDateStart(DateUtil.format((Date)dateByFormat, (String)"yyyy-MM-dd"));
        cl.setTime(dateByFormat);
        cl.add(5, 7);
        queryVo.setAcceptanceDateEnd(DateUtil.format((Date)cl.getTime(), (String)"yyyy-MM-dd"));
        List<KmsAuditAcceptanceFormRespVo> list = this.kmsAcceptanceFormMapper.findMatchedPDS(queryVo);
        list.forEach(a -> {
            a.setId(a.getGoodsId());
            if (StringUtils.isEmpty((Object)a.getAuditDate())) {
                throw new BusinessException("\u9a8c\u6536\u5355[" + a.getOrderNumber() + "]\u7a3d\u6838\u65e5\u671f\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u5339\u914d\u9a8c\u6536\u5355\uff01");
            }
            a.setAuditDate(KmsUtils.formatYYYYMMDD(a.getAuditDate()));
            Date date1 = DateUtil.getDateByFormat((String)a.getAuditDate(), (String)"yyyyMMdd");
            Date date2 = DateUtil.getDateByFormat((String)auditFormRespVo.getSapPostingDate(), (String)"yyyyMMdd");
            a.setDifferenceDay(new BigDecimal(DateUtil.getDistanceDay((long)(DateUtil.getMillis((Date)date1) / 1000L), (long)(DateUtil.getMillis((Date)date2) / 1000L))));
        });
        List collect = list.stream().sorted(Comparator.comparing(KmsAuditAcceptanceFormRespVo::getDifferenceDay)).collect(Collectors.toList());
        auditFormRespVo.setAcceptanceFormVos(collect);
    }
}

