/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.finance.helper;

import com.biz.crm.eunm.kms.KmsAdminEnum;
import com.biz.crm.eunm.kms.KmsEnum;
import com.biz.crm.finance.model.KmsAuditTemplateDirectEntity;
import com.biz.crm.nebular.kms.finance.req.KmsAuditTemplateReqVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class KmsAuditTemplateHelper {
    private static final Logger log = LoggerFactory.getLogger(KmsAuditTemplateHelper.class);

    public void check(KmsAuditTemplateReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getTemplateName(), (String)"\u6a21\u7248\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((Collection)reqVo.getOrderTypeList(), (String)"\u5355\u636e\u7c7b\u578b\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((Collection)reqVo.getConditionList(), (String)"\u5339\u914d\u6761\u4ef6\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((Collection)reqVo.getDirectVos(), (String)"\u5546\u8d85\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        reqVo.getOrderTypeList().forEach(o -> {
            String s = (String)KmsAdminEnum.OrderType.GETMAP.get(o);
            AssertUtils.isNotEmpty((String)s, (String)"\u5355\u636e\u7c7b\u578b\u9519\u8bef");
        });
        reqVo.setOrderTypeArray(reqVo.getOrderTypeList().stream().sorted().collect(Collectors.joining(",")));
        reqVo.getConditionList().forEach(o -> {
            String s = (String)KmsAdminEnum.AuditCondition.GETMAP.get(o);
            AssertUtils.isNotEmpty((String)s, (String)"\u7a3d\u6838\u6761\u4ef6\u9519\u8bef");
        });
        reqVo.setConditionArray(reqVo.getConditionList().stream().sorted().collect(Collectors.joining(",")));
        reqVo.getDirectVos().forEach(o -> {
            AssertUtils.isNotEmpty((String)o.getDirectId(), (String)"\u5546\u8d85ID\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)o.getDirectName(), (String)"\u5546\u8d85\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotNull((Object)o.getDifferencePrice(), (String)"\u4ef7\u683c\u5141\u5dee\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)o.getAuditRule(), (String)"\u5bb9\u5dee\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a");
            String s = (String)KmsEnum.AuditRule.GETMAP.get(o.getAuditRule());
            AssertUtils.isNotEmpty((String)s, (String)"\u5bb9\u5dee\u89c4\u5219\u6570\u636e\u9519\u8bef");
        });
    }

    public List<KmsAuditTemplateDirectEntity> buildAuditDirect(KmsAuditTemplateReqVo reqVo) {
        List directVos = reqVo.getDirectVos();
        directVos.forEach(o -> o.setAuditTemplateId(reqVo.getId()));
        return CrmBeanUtil.copyList((List)directVos, KmsAuditTemplateDirectEntity.class);
    }
}

