/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.finance.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.acceptanceform.mapper.KmsAcceptanceFormMapper;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.kms.KmsEnum;
import com.biz.crm.finance.helper.KmsAuditFormHelper;
import com.biz.crm.finance.mapper.KmsAcceptanceMatchRelationMapper;
import com.biz.crm.finance.mapper.KmsAuditFormMapper;
import com.biz.crm.finance.mapper.KmsAuditMatchRelationMapper;
import com.biz.crm.finance.mapper.KmsAuditTemplateDirectMapper;
import com.biz.crm.finance.mapper.KmsAuditTemplateMapper;
import com.biz.crm.finance.model.KmsAuditFormEntity;
import com.biz.crm.finance.model.KmsAuditMatchRelationEntity;
import com.biz.crm.finance.service.IKmsAuditFormService;
import com.biz.crm.finance.service.IKmsAuditMatchRelationService;
import com.biz.crm.finance.service.IKmsAuditTemplateService;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mdm.terminal.MdmTerminalSupplyFeign;
import com.biz.crm.nebular.kms.acceptanceform.req.KmsAcceptanceFormReqVo;
import com.biz.crm.nebular.kms.acceptanceform.resp.KmsAuditAcceptanceFormRespVo;
import com.biz.crm.nebular.kms.finance.req.KmsAuditFormReqVo;
import com.biz.crm.nebular.kms.finance.req.KmsAuditTemplateReqVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAcceptanceMatchRelationRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditFormExportRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditFormRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditTemplateRespVo;
import com.biz.crm.nebular.kms.sap.req.KmsSapOrderFormReqVo;
import com.biz.crm.nebular.kms.sap.resp.KmsSapInvoiceRespVo;
import com.biz.crm.nebular.kms.sap.resp.KmsSapOrderFormRespVo;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectStoreReqVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsTenantryDirectCustomerOrgRespVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsTenantryDirectStoreRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerRespVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgSearchReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.sap.helper.KmsSapHelper;
import com.biz.crm.sap.mapper.KmsSapInvoiceMapper;
import com.biz.crm.sap.model.KmsSapInvoiceEntity;
import com.biz.crm.sap.service.IKmsSapInvoiceService;
import com.biz.crm.supermarket.mapper.KmsTenantryDirectCustomerOrgMapper;
import com.biz.crm.supermarket.mapper.KmsTenantryDirectStoreMapper;
import com.biz.crm.supermarket.model.KmsTenantryDirectCustomerOrgEntity;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.KmsUtils;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
@ConditionalOnMissingBean(name={"KmsAuditFormServiceExpandImpl"})
public class KmsAuditFormServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<KmsAuditFormMapper, KmsAuditFormEntity>
implements IKmsAuditFormService {
    private static final Logger log = LoggerFactory.getLogger(KmsAuditFormServiceImpl.class);
    @Resource
    private KmsAuditFormMapper kmsAuditFormMapper;
    @Resource
    private KmsAcceptanceFormMapper kmsAcceptanceFormMapper;
    @Resource
    private KmsSapHelper kmsSapHelper;
    @Resource
    private KmsSapInvoiceMapper kmsSapInvoiceMapper;
    @Resource
    private IKmsSapInvoiceService kmsSapInvoiceService;
    @Resource
    private MdmOrgFeign mdmOrgFeign;
    @Resource
    private KmsAuditFormHelper kmsAuditFormHelper;
    @Resource
    private KmsAuditTemplateMapper kmsAuditTemplateMapper;
    @Resource
    private IKmsAuditTemplateService kmsAuditTemplateService;
    @Resource
    private KmsTenantryDirectStoreMapper kmsTenantryDirectStoreMapper;
    @Resource
    private KmsAcceptanceMatchRelationMapper kmsAcceptanceMatchRelationMapper;
    @Resource
    private KmsAuditMatchRelationMapper kmsAuditMatchRelationMapper;
    @Resource
    private IKmsAuditMatchRelationService kmsAuditMatchRelationService;
    @Resource
    private MdmTerminalSupplyFeign mdmTerminalSupplyFeign;
    @Resource
    private KmsTenantryDirectCustomerOrgMapper tenantryDirectCustomerOrgMapper;
    @Resource
    private KmsAuditTemplateDirectMapper kmsAuditTemplateDirectMapper;
    @Resource
    private CrmLogSendUtil crmLogSendUtil;
    private static final String KMS_FKART_TYPE = "kms_sap_invoice_fkart_type";
    private static final String KMS_SAP_BUKRS = "kms_sap_invoice_bukrs";

    @Override
    public PageResult<KmsAuditFormRespVo> findList(KmsAuditFormReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getAuditTemplateId(), (String)"\u5339\u914d\u6a21\u7248ID[auditTemplateId]\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isNotEmpty((String)reqVo.getSapPostingDateStart())) {
            reqVo.setSapPostingDateStart(KmsAuditFormServiceImpl.format(reqVo.getSapPostingDateStart()));
        }
        if (StringUtils.isNotEmpty((String)reqVo.getSapPostingDateEnd())) {
            reqVo.setSapPostingDateEnd(KmsAuditFormServiceImpl.format(reqVo.getSapPostingDateEnd()));
        }
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<KmsAuditFormRespVo> list = this.kmsAuditFormMapper.findList((Page<KmsAuditFormRespVo>)page, reqVo);
        KmsAuditTemplateReqVo templateReqVo = new KmsAuditTemplateReqVo();
        templateReqVo.setId(reqVo.getAuditTemplateId());
        KmsAuditTemplateRespVo templateRespVo = this.kmsAuditTemplateService.query(templateReqVo);
        List orgCodes = list.stream().map(KmsAuditFormRespVo::getOrgCode).distinct().collect(Collectors.toList());
        List orgByCodeList = OrgUtil.getOrgByCodeList(orgCodes);
        Map<String, String> orgCompanyMap = orgByCodeList.stream().collect(Collectors.toMap(MdmOrgRespVo::getOrgCode, MdmOrgRespVo::getOrgName));
        List<String> auditIds = list.stream().map(UuidVo::getId).collect(Collectors.toList());
        ArrayList sapFormVoArray = org.springframework.util.CollectionUtils.isEmpty(auditIds) ? Lists.newArrayList() : this.kmsSapInvoiceMapper.findByAuditFormAuditIds(auditIds);
        Map<String, List<KmsSapOrderFormRespVo>> sapFormMap = sapFormVoArray.stream().collect(Collectors.groupingBy(KmsSapOrderFormRespVo::getAuditId));
        reqVo.setIds(auditIds);
        ArrayList acceptanceFormSuccRespVos = org.springframework.util.CollectionUtils.isEmpty(auditIds) ? Lists.newArrayList() : this.kmsAuditFormHelper.matchDataSuccList(reqVo, templateRespVo);
        Map<String, List<KmsAuditAcceptanceFormRespVo>> acceptanceFormSuccMap = acceptanceFormSuccRespVos.stream().collect(Collectors.groupingBy(KmsAuditAcceptanceFormRespVo::getAuditId));
        list.forEach(o -> {
            List accDate;
            o.setOwnedCompany((String)orgCompanyMap.get(o.getOrgCode()));
            List sapFormVos = (List)sapFormMap.get(o.getId());
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)sapFormVos)) {
                o.setSapOrderFormVos(sapFormVos);
                KmsSapOrderFormRespVo sapInfo = (KmsSapOrderFormRespVo)sapFormVos.get(0);
                if (StringUtils.isEmpty((String)o.getSoldToPartyCode())) {
                    o.setSoldToPartyCode(sapInfo.getKunag());
                    o.setSoldToPartyName(sapInfo.getKunagname());
                }
            }
            o.setSapPostingDateExport(DateUtil.format((Date)DateUtil.getDateByFormat((String)o.getSapPostingDate(), (String)"yyyyMMdd"), (String)"yyyy-MM-dd"));
            ArrayList acceptanceFormVos = org.springframework.util.CollectionUtils.isEmpty((Collection)((Collection)acceptanceFormSuccMap.get(o.getId()))) ? Lists.newArrayList() : (List)acceptanceFormSuccMap.get(o.getId());
            o.setAcceptanceFormVos((List)acceptanceFormVos);
            String auditResult = o.getAuditResult();
            KmsUtils.sapInvoiceData(o);
            BigDecimal acceptanceQuantity = o.getAcceptanceQuantity();
            BigDecimal acceptanceAmount = o.getAcceptanceAmount();
            if (!ObjectUtils.isEmpty((Object)acceptanceAmount) && !ObjectUtils.isEmpty((Object)acceptanceQuantity) && acceptanceQuantity.compareTo(BigDecimal.ZERO) == 1) {
                o.setAcceptanceDanJia(acceptanceAmount.divide(acceptanceQuantity, 2, 4));
            }
            o.setAuditResult(auditResult);
            KmsUtils.setScaleTwo(o);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)acceptanceFormVos) && (accDate = acceptanceFormVos.stream().map(KmsAuditAcceptanceFormRespVo::getAcceptanceDate).distinct().collect(Collectors.toList())).size() == 1) {
                o.setAcceptanceDate(((KmsAuditAcceptanceFormRespVo)acceptanceFormVos.get(0)).getAcceptanceDate());
            }
        });
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<KmsAuditFormRespVo> selectMatchList(KmsAuditFormReqVo kmsAuditFormReqVo) {
        return this.findList(kmsAuditFormReqVo);
    }

    @Override
    public PageResult<KmsAuditFormRespVo> matchSummaryReport(KmsAuditFormReqVo params) {
        Date date;
        AssertUtils.isNotEmpty((String)params.getAuditTemplateId(), (String)"\u5339\u914d\u6a21\u7248ID\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)params.getSapPostingDateStart(), (String)"SAP\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)params.getSapPostingDateEnd(), (String)"SAP\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        SimpleDateFormat date_sdf_2 = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat date_sdf = new SimpleDateFormat("yyyyMMdd");
        if (StringUtils.isNotEmpty((String)params.getSapPostingDateStart())) {
            String sapPostingDateStart = params.getSapPostingDateStart();
            params.setAcceptanceDateStart(sapPostingDateStart);
            date = DateUtil.str2Date((String)sapPostingDateStart, (SimpleDateFormat)date_sdf_2);
            params.setSapPostingDateStart(DateUtil.date2Str((Date)date, (SimpleDateFormat)date_sdf));
        }
        if (StringUtils.isNotEmpty((String)params.getSapPostingDateEnd())) {
            String sapPostingDateEnd = params.getSapPostingDateEnd();
            params.setAcceptanceDateEnd(sapPostingDateEnd);
            date = DateUtil.str2Date((String)sapPostingDateEnd, (SimpleDateFormat)date_sdf_2);
            params.setSapPostingDateEnd(DateUtil.date2Str((Date)date, (SimpleDateFormat)date_sdf));
        }
        List<KmsTenantryDirectCustomerOrgRespVo> directCustomerOrgRespVos = this.kmsAuditTemplateDirectMapper.findSystemDirectList(params.getAuditTemplateId());
        List bsDirectSystemIds = directCustomerOrgRespVos.stream().map(KmsTenantryDirectCustomerOrgRespVo::getBsDirectSystemId).collect(Collectors.toList());
        params.setBsDirectSystemIds(bsDirectSystemIds);
        Page page = PageUtil.buildPage((Integer)params.getPageNum(), (Integer)params.getPageSize());
        List<KmsAuditFormRespVo> list = this.kmsAuditFormMapper.matchSummaryReport((Page<KmsAuditFormRespVo>)page, params);
        list.forEach(o -> {
            String auditRule = o.getAuditRule();
            BigDecimal differencePrice = o.getDifferencePrice();
            BigDecimal sub = o.getAcceptanceAmount().subtract(o.getSapAmount());
            BigDecimal priceDiff = sub.multiply(new BigDecimal(-1));
            o.setCompareAmount(sub);
            BigDecimal subNot = o.getAcceptanceAmountNot().subtract(o.getSapAmountNot());
            o.setCompareAmountNot(subNot);
            BigDecimal subQuantity = o.getAcceptanceQuantity().subtract(o.getSapQuantity());
            o.setCompareQuantity(subQuantity);
        });
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public KmsAuditFormRespVo matchSummaryTotalCount(KmsAuditFormReqVo params) {
        Date date;
        AssertUtils.isNotEmpty((String)params.getAuditTemplateId(), (String)"\u5339\u914d\u6a21\u7248ID\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)params.getSapPostingDateStart(), (String)"SAP\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)params.getSapPostingDateEnd(), (String)"SAP\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        SimpleDateFormat date_sdf_2 = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat date_sdf = new SimpleDateFormat("yyyyMMdd");
        if (StringUtils.isNotEmpty((String)params.getSapPostingDateStart())) {
            String sapPostingDateStart = params.getSapPostingDateStart();
            params.setAcceptanceDateStart(sapPostingDateStart);
            date = DateUtil.str2Date((String)sapPostingDateStart, (SimpleDateFormat)date_sdf_2);
            params.setSapPostingDateStart(DateUtil.date2Str((Date)date, (SimpleDateFormat)date_sdf));
        }
        if (StringUtils.isNotEmpty((String)params.getSapPostingDateEnd())) {
            String sapPostingDateEnd = params.getSapPostingDateEnd();
            params.setAcceptanceDateEnd(sapPostingDateEnd);
            date = DateUtil.str2Date((String)sapPostingDateEnd, (SimpleDateFormat)date_sdf_2);
            params.setSapPostingDateEnd(DateUtil.date2Str((Date)date, (SimpleDateFormat)date_sdf));
        }
        List<KmsTenantryDirectCustomerOrgRespVo> directCustomerOrgRespVos = this.kmsAuditTemplateDirectMapper.findSystemDirectList(params.getAuditTemplateId());
        List bsDirectSystemIds = directCustomerOrgRespVos.stream().map(KmsTenantryDirectCustomerOrgRespVo::getBsDirectSystemId).collect(Collectors.toList());
        params.setBsDirectSystemIds(bsDirectSystemIds);
        KmsAuditFormRespVo respVo = this.kmsAuditFormMapper.matchSummaryTotalCount(params);
        if (respVo != null) {
            respVo.setCompareAmount(respVo.getSapAmount().subtract(respVo.getAcceptanceAmount()));
            respVo.setCompareAmountNot(respVo.getSapAmountNot().subtract(respVo.getAcceptanceAmountNot()));
            respVo.setCompareQuantity(respVo.getSapQuantity().subtract(respVo.getAcceptanceQuantity()));
            KmsUtils.setScaleTwo(respVo);
        }
        return respVo;
    }

    @Override
    public PageResult<KmsAuditFormExportRespVo> auditExport(KmsAuditFormReqVo params) {
        AssertUtils.isNotEmpty((String)params.getSapPostingDateStart(), (String)"sap\u8fc7\u8d26\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)params.getSapPostingDateStart(), (String)"sap\u8fc7\u8d26\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        PageResult<KmsAuditFormRespVo> list = this.findList(params);
        List<KmsAuditFormExportRespVo> exportRespVos = this.kmsAuditFormHelper.buildAuditExport(list.getData());
        return PageResult.builder().data(exportRespVos).count(list.getCount()).build();
    }

    @Override
    public KmsAuditFormRespVo query(KmsAuditFormReqVo reqVo) {
        String auditFormId = reqVo.getId();
        AssertUtils.isNotEmpty((String)auditFormId, (String)"\u8bf7\u9009\u62e9\u6570\u636e");
        KmsAuditFormEntity byId = (KmsAuditFormEntity)this.getById((Serializable)((Object)auditFormId));
        if (com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isEmpty((Object)byId)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6570\u636e\u4fe1\u606f");
        }
        KmsAuditFormRespVo respVo = (KmsAuditFormRespVo)CrmBeanUtil.copy((Object)byId, KmsAuditFormRespVo.class);
        List<KmsSapOrderFormRespVo> sapFormVos = this.kmsSapInvoiceMapper.findByAuditFormId(auditFormId);
        sapFormVos.forEach(o -> o.setSapMaterielCode(KmsUtils.removeFrontZero(o.getSapMaterielCode())));
        respVo.setSapOrderFormVos(sapFormVos);
        String auditTemplateId = respVo.getAuditTemplateId();
        KmsAuditTemplateReqVo templateReqVo = new KmsAuditTemplateReqVo();
        templateReqVo.setId(respVo.getAuditTemplateId());
        KmsAuditTemplateRespVo templateRespVo = this.kmsAuditTemplateService.query(templateReqVo);
        this.kmsAuditFormHelper.matchDataSucc(respVo, templateRespVo);
        KmsUtils.sapInvoiceData(respVo);
        KmsUtils.setScaleTwo(respVo);
        return respVo;
    }

    @Override
    public PageResult<KmsAuditAcceptanceFormRespVo> matchedAcc(KmsAuditFormReqVo kmsAuditFormReqVo) {
        String auditFormId = kmsAuditFormReqVo.getId();
        AssertUtils.isNotEmpty((String)auditFormId, (String)"\u8bf7\u9009\u62e9\u6570\u636e");
        KmsAuditFormEntity byId = (KmsAuditFormEntity)this.getById((Serializable)((Object)auditFormId));
        if (com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isEmpty((Object)byId)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6570\u636e\u4fe1\u606f");
        }
        KmsAuditFormRespVo respVo = (KmsAuditFormRespVo)CrmBeanUtil.copy((Object)byId, KmsAuditFormRespVo.class);
        List<KmsSapOrderFormRespVo> sapFormVos = this.kmsSapInvoiceMapper.findByAuditFormId(auditFormId);
        sapFormVos.forEach(o -> o.setSapMaterielCode(KmsUtils.removeFrontZero(o.getSapMaterielCode())));
        respVo.setSapOrderFormVos(sapFormVos);
        String auditTemplateId = respVo.getAuditTemplateId();
        KmsAuditTemplateReqVo templateReqVo = new KmsAuditTemplateReqVo();
        templateReqVo.setId(respVo.getAuditTemplateId());
        KmsAuditTemplateRespVo templateRespVo = this.kmsAuditTemplateService.query(templateReqVo);
        PageResult<KmsAuditAcceptanceFormRespVo> result = this.kmsAuditFormHelper.matchedAcc(kmsAuditFormReqVo, respVo, templateRespVo);
        respVo.setAcceptanceFormVos(result.getData());
        KmsUtils.sapInvoiceData(respVo);
        KmsUtils.setScaleTwo(respVo);
        result.setData(respVo.getAcceptanceFormVos());
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)result.getData())) {
            result.getData().forEach(a -> {
                BigDecimal acceptanceQuantity;
                BigDecimal acceptanceAmount = org.springframework.util.StringUtils.isEmpty((Object)a.getAcceptanceAmount()) ? null : new BigDecimal(a.getAcceptanceAmount());
                BigDecimal bigDecimal = acceptanceQuantity = org.springframework.util.StringUtils.isEmpty((Object)a.getAcceptanceQuantity()) ? null : new BigDecimal(a.getAcceptanceQuantity());
                if (!ObjectUtils.isEmpty((Object)acceptanceAmount) && !ObjectUtils.isEmpty((Object)acceptanceQuantity) && acceptanceQuantity.compareTo(BigDecimal.ZERO) == 1) {
                    a.setDanjia(acceptanceAmount.divide(acceptanceQuantity, 2, 4));
                }
            });
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(KmsAuditFormReqVo reqVo) {
        KmsAuditFormEntity entity = (KmsAuditFormEntity)CrmBeanUtil.copy((Object)reqVo, KmsAuditFormEntity.class);
        this.save(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(KmsAuditFormReqVo reqVo) {
        KmsAuditFormEntity entity = (KmsAuditFormEntity)this.getById((Serializable)((Object)reqVo.getId()));
        this.updateById(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void confirm(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (String)"\u8bf7\u9009\u62e9\u6570\u636e");
        List kmsAuditFormEntities = this.listByIds(ids);
        UserRedis user = UserUtils.getUser();
        kmsAuditFormEntities.forEach(o -> {
            o.setAuditStatus(KmsEnum.AuditStatus.CONFIRMED.getValue());
            o.setRinisher(user.getRealname());
            o.setCompletionDate(DateUtil.formatDate());
        });
        this.updateBatchById(kmsAuditFormEntities);
    }

    @Override
    public List<KmsAuditFormRespVo> findListByIds(List<String> ids) {
        KmsAuditFormReqVo formReqVo = new KmsAuditFormReqVo();
        formReqVo.setIds(ids);
        formReqVo.setDesc("ASC");
        return this.kmsAuditFormMapper.findList(formReqVo);
    }

    @Override
    public void cancelConfirm(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (String)"\u8bf7\u9009\u62e9\u6570\u636e");
        List kmsAuditFormEntities = this.listByIds(ids);
        kmsAuditFormEntities.forEach(o -> {
            o.setAuditStatus(KmsEnum.AuditStatus.WAIT.getValue());
            o.setRinisher(null);
            o.setCompletionDate(null);
        });
        this.updateBatchById(kmsAuditFormEntities);
    }

    @Override
    public PageResult<KmsAuditAcceptanceFormRespVo> notmatchedAcceptanceFormList(KmsAcceptanceFormReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getAuditTemplateId(), (String)"\u5339\u914d\u6a21\u7248ID\u4e0d\u80fd\u4e3a\u7a7a");
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<KmsAuditAcceptanceFormRespVo> list = this.kmsAuditFormHelper.notmatchedAcceptanceFormList((Page<KmsAuditAcceptanceFormRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(KmsAuditFormReqVo reqVo) {
        KmsAuditFormEntity entity = (KmsAuditFormEntity)this.kmsAuditFormMapper.selectById((Serializable)((Object)reqVo.getId()));
        List<KmsAcceptanceMatchRelationRespVo> matchList = this.kmsAcceptanceMatchRelationMapper.findMatchList(reqVo);
        if (!org.springframework.util.CollectionUtils.isEmpty(matchList)) {
            List<String> accIds = matchList.stream().map(KmsAcceptanceMatchRelationRespVo::getRelationId).collect(Collectors.toList());
            KmsAuditFormRespVo afVo = (KmsAuditFormRespVo)CrmBeanUtil.copy((Object)entity, KmsAuditFormRespVo.class);
            String auditTemplateId = afVo.getAuditTemplateId();
            KmsAuditTemplateReqVo templateReqVo = new KmsAuditTemplateReqVo();
            templateReqVo.setId(auditTemplateId);
            KmsAuditTemplateRespVo templateRespVo = this.kmsAuditTemplateService.query(templateReqVo);
            this.kmsAuditFormHelper.findMatchDataByIds(accIds, afVo, templateRespVo);
            this.kmsAuditFormHelper.cancelMatchData(accIds, afVo, templateRespVo);
        }
        ((LambdaUpdateChainWrapper)this.kmsAuditMatchRelationService.lambdaUpdate().eq(KmsAuditMatchRelationEntity::getAuditId, (Object)reqVo.getId())).remove();
        this.kmsAuditFormMapper.deleteById((Serializable)((Object)reqVo.getId()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(KmsAuditFormReqVo reqVo) {
        List kmsAuditFormEntities = this.kmsAuditFormMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)kmsAuditFormEntities)) {
            kmsAuditFormEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(kmsAuditFormEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(KmsAuditFormReqVo reqVo) {
        List kmsAuditFormEntities = this.kmsAuditFormMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)kmsAuditFormEntities)) {
            kmsAuditFormEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(kmsAuditFormEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addRemark(KmsAuditFormReqVo kmsAuditFormReqVo) {
        AssertUtils.isNotEmpty((String)kmsAuditFormReqVo.getId(), (String)"\u8bf7\u9009\u62e9\u6570\u636e");
        AssertUtils.isNotEmpty((String)kmsAuditFormReqVo.getRemarks(), (String)"\u8bf7\u586b\u5199\u5907\u6ce8\u4fe1\u606f");
        KmsAuditFormEntity kmsAuditFormEntity = (KmsAuditFormEntity)this.kmsAuditFormMapper.selectById((Serializable)((Object)kmsAuditFormReqVo.getId()));
        if (com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isEmpty((Object)kmsAuditFormEntity)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6570\u636e\u4fe1\u606f");
        }
        kmsAuditFormEntity.setRemarks(kmsAuditFormReqVo.getRemarks());
        this.updateById(kmsAuditFormEntity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void pullSap(KmsSapOrderFormReqVo reqVo) {
        ArrayList storeCodes = Lists.newArrayList();
        ArrayList soldToPartyCodes = Lists.newArrayList();
        if (!StringUtils.isEmpty((String)reqVo.getSelectedCode())) {
            storeCodes.add("'" + KmsUtils.addZero(reqVo.getSelectedCode(), 10) + "'");
        } else if (!StringUtils.isEmpty((String)reqVo.getBsDirectSystemId())) {
            KmsTenantryDirectStoreReqVo storeReqVo = new KmsTenantryDirectStoreReqVo();
            storeReqVo.setBsDirectSystemId(reqVo.getBsDirectSystemId());
            List<KmsTenantryDirectStoreRespVo> storeMapperList = this.kmsTenantryDirectStoreMapper.findList(storeReqVo);
            if (org.springframework.util.CollectionUtils.isEmpty(storeMapperList)) {
                throw new BusinessException("\u672a\u7ef4\u62a4\u5546\u8d85\u95e8\u5e97");
            }
            List terminalCodes = storeMapperList.stream().map(KmsTenantryDirectStoreRespVo::getTerminalCode).distinct().collect(Collectors.toList());
            MdmTerminalSupplyVo supplyVo = new MdmTerminalSupplyVo();
            supplyVo.setTerminalCodeList(terminalCodes);
            List customerRespVos = (List)ApiResultUtil.objResult((Result)this.mdmTerminalSupplyFeign.findBySupply(supplyVo));
            if (CollectionUtils.isEmpty((Collection)customerRespVos)) {
                throw new BusinessException("\u672a\u67e5\u8be2\u5230\u552e\u8fbe\u65b9\u4fe1\u606f");
            }
            List<String> customerCodes = customerRespVos.stream().map(MdmCustomerRespVo::getCustomerCode).distinct().collect(Collectors.toList());
            customerCodes.forEach(o -> soldToPartyCodes.add("'" + KmsUtils.addZero(o, 10) + "'"));
        }
        reqVo.setStoreCodeList((List)storeCodes);
        reqVo.setSoldToPartyCodeList((List)soldToPartyCodes);
        Map fkartTypeMap = DictUtil.dictMap((String)KMS_FKART_TYPE);
        ArrayList fkartList = Lists.newArrayList();
        fkartTypeMap.forEach((k, v) -> fkartList.add("'" + k + "'"));
        reqVo.setInvoiceTypeList((List)fkartList);
        ArrayList companyCodeQuery = Lists.newArrayList();
        ArrayList bukrsList = Lists.newArrayList();
        reqVo.getAuditTemplateVo().forEach(o -> {
            bukrsList.add("'" + o.getSapOrgCode() + "'");
            companyCodeQuery.add(o.getSapOrgCode());
        });
        reqVo.setCompanyCodeList((List)bukrsList);
        MdmOrgSearchReqVo searchReqVo = new MdmOrgSearchReqVo();
        searchReqVo.setSapOrgCodeList((List)companyCodeQuery);
        searchReqVo.setPageSize(Integer.valueOf(companyCodeQuery.size()));
        List mdmOrgRespVos = (List)ApiResultUtil.objResult((Result)this.mdmOrgFeign.findOrgAndChildrenList(searchReqVo));
        AssertUtils.isNotEmpty((Collection)mdmOrgRespVos, (String)(((Object)companyCodeQuery).toString() + "\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u4fe1\u606f"));
        MdmOrgRespVo mdmOrg = (MdmOrgRespVo)mdmOrgRespVos.get(0);
        reqVo.setOrgCode(mdmOrg.getOrgCode());
        List<KmsSapInvoiceEntity> invoiceEntities = this.kmsSapHelper.pullHanaInvoice(reqVo);
        invoiceEntities.forEach(o -> {
            o.setOrgCode(mdmOrg.getOrgCode());
            o.setCreateOrgCode(mdmOrg.getOrgCode());
        });
        List invIds = invoiceEntities.stream().map(BaseIdEntity::getId).collect(Collectors.toList());
        reqVo.setInvoiceIds(invIds);
        this.kmsSapInvoiceService.removeByIds(invIds);
        this.kmsSapInvoiceService.saveBatch(invoiceEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void pullSapSummary(KmsSapOrderFormReqVo reqVo) {
        KmsTenantryDirectCustomerOrgEntity customerOrgEntity = (KmsTenantryDirectCustomerOrgEntity)this.tenantryDirectCustomerOrgMapper.selectById((Serializable)((Object)reqVo.getBsDirectSystemId()));
        reqVo.getAuditTemplateVo().forEach(a -> {
            List<KmsSapInvoiceRespVo> invoice = this.kmsSapInvoiceMapper.findNotSummary(reqVo.getOrgCode(), a.getId(), reqVo.getInvoiceIds());
            invoice.forEach(e -> {
                a.setDirectId(customerOrgEntity.getDirectId());
                a.setBsDirectSystemId(customerOrgEntity.getId());
                a.setBsDirectSystemCode(customerOrgEntity.getBsDirectSystemCode());
                a.setBsDirectSystemName(customerOrgEntity.getBsDirectSystemName());
            });
            if (!org.springframework.util.CollectionUtils.isEmpty(invoice)) {
                ArrayList auditFormEntities = Lists.newArrayList();
                ArrayList relationEntities = Lists.newArrayList();
                this.kmsAuditFormHelper.summary(invoice, (KmsAuditTemplateRespVo)a, auditFormEntities, relationEntities);
                if (!org.springframework.util.CollectionUtils.isEmpty((Collection)auditFormEntities)) {
                    this.saveBatch(auditFormEntities);
                }
                Map newAuditMap = auditFormEntities.stream().collect(Collectors.toMap(KmsAuditFormEntity::getAuditNumber, Function.identity()));
                relationEntities.forEach(re -> {
                    KmsAuditFormEntity auditFormEntity = (KmsAuditFormEntity)newAuditMap.get(re.getAuditNumber());
                    if (!ObjectUtils.isEmpty((Object)auditFormEntity)) {
                        re.setAuditId(auditFormEntity.getId());
                    }
                });
                this.kmsAuditMatchRelationService.saveBatch(relationEntities);
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void manualCancelmatch(KmsAuditFormReqVo kmsAuditFormReqVo) {
        AssertUtils.isNotEmpty((String)kmsAuditFormReqVo.getId(), (String)"\u4e3b\u6570\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((Collection)kmsAuditFormReqVo.getAcceptanceFormVos(), (String)"\u8bf7\u9009\u62e9\u9a8c\u6536\u5355\u4fe1\u606f");
        List<String> accIds = kmsAuditFormReqVo.getAcceptanceFormVos().stream().map(UuidVo::getId).collect(Collectors.toList());
        KmsAuditFormEntity auditFormEntity = (KmsAuditFormEntity)this.kmsAuditFormMapper.selectById((Serializable)((Object)kmsAuditFormReqVo.getId()));
        AssertUtils.isNotNull((Object)auditFormEntity, (String)"\u672a\u67e5\u8be2\u5230\u8be5\u7a3d\u6838\u6570\u636e\u4fe1\u606f");
        KmsAuditFormRespVo afVo = (KmsAuditFormRespVo)CrmBeanUtil.copy((Object)auditFormEntity, KmsAuditFormRespVo.class);
        String auditTemplateId = afVo.getAuditTemplateId();
        KmsAuditTemplateReqVo templateReqVo = new KmsAuditTemplateReqVo();
        templateReqVo.setId(auditTemplateId);
        KmsAuditTemplateRespVo templateRespVo = this.kmsAuditTemplateService.query(templateReqVo);
        this.kmsAuditFormHelper.findMatchDataByIds(accIds, afVo, templateRespVo);
        this.kmsAuditFormHelper.cancelMatchData(accIds, afVo, templateRespVo);
        List<KmsSapOrderFormRespVo> sapFormVos = this.kmsSapInvoiceMapper.findByAuditFormId(kmsAuditFormReqVo.getId());
        sapFormVos.forEach(o -> o.setSapMaterielCode(KmsUtils.removeFrontZero(o.getSapMaterielCode())));
        afVo.setSapOrderFormVos(sapFormVos);
        this.kmsAuditFormHelper.matchDataSucc(afVo, templateRespVo);
        KmsUtils.sapInvoiceData(afVo);
        KmsUtils.setScaleTwo(afVo);
        KmsUtils.updateAuditFormData(afVo, auditFormEntity);
        this.kmsAuditFormMapper.updateById(auditFormEntity);
    }

    @Override
    public KmsAuditFormRespVo manualmatchQuery(KmsAuditFormReqVo reqVo) {
        String auditFormId = reqVo.getId();
        AssertUtils.isNotEmpty((String)auditFormId, (String)"\u8bf7\u9009\u62e9\u6570\u636e");
        KmsAuditFormEntity byId = (KmsAuditFormEntity)this.getById((Serializable)((Object)auditFormId));
        if (com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isEmpty((Object)byId)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6570\u636e\u4fe1\u606f");
        }
        KmsAuditFormRespVo respVo = (KmsAuditFormRespVo)CrmBeanUtil.copy((Object)byId, KmsAuditFormRespVo.class);
        List<KmsSapOrderFormRespVo> sapFormVos = this.kmsSapInvoiceMapper.findByAuditFormId(auditFormId);
        sapFormVos.forEach(o -> o.setSapMaterielCode(KmsUtils.removeFrontZero(o.getSapMaterielCode())));
        respVo.setSapOrderFormVos(sapFormVos);
        KmsUtils.sapInvoiceData(respVo);
        KmsUtils.setScaleTwo(respVo);
        return respVo;
    }

    @Override
    public PageResult<KmsAuditAcceptanceFormRespVo> waitMatchedAcc(KmsAuditFormReqVo kmsAuditFormReqVo) {
        String auditFormId = kmsAuditFormReqVo.getId();
        AssertUtils.isNotEmpty((String)auditFormId, (String)"\u8bf7\u9009\u62e9\u6570\u636eId");
        KmsAuditFormEntity entity = (KmsAuditFormEntity)this.getById((Serializable)((Object)auditFormId));
        if (com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isEmpty((Object)entity)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6570\u636e\u4fe1\u606f");
        }
        KmsAuditFormRespVo respVo = (KmsAuditFormRespVo)CrmBeanUtil.copy((Object)entity, KmsAuditFormRespVo.class);
        List<KmsSapOrderFormRespVo> sapFormVos = this.kmsSapInvoiceMapper.findByAuditFormId(auditFormId);
        sapFormVos.forEach(o -> o.setSapMaterielCode(KmsUtils.removeFrontZero(o.getSapMaterielCode())));
        respVo.setSapOrderFormVos(sapFormVos);
        String auditTemplateId = entity.getAuditTemplateId();
        KmsAuditTemplateReqVo templateReqVo = new KmsAuditTemplateReqVo();
        templateReqVo.setId(auditTemplateId);
        KmsAuditTemplateRespVo templateRespVo = this.kmsAuditTemplateService.query(templateReqVo);
        PageResult<KmsAuditAcceptanceFormRespVo> result = this.kmsAuditFormHelper.waitMatchedAcc(kmsAuditFormReqVo, respVo, templateRespVo);
        respVo.setAcceptanceFormVos(result.getData());
        KmsUtils.sapInvoiceData(respVo);
        KmsUtils.setScaleTwo(respVo);
        result.setData(respVo.getAcceptanceFormVos());
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)result.getData())) {
            result.getData().forEach(a -> {
                BigDecimal acceptanceQuantity;
                BigDecimal acceptanceAmount = org.springframework.util.StringUtils.isEmpty((Object)a.getAcceptanceAmount()) ? null : new BigDecimal(a.getAcceptanceAmount());
                BigDecimal bigDecimal = acceptanceQuantity = org.springframework.util.StringUtils.isEmpty((Object)a.getAcceptanceQuantity()) ? null : new BigDecimal(a.getAcceptanceQuantity());
                if (!ObjectUtils.isEmpty((Object)acceptanceAmount) && !ObjectUtils.isEmpty((Object)acceptanceQuantity) && acceptanceQuantity.compareTo(BigDecimal.ZERO) == 1) {
                    a.setDanjia(acceptanceAmount.divide(acceptanceQuantity, 2, 4));
                }
            });
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void manualmatch(KmsAuditFormReqVo kmsAuditFormReqVo) {
        AssertUtils.isNotEmpty((String)kmsAuditFormReqVo.getId(), (String)"\u4e3b\u6570\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((Collection)kmsAuditFormReqVo.getAcceptanceFormVos(), (String)"\u8bf7\u9009\u62e9\u9a8c\u6536\u5355\u4fe1\u606f");
        List<String> accIds = kmsAuditFormReqVo.getAcceptanceFormVos().stream().map(UuidVo::getId).collect(Collectors.toList());
        KmsAuditFormEntity auditFormEntity = (KmsAuditFormEntity)this.kmsAuditFormMapper.selectById((Serializable)((Object)kmsAuditFormReqVo.getId()));
        AssertUtils.isNotNull((Object)auditFormEntity, (String)"\u672a\u67e5\u8be2\u5230\u8be5\u7a3d\u6838\u6570\u636e\u4fe1\u606f");
        KmsAuditFormRespVo afVo = (KmsAuditFormRespVo)CrmBeanUtil.copy((Object)auditFormEntity, KmsAuditFormRespVo.class);
        String auditTemplateId = afVo.getAuditTemplateId();
        KmsAuditTemplateReqVo templateReqVo = new KmsAuditTemplateReqVo();
        templateReqVo.setId(auditTemplateId);
        KmsAuditTemplateRespVo templateRespVo = this.kmsAuditTemplateService.query(templateReqVo);
        this.kmsAuditFormHelper.findMatchDataByIds(accIds, afVo, templateRespVo);
        this.kmsAuditFormHelper.matchDataBinding(afVo, templateRespVo);
        List<KmsSapOrderFormRespVo> sapFormVos = this.kmsSapInvoiceMapper.findByAuditFormId(kmsAuditFormReqVo.getId());
        sapFormVos.forEach(o -> o.setSapMaterielCode(KmsUtils.removeFrontZero(o.getSapMaterielCode())));
        afVo.setSapOrderFormVos(sapFormVos);
        this.kmsAuditFormHelper.matchDataSucc(afVo, templateRespVo);
        KmsUtils.sapInvoiceData(afVo);
        KmsUtils.setScaleTwo(afVo);
        KmsUtils.updateAuditFormData(afVo, auditFormEntity);
        this.kmsAuditFormMapper.updateById(auditFormEntity);
    }

    @Override
    public List<KmsAuditFormRespVo> findWaitList(KmsAuditFormReqVo formReqVo) {
        return this.kmsAuditFormMapper.findList(formReqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void auditMatch(KmsAuditFormRespVo afVo, KmsAuditTemplateRespVo templateRespVo) {
        List<KmsSapOrderFormRespVo> sapFormVos = this.kmsSapInvoiceMapper.findByAuditFormId(afVo.getId());
        sapFormVos.forEach(o -> o.setSapMaterielCode(KmsUtils.removeFrontZero(o.getSapMaterielCode())));
        afVo.setSapOrderFormVos(sapFormVos);
        this.kmsAuditFormHelper.matchData(afVo, templateRespVo);
        if (!CollectionUtils.isEmpty((Collection)afVo.getAcceptanceFormVos())) {
            this.kmsAuditFormHelper.matchDataBinding(afVo, templateRespVo);
        }
        KmsUtils.sapInvoiceData(afVo);
        KmsUtils.setScaleTwo(afVo);
        KmsAuditFormEntity auditFormEntity = (KmsAuditFormEntity)this.kmsAuditFormMapper.selectById((Serializable)((Object)afVo.getId()));
        KmsUtils.updateAuditFormData(afVo, auditFormEntity);
        this.kmsAuditFormMapper.updateById(auditFormEntity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void refreshAuditResult(KmsAuditFormReqVo formReqVo) {
        List<KmsAuditFormRespVo> formRespVos = this.kmsAuditFormMapper.findList(formReqVo);
        List<KmsSapOrderFormRespVo> sapFormVos = this.kmsSapInvoiceMapper.findList(formReqVo);
        Map<String, List<KmsSapOrderFormRespVo>> sapMap = sapFormVos.stream().collect(Collectors.groupingBy(KmsSapOrderFormRespVo::getAuditId));
        KmsAuditTemplateReqVo templateReqVo = new KmsAuditTemplateReqVo();
        templateReqVo.setIds(formRespVos.stream().map(KmsAuditFormRespVo::getAuditTemplateId).distinct().collect(Collectors.toList()));
        List<KmsAuditTemplateRespVo> templateRespVos = this.kmsAuditTemplateMapper.findList(templateReqVo);
        Map templateRespVoMap = templateRespVos.stream().collect(Collectors.toMap(UuidVo::getId, Function.identity()));
        HashMap auditResultMap = Maps.newHashMap();
        formRespVos.forEach(o -> {
            List respVos = (List)sapMap.get(o.getId());
            o.setSapOrderFormVos(respVos);
            KmsAuditTemplateRespVo templateRespVo = (KmsAuditTemplateRespVo)templateRespVoMap.get(o.getAuditTemplateId());
            this.kmsAuditFormHelper.matchDataSucc((KmsAuditFormRespVo)o, templateRespVo);
            KmsUtils.sapInvoiceData(o);
            auditResultMap.put(o.getId(), o);
        });
        List kmsAuditFormEntities = this.kmsAuditFormMapper.selectBatchIds(formReqVo.getIds());
        kmsAuditFormEntities.forEach(o -> {
            KmsAuditFormRespVo auditForm = (KmsAuditFormRespVo)auditResultMap.get(o.getId());
            if (!com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isEmpty((Object)auditForm)) {
                KmsUtils.updateAuditFormData(auditForm, o);
            }
        });
        this.updateBatchById(kmsAuditFormEntities);
    }

    public static String format(String s) {
        String str = s.replaceAll("[`qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026& amp;*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f|-]", "");
        return str;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delayedReceipt(KmsAuditFormRespVo o, KmsAuditTemplateRespVo auditTemplateRespVo) {
        if (!KmsEnum.AuditResult.WAIT.getValue().equals(o.getAuditResult()) || org.springframework.util.StringUtils.isEmpty((Object)o.getSapPostingDate())) {
            return;
        }
        this.kmsAuditFormHelper.delayedReceiptAcc(o, auditTemplateRespVo);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)o.getAcceptanceFormVos())) {
            if (KmsEnum.AuditResult.WAIT.getValue().equals(o.getAuditResult()) && o.getSapQuantity().compareTo(BigDecimal.ZERO) == 0) {
                KmsAuditFormEntity auditFormEntity = (KmsAuditFormEntity)this.kmsAuditFormMapper.selectById((Serializable)((Object)o.getId()));
                auditFormEntity.setAuditResult(KmsEnum.AuditResult.NO_DIFFERENCE.getValue());
                this.kmsAuditFormMapper.updateById(auditFormEntity);
            }
        } else {
            ArrayList zAcc = Lists.newArrayList();
            ArrayList fAcc = Lists.newArrayList();
            o.getAcceptanceFormVos().forEach(a -> {
                if (a.getDifferenceDay().compareTo(BigDecimal.ZERO) < 0) {
                    fAcc.add(a);
                }
                if (a.getDifferenceDay().compareTo(BigDecimal.ZERO) >= 0) {
                    zAcc.add(a);
                }
            });
            ArrayList accFormRespList = Lists.newArrayList();
            List negativeSapList = o.getSapOrderFormVos().stream().filter(s -> s.getSapQuantity().compareTo(BigDecimal.ZERO) == -1).collect(Collectors.toList());
            o.getSapOrderFormVos().stream().filter(s -> s.getSapQuantity().compareTo(BigDecimal.ZERO) == 1).forEach(s -> {
                List counteract = negativeSapList.stream().filter(n -> s.getSapQuantity().compareTo(n.getSapQuantity().multiply(new BigDecimal(-1))) == 0).collect(Collectors.toList());
                if (org.springframework.util.CollectionUtils.isEmpty(counteract)) {
                    int j = 7;
                    for (int i = 1; i <= j; ++i) {
                        List selection;
                        int flag = i;
                        List selected = o.getAcceptanceFormVos().stream().filter(za -> za.getDifferenceDay().compareTo(new BigDecimal(flag)) == 0 && !StringUtils.isEmpty((String)za.getAcceptanceQuantity()) && new BigDecimal(za.getAcceptanceQuantity()).compareTo(s.getSapQuantity()) == 0).collect(Collectors.toList());
                        if (org.springframework.util.CollectionUtils.isEmpty(selected) || org.springframework.util.CollectionUtils.isEmpty(selection = selected.stream().filter(se -> !accFormRespList.contains(se)).collect(Collectors.toList()))) continue;
                        accFormRespList.add(selection.get(0));
                        break;
                    }
                }
            });
            o.setAcceptanceFormVos((List)accFormRespList);
            if (!CollectionUtils.isEmpty((Collection)o.getAcceptanceFormVos())) {
                this.kmsAuditFormHelper.matchDataBinding(o, auditTemplateRespVo);
            }
            KmsUtils.sapInvoiceData(o);
            KmsUtils.setScaleTwo(o);
            KmsAuditFormEntity auditFormEntity = (KmsAuditFormEntity)this.kmsAuditFormMapper.selectById((Serializable)((Object)o.getId()));
            KmsUtils.updateAuditFormData(o, auditFormEntity);
            if (!KmsEnum.AuditResult.WAIT.getValue().equals(auditFormEntity.getAuditResult())) {
                auditFormEntity.setRemarks(o.getRemarks());
            } else if (o.getSapQuantity().compareTo(BigDecimal.ZERO) == 0) {
                auditFormEntity.setAuditResult(KmsEnum.AuditResult.NO_DIFFERENCE.getValue());
            }
            this.kmsAuditFormMapper.updateById(auditFormEntity);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void submitUnmatchedAcce(KmsAuditFormReqVo kmsAuditFormReqVo) {
        AssertUtils.isNotEmpty((String)kmsAuditFormReqVo.getAcceptanceId(), (String)"\u672a\u5339\u914d\u9a8c\u6536\u5355[acceptanceId]\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)kmsAuditFormReqVo.getId(), (String)"\u6240\u9009\u7a3d\u6838\u6570\u636eId\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList accIds = Lists.newArrayList();
        accIds.add(kmsAuditFormReqVo.getAcceptanceId());
        KmsAuditFormEntity auditFormEntity = (KmsAuditFormEntity)this.kmsAuditFormMapper.selectById((Serializable)((Object)kmsAuditFormReqVo.getId()));
        AssertUtils.isNotNull((Object)auditFormEntity, (String)"\u672a\u67e5\u8be2\u5230\u8be5\u7a3d\u6838\u6570\u636e\u4fe1\u606f");
        KmsAuditFormRespVo afVo = (KmsAuditFormRespVo)CrmBeanUtil.copy((Object)auditFormEntity, KmsAuditFormRespVo.class);
        String auditTemplateId = afVo.getAuditTemplateId();
        KmsAuditTemplateReqVo templateReqVo = new KmsAuditTemplateReqVo();
        templateReqVo.setId(auditTemplateId);
        KmsAuditTemplateRespVo templateRespVo = this.kmsAuditTemplateService.query(templateReqVo);
        this.kmsAuditFormHelper.findMatchDataByIds(accIds, afVo, templateRespVo);
        this.kmsAuditFormHelper.matchDataBinding(afVo, templateRespVo);
        List<KmsSapOrderFormRespVo> sapFormVos = this.kmsSapInvoiceMapper.findByAuditFormId(kmsAuditFormReqVo.getId());
        sapFormVos.forEach(o -> o.setSapMaterielCode(KmsUtils.removeFrontZero(o.getSapMaterielCode())));
        afVo.setSapOrderFormVos(sapFormVos);
        this.kmsAuditFormHelper.matchDataSucc(afVo, templateRespVo);
        KmsUtils.sapInvoiceData(afVo);
        KmsUtils.setScaleTwo(afVo);
        KmsUtils.updateAuditFormData(afVo, auditFormEntity);
        this.kmsAuditFormMapper.updateById(auditFormEntity);
    }
}

