/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.finance.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.finance.helper.KmsAuditTemplateHelper;
import com.biz.crm.finance.mapper.KmsAuditTemplateDirectMapper;
import com.biz.crm.finance.mapper.KmsAuditTemplateMapper;
import com.biz.crm.finance.model.KmsAuditTemplateDirectEntity;
import com.biz.crm.finance.model.KmsAuditTemplateEntity;
import com.biz.crm.finance.service.IKmsAuditTemplateDirectService;
import com.biz.crm.finance.service.IKmsAuditTemplateService;
import com.biz.crm.nebular.kms.finance.req.KmsAuditTemplateDirectReqVo;
import com.biz.crm.nebular.kms.finance.req.KmsAuditTemplateReqVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditTemplateDirectRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditTemplateRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.PageUtil;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"KmsAuditTemplateServiceExpandImpl"})
public class KmsAuditTemplateServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<KmsAuditTemplateMapper, KmsAuditTemplateEntity>
implements IKmsAuditTemplateService {
    private static final Logger log = LoggerFactory.getLogger(KmsAuditTemplateServiceImpl.class);
    @Resource
    private KmsAuditTemplateMapper kmsAuditTemplateMapper;
    @Resource
    private KmsAuditTemplateHelper kmsAuditTemplateHelper;
    @Resource
    private IKmsAuditTemplateDirectService kmsAuditTemplateDirectService;
    @Resource
    private KmsAuditTemplateDirectMapper kmsAuditTemplateDirectMapper;
    @Resource
    private CrmLogSendUtil crmLogSendUtil;

    @Override
    public PageResult<KmsAuditTemplateRespVo> findList(KmsAuditTemplateReqVo reqVo) {
        Map auditConditionMap = DictUtil.dictMap((String)"kms_audit_condition");
        Map orderTypeMap = DictUtil.dictMap((String)"kms_order_type");
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        reqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        List<KmsAuditTemplateRespVo> list = this.kmsAuditTemplateMapper.findList((Page<KmsAuditTemplateRespVo>)page, reqVo);
        list.forEach(o -> {
            o.setConditionList(Arrays.asList(o.getConditionArray().split(",")));
            o.setOrderTypeList(Arrays.asList(o.getOrderTypeArray().split(",")));
            o.setConditionArray(o.getConditionList().stream().map(c -> (String)auditConditionMap.get(c)).collect(Collectors.joining(",")));
            o.setOrderTypeArray(o.getOrderTypeList().stream().map(c -> (String)orderTypeMap.get(c)).collect(Collectors.joining(",")));
        });
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public KmsAuditTemplateRespVo query(KmsAuditTemplateReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"\u4e3b\u952eID\u4e0d\u80fd\u4e3a\u7a7a");
        KmsAuditTemplateEntity entity = (KmsAuditTemplateEntity)this.getById((Serializable)((Object)reqVo.getId()));
        AssertUtils.isNotNull((Object)entity, (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\u4fe1\u606f");
        KmsAuditTemplateRespVo respVo = (KmsAuditTemplateRespVo)CrmBeanUtil.copy((Object)entity, KmsAuditTemplateRespVo.class);
        respVo.setConditionList(Arrays.asList(respVo.getConditionArray().split(",")));
        respVo.setOrderTypeList(Arrays.asList(respVo.getOrderTypeArray().split(",")));
        ArrayList auditTemplateIds = Lists.newArrayList();
        auditTemplateIds.add(respVo.getId());
        KmsAuditTemplateDirectReqVo directReqVo = new KmsAuditTemplateDirectReqVo();
        directReqVo.setAuditTemplateIds((List)auditTemplateIds);
        directReqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        List<KmsAuditTemplateDirectRespVo> directRespVos = this.kmsAuditTemplateDirectMapper.findList(directReqVo);
        respVo.setDirectVos(directRespVos);
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(KmsAuditTemplateReqVo reqVo) {
        this.kmsAuditTemplateHelper.check(reqVo);
        KmsAuditTemplateEntity entity = (KmsAuditTemplateEntity)CrmBeanUtil.copy((Object)reqVo, KmsAuditTemplateEntity.class);
        this.save(entity);
        reqVo.setId(entity.getId());
        List<KmsAuditTemplateDirectEntity> directEntities = this.kmsAuditTemplateHelper.buildAuditDirect(reqVo);
        this.kmsAuditTemplateDirectService.saveBatch(directEntities);
        KmsAuditTemplateRespVo newDate = (KmsAuditTemplateRespVo)CrmBeanUtil.copy((Object)entity, KmsAuditTemplateRespVo.class);
        newDate.setDirectVos(CrmBeanUtil.copyList(directEntities, KmsAuditTemplateDirectRespVo.class));
        Object menuCode = ThreadLocalUtil.getObj((String)"menuCode");
        this.crmLogSendUtil.sendForAdd(menuCode.toString(), newDate.getId(), newDate.getId(), (Object)newDate);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(KmsAuditTemplateReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"\u8bf7\u9009\u62e9\u6570\u636e");
        this.kmsAuditTemplateHelper.check(reqVo);
        KmsAuditTemplateEntity entity = (KmsAuditTemplateEntity)this.getById((Serializable)((Object)reqVo.getId()));
        AssertUtils.isNotNull((Object)entity, (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\u4fe1\u606f");
        entity.setTemplateName(reqVo.getTemplateName());
        entity.setConditionArray(reqVo.getConditionArray());
        entity.setOrderTypeArray(reqVo.getOrderTypeArray());
        KmsAuditTemplateRespVo oldData = this.query(reqVo);
        this.updateById(entity);
        ((LambdaUpdateChainWrapper)this.kmsAuditTemplateDirectService.lambdaUpdate().eq(KmsAuditTemplateDirectEntity::getAuditTemplateId, (Object)entity.getId())).remove();
        List<KmsAuditTemplateDirectEntity> directEntities = this.kmsAuditTemplateHelper.buildAuditDirect(reqVo);
        this.kmsAuditTemplateDirectService.saveBatch(directEntities);
        KmsAuditTemplateRespVo newData = this.query(reqVo);
        Object menuCode = ThreadLocalUtil.getObj((String)"menuCode");
        this.crmLogSendUtil.sendForUpdate(menuCode.toString(), newData.getId(), newData.getId(), (Object)newData, (Object)oldData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(KmsAuditTemplateReqVo reqVo) {
        List kmsAuditTemplateEntities = this.kmsAuditTemplateMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)kmsAuditTemplateEntities)) {
            kmsAuditTemplateEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(kmsAuditTemplateEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(KmsAuditTemplateReqVo reqVo) {
        List kmsAuditTemplateEntities = this.kmsAuditTemplateMapper.selectBatchIds(reqVo.getIds());
        List oldDataList = CrmBeanUtil.copyList((List)kmsAuditTemplateEntities, KmsAuditTemplateRespVo.class);
        if (CollectionUtils.isNotEmpty((Collection)kmsAuditTemplateEntities)) {
            kmsAuditTemplateEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(kmsAuditTemplateEntities);
        List newDataList = CrmBeanUtil.copyList((List)kmsAuditTemplateEntities, KmsAuditTemplateRespVo.class);
        Object menuCode = ThreadLocalUtil.getObj((String)"menuCode");
        for (int i = 0; i < newDataList.size(); ++i) {
            this.crmLogSendUtil.sendForUpdate(menuCode.toString(), ((KmsAuditTemplateRespVo)newDataList.get(i)).getId(), ((KmsAuditTemplateRespVo)newDataList.get(i)).getId(), newDataList.get(i), oldDataList.get(i));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(KmsAuditTemplateReqVo reqVo) {
        List kmsAuditTemplateEntities = this.kmsAuditTemplateMapper.selectBatchIds(reqVo.getIds());
        List oldDataList = CrmBeanUtil.copyList((List)kmsAuditTemplateEntities, KmsAuditTemplateRespVo.class);
        if (CollectionUtils.isNotEmpty((Collection)kmsAuditTemplateEntities)) {
            kmsAuditTemplateEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(kmsAuditTemplateEntities);
        List newDataList = CrmBeanUtil.copyList((List)kmsAuditTemplateEntities, KmsAuditTemplateRespVo.class);
        Object menuCode = ThreadLocalUtil.getObj((String)"menuCode");
        for (int i = 0; i < newDataList.size(); ++i) {
            this.crmLogSendUtil.sendForUpdate(menuCode.toString(), ((KmsAuditTemplateRespVo)newDataList.get(i)).getId(), ((KmsAuditTemplateRespVo)newDataList.get(i)).getId(), newDataList.get(i), oldDataList.get(i));
        }
    }

    @Override
    public List<KmsAuditTemplateRespVo> findAll(KmsAuditTemplateReqVo templateReqVo) {
        List<KmsAuditTemplateRespVo> all = this.kmsAuditTemplateMapper.findAll(templateReqVo);
        if (org.springframework.util.CollectionUtils.isEmpty(all)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6a21\u7248\u4fe1\u606f!");
        }
        List auditTemplateIds = all.stream().map(UuidVo::getId).collect(Collectors.toList());
        KmsAuditTemplateDirectReqVo directReqVo = new KmsAuditTemplateDirectReqVo();
        directReqVo.setAuditTemplateIds(auditTemplateIds);
        directReqVo.setBsDirectSystemId(templateReqVo.getBsDirectSystemId());
        directReqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        directReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        List<KmsAuditTemplateDirectRespVo> directRespVos = this.kmsAuditTemplateDirectMapper.findList(directReqVo);
        Map<String, List<KmsAuditTemplateDirectRespVo>> directRespVosMap = directRespVos.stream().collect(Collectors.groupingBy(KmsAuditTemplateDirectRespVo::getAuditTemplateId));
        all.forEach(o -> {
            List respVos = (List)directRespVosMap.get(o.getId());
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)respVos) && !StringUtils.isEmpty((Object)templateReqVo.getBsDirectSystemId())) {
                throw new BusinessException("\u7a3d\u6838\u6a21\u7248\u672a\u7ef4\u62a4\u8be5\u5546\u8d85");
            }
            o.setDirectVos(respVos);
        });
        return all;
    }
}

